/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterSecurityManager {
    private static final Logger LOG = LoggerFactory.getLogger(RouterSecurityManager.class);
    private AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> dtSecretManager = null;

    public RouterSecurityManager(Configuration conf) throws IOException {
        UserGroupInformation.AuthenticationMethod authMethodConfigured = SecurityUtil.getAuthenticationMethod((Configuration)conf);
        UserGroupInformation.AuthenticationMethod authMethodToInit = UserGroupInformation.AuthenticationMethod.KERBEROS;
        if (authMethodConfigured.equals((Object)authMethodToInit)) {
            this.dtSecretManager = FederationUtil.newSecretManager(conf);
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                throw new IOException("Failed to create SecretManager");
            }
        }
    }

    @VisibleForTesting
    public RouterSecurityManager(AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> dtSecretManager) {
        this.dtSecretManager = dtSecretManager;
    }

    public AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> getSecretManager() {
        return this.dtSecretManager;
    }

    public void stop() {
        LOG.info("Stopping security manager");
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return RouterRpcServer.getRemoteUser();
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = RouterSecurityManager.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token;
        LOG.debug("Generate delegation token with renewer " + renewer);
        String operationName = "getDelegationToken";
        boolean success = false;
        String tokenId = "";
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn("trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = RouterSecurityManager.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token((TokenIdentifier)dtId, this.dtSecretManager);
            tokenId = dtId.toStringStable();
            success = true;
        }
        finally {
            this.logAuditEvent(success, "getDelegationToken", tokenId);
        }
        return token;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        long expiryTime;
        LOG.debug("Renew delegation token");
        String operationName = "renewDelegationToken";
        boolean success = false;
        String tokenId = "";
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
            }
            String renewer = RouterSecurityManager.getRemoteUser().getShortUserName();
            expiryTime = this.dtSecretManager.renewToken(token, renewer);
            DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
            tokenId = id.toStringStable();
            success = true;
        }
        catch (AccessControlException ace) {
            DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
            tokenId = id.toStringStable();
            throw ace;
        }
        finally {
            this.logAuditEvent(success, "renewDelegationToken", tokenId);
        }
        return expiryTime;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        LOG.debug("Cancel delegation token");
        String operationName = "cancelDelegationToken";
        boolean success = false;
        String tokenId = "";
        try {
            String canceller = RouterSecurityManager.getRemoteUser().getUserName();
            LOG.info("Cancel request by " + canceller);
            DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
            tokenId = id.toStringStable();
            success = true;
        }
        catch (AccessControlException ace) {
            DelegationTokenIdentifier id = DFSUtil.decodeDelegationToken(token);
            tokenId = id.toStringStable();
            throw ace;
        }
        finally {
            this.logAuditEvent(success, "cancelDelegationToken", tokenId);
        }
    }

    public static Credentials createCredentials(Router router, UserGroupInformation ugi, String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = router.getRpcServer().getDelegationToken(new Text(renewer));
        if (token == null) {
            return null;
        }
        InetSocketAddress addr = router.getRpcServerAddress();
        SecurityUtil.setTokenService(token, (InetSocketAddress)addr);
        Credentials c = new Credentials();
        c.addToken(new Text(ugi.getShortUserName()), token);
        return c;
    }

    public void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken {
        this.dtSecretManager.verifyToken((AbstractDelegationTokenIdentifier)identifier, password);
    }

    void logAuditEvent(boolean succeeded, String cmd, String tokenId) throws IOException {
        LOG.debug("Operation:" + cmd + " Status:" + succeeded + " TokenId:" + tokenId);
    }
}

