/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.avro.reflect.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;

@KerberosInfo(serverPrincipal="dfs.namenode.kerberos.principal")
@TokenInfo(value=DelegationTokenSelector.class)
@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface ClientProtocol
extends VersionedProtocol {
    public static final long versionID = 65L;
    public static final int GET_STATS_CAPACITY_IDX = 0;
    public static final int GET_STATS_USED_IDX = 1;
    public static final int GET_STATS_REMAINING_IDX = 2;
    public static final int GET_STATS_UNDER_REPLICATED_IDX = 3;
    public static final int GET_STATS_CORRUPT_BLOCKS_IDX = 4;
    public static final int GET_STATS_MISSING_BLOCKS_IDX = 5;
    public static final String __PARANAMER_DATA = "complete java.lang.String,java.lang.String,org.apache.hadoop.hdfs.protocol.Block src,clientName,last \ndelete java.lang.String src \ndelete java.lang.String,boolean src,recursive \nmkdirs java.lang.String,org.apache.hadoop.fs.permission.FsPermission,boolean src,masked,createParent \nrecoverLease java.lang.String,java.lang.String src,clientName \nrename java.lang.String,java.lang.String src,dst \nrestoreFailedStorage java.lang.String arg \nsetReplication java.lang.String,short src,replication \nsetSafeMode org.apache.hadoop.hdfs.protocol.FSConstants.SafeModeAction action \ngetLinkTarget java.lang.String path \ngetPreferredBlockSize java.lang.String filename \nrenewDelegationToken org.apache.hadoop.security.token.Token token \ngetContentSummary java.lang.String path \ngetDatanodeReport org.apache.hadoop.hdfs.protocol.FSConstants.DatanodeReportType type \ngetListing java.lang.String,byte[],boolean src,startAfter,needLocation \ngetFileInfo java.lang.String src \ngetFileLinkInfo java.lang.String src \naddBlock java.lang.String,java.lang.String,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.DatanodeInfo[] src,clientName,previous,excludeNodes \nappend java.lang.String,java.lang.String src,clientName \nupdateBlockForPipeline org.apache.hadoop.hdfs.protocol.Block,java.lang.String block,clientName \ngetBlockLocations java.lang.String,long,long src,offset,length \ndistributedUpgradeProgress org.apache.hadoop.hdfs.protocol.FSConstants.UpgradeAction action \ngetDelegationToken org.apache.hadoop.io.Text renewer \nabandonBlock org.apache.hadoop.hdfs.protocol.Block,java.lang.String,java.lang.String b,src,holder \ncancelDelegationToken org.apache.hadoop.security.token.Token token \nconcat java.lang.String,java.lang.String[] trg,srcs \ncreate java.lang.String,org.apache.hadoop.fs.permission.FsPermission,java.lang.String,org.apache.hadoop.io.EnumSetWritable,boolean,short,long src,masked,clientName,flag,createParent,replication,blockSize \ncreateSymlink java.lang.String,java.lang.String,org.apache.hadoop.fs.permission.FsPermission,boolean target,link,dirPerm,createParent \nfsync java.lang.String,java.lang.String src,client \nmetaSave java.lang.String filename \nrename java.lang.String,java.lang.String,org.apache.hadoop.fs.Options.Rename src,dst,options \nrenewLease java.lang.String clientName \nreportBadBlocks org.apache.hadoop.hdfs.protocol.LocatedBlock[] blocks \nsetOwner java.lang.String,java.lang.String,java.lang.String src,username,groupname \nsetPermission java.lang.String,org.apache.hadoop.fs.permission.FsPermission src,permission \nsetQuota java.lang.String,long,long path,namespaceQuota,diskspaceQuota \nsetTimes java.lang.String,long,long src,mtime,atime \nupdatePipeline java.lang.String,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.DatanodeID[] clientName,oldBlock,newBlock,newNodes \n";

    @Nullable
    public LocatedBlocks getBlockLocations(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public FsServerDefaults getServerDefaults() throws IOException;

    public void create(String var1, FsPermission var2, String var3, EnumSetWritable<CreateFlag> var4, boolean var5, short var6, long var7) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    public LocatedBlock append(String var1, String var2) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public boolean setReplication(String var1, short var2) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public void setPermission(String var1, FsPermission var2) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public void setOwner(String var1, String var2, String var3) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public void abandonBlock(Block var1, String var2, String var3) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public LocatedBlock addBlock(String var1, String var2, @Nullable Block var3, @Nullable DatanodeInfo[] var4) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException;

    public boolean complete(String var1, String var2, Block var3) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public void reportBadBlocks(LocatedBlock[] var1) throws IOException;

    @Deprecated
    public boolean rename(String var1, String var2) throws UnresolvedLinkException, IOException;

    public void concat(String var1, String[] var2) throws IOException, UnresolvedLinkException;

    public void rename(String var1, String var2, Options.Rename ... var3) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    @Deprecated
    public boolean delete(String var1) throws IOException, UnresolvedLinkException;

    public boolean delete(String var1, boolean var2) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public boolean mkdirs(String var1, FsPermission var2, boolean var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    public DirectoryListing getListing(String var1, byte[] var2, boolean var3) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void renewLease(String var1) throws AccessControlException, IOException;

    public boolean recoverLease(String var1, String var2) throws IOException;

    public long[] getStats() throws IOException;

    public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType var1) throws IOException;

    public long getPreferredBlockSize(String var1) throws IOException, UnresolvedLinkException;

    public boolean setSafeMode(FSConstants.SafeModeAction var1) throws IOException;

    public void saveNamespace() throws AccessControlException, IOException;

    public boolean restoreFailedStorage(String var1) throws AccessControlException;

    public void refreshNodes() throws IOException;

    public void finalizeUpgrade() throws IOException;

    @Nullable
    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction var1) throws IOException;

    public void metaSave(String var1) throws IOException;

    @Nullable
    public HdfsFileStatus getFileInfo(String var1) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public HdfsFileStatus getFileLinkInfo(String var1) throws AccessControlException, UnresolvedLinkException, IOException;

    public ContentSummary getContentSummary(String var1) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void setQuota(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void fsync(String var1, String var2) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void setTimes(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void createSymlink(String var1, String var2, FsPermission var3, boolean var4) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    public String getLinkTarget(String var1) throws AccessControlException, FileNotFoundException, IOException;

    public LocatedBlock updateBlockForPipeline(Block var1, String var2) throws IOException;

    public void updatePipeline(String var1, Block var2, Block var3, DatanodeID[] var4) throws IOException;

    public Token<DelegationTokenIdentifier> getDelegationToken(Text var1) throws IOException;

    public long renewDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;
}

