/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsLocatedFileStatus
extends HdfsFileStatus {
    private LocatedBlocks locations;
    public static final String __PARANAMER_DATA = "<init> long,boolean,int,long,long,long,org.apache.hadoop.fs.permission.FsPermission,java.lang.String,java.lang.String,byte[],byte[],org.apache.hadoop.hdfs.protocol.LocatedBlocks length,isdir,block_replication,blocksize,modification_time,access_time,permission,owner,group,symlink,path,locations \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public HdfsLocatedFileStatus() {
    }

    public HdfsLocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] symlink, byte[] path, LocatedBlocks locations) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path);
        this.locations = locations;
    }

    public LocatedBlocks getBlockLocations() {
        return this.locations;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (!this.isDir() && !this.isSymlink()) {
            this.locations.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (!this.isDir() && !this.isSymlink()) {
            this.locations = new LocatedBlocks();
            this.locations.readFields(in);
        }
    }
}

