/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class LayoutVersion {
    static final Map<Integer, EnumSet<Feature>> map = new HashMap<Integer, EnumSet<Feature>>();
    public static final String __PARANAMER_DATA = "supports org.apache.hadoop.hdfs.protocol.LayoutVersion.Feature,int f,lv \n";

    private static void initMap() {
        for (Feature f : Feature.values()) {
            EnumSet<Feature> ancestorSet = map.get(f.ancestorLV);
            if (ancestorSet == null) {
                ancestorSet = EnumSet.noneOf(Feature.class);
                map.put(f.ancestorLV, ancestorSet);
            }
            EnumSet<Feature> featureSet = EnumSet.copyOf(ancestorSet);
            featureSet.add(f);
            map.put(f.lv, featureSet);
        }
        LayoutVersion.specialInit(Feature.RESERVED_REL20_203.lv, Feature.DELEGATION_TOKEN);
        LayoutVersion.specialInit(Feature.RESERVED_REL20_204.lv, Feature.DELEGATION_TOKEN);
    }

    private static void specialInit(int lv, Feature f) {
        EnumSet<Feature> set = map.get(lv);
        set.add(f);
    }

    public static String getString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature List:\n");
        for (Feature f : Feature.values()) {
            buf.append((Object)f).append(" introduced in layout version ").append(f.lv).append(" (").append(f.description).append(")\n");
        }
        buf.append("\n\nLayoutVersion and supported features:\n");
        for (Feature f : Feature.values()) {
            buf.append(f.lv).append(": ").append(map.get(f.lv)).append("\n");
        }
        return buf.toString();
    }

    public static boolean supports(Feature f, int lv) {
        EnumSet<Feature> set = map.get(lv);
        return set != null && set.contains((Object)f);
    }

    public static int getCurrentLayoutVersion() {
        Feature[] values = Feature.values();
        return values[values.length - 1].lv;
    }

    static {
        LayoutVersion.initMap();
    }

    public static enum Feature {
        NAMESPACE_QUOTA(-16, "Support for namespace quotas"),
        FILE_ACCESS_TIME(-17, "Support for access time on files"),
        DISKSPACE_QUOTA(-18, "Support for disk space quotas"),
        STICKY_BIT(-19, "Support for sticky bits"),
        APPEND_RBW_DIR(-20, "Datanode has \"rbw\" subdirectory for append"),
        ATOMIC_RENAME(-21, "Support for atomic rename"),
        CONCAT(-22, "Support for concat operation"),
        SYMLINKS(-23, "Support for symbolic links"),
        DELEGATION_TOKEN(-24, "Support for delegation tokens for security"),
        FSIMAGE_COMPRESSION(-25, "Support for fsimage compression"),
        FSIMAGE_CHECKSUM(-26, "Support checksum for fsimage"),
        REMOVE_REL13_DISK_LAYOUT_SUPPORT(-27, "Remove support for 0.13 disk layout"),
        UNUSED_28(-28, "Support checksum for editlog"),
        UNUSED_29(-29, "Skipped version"),
        UNUSED_30(-30, "Store only last part of path in fsimage"),
        RESERVED_REL20_203(-31, -19, "Reserved for release 0.20.203"),
        RESERVED_REL20_204(-32, "Reserved for release 0.20.204"),
        RESERVED_REL22(-33, -27, "Reserved for release 0.22");

        final int lv;
        final int ancestorLV;
        final String description;
        public static final String __PARANAMER_DATA = "<init> int,int,java.lang.String lv,ancestorLV,description \n<init> int,java.lang.String lv,description \n";

        private Feature(int lv, String description) {
            this(lv, lv + 1, description);
        }

        private Feature(int lv, int ancestorLV, String description) {
            this.lv = lv;
            this.ancestorLV = ancestorLV;
            this.description = description;
        }
    }
}

