/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetAsyncDiskService;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.ReplicasMap;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class FSDataset
implements FSConstants,
FSDatasetInterface {
    public static final String METADATA_EXTENSION = ".meta";
    public static final short METADATA_VERSION = 1;
    static final String UNLINK_BLOCK_SUFFIX = ".unlinked";
    FSVolumeSet volumes;
    private int maxBlocksPerDir = 0;
    ReplicasMap volumeMap = new ReplicasMap();
    static Random random = new Random();
    FSDatasetAsyncDiskService asyncDiskService;
    private int validVolsRequired;
    private Object statsLock = new Object();
    boolean supportAppends = true;
    private static final String DISK_ERROR = "Possible disk error on file creation: ";
    private ObjectName mbeanName;
    private Random rand = new Random();

    private static boolean isUnlinkTmpFile(File f) {
        String name = f.getName();
        return name.endsWith(UNLINK_BLOCK_SUFFIX);
    }

    static File getUnlinkTmpFile(File f) {
        return new File(f.getParentFile(), f.getName() + UNLINK_BLOCK_SUFFIX);
    }

    private static File getOrigFile(File unlinkTmpFile) {
        String fileName = unlinkTmpFile.getName();
        return new File(unlinkTmpFile.getParentFile(), fileName.substring(0, fileName.length() - UNLINK_BLOCK_SUFFIX.length()));
    }

    static String getMetaFileName(String blockFileName, long genStamp) {
        return blockFileName + "_" + genStamp + METADATA_EXTENSION;
    }

    static File getMetaFile(File f, Block b) {
        return new File(FSDataset.getMetaFileName(f.getAbsolutePath(), b.getGenerationStamp()));
    }

    protected File getMetaFile(Block b) throws IOException {
        return FSDataset.getMetaFile(this.getBlockFile(b), b);
    }

    private static long getGenerationStampFromFile(File[] listdir, File blockFile) {
        String blockName = blockFile.getName();
        for (int j = 0; j < listdir.length; ++j) {
            String path = listdir[j].getName();
            if (!path.startsWith(blockName) || blockFile == listdir[j]) continue;
            return Block.getGenerationStamp(listdir[j].getName());
        }
        DataNode.LOG.warn((Object)("Block " + blockFile + " does not have a metafile!"));
        return 0L;
    }

    private static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(FSDataset.METADATA_EXTENSION);
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    private static long parseGenerationStamp(File blockFile, File metaFile) throws IOException {
        String metaname = metaFile.getName();
        String gs = metaname.substring(blockFile.getName().length() + 1, metaname.length() - METADATA_EXTENSION.length());
        try {
            return Long.parseLong(gs);
        }
        catch (NumberFormatException nfe) {
            throw (IOException)new IOException("blockFile=" + blockFile + ", metaFile=" + metaFile).initCause(nfe);
        }
    }

    public File findBlockFile(long blockId) {
        return this.getFile(blockId);
    }

    @Override
    public synchronized Block getStoredBlock(long blkid) throws IOException {
        File blockfile = this.findBlockFile(blkid);
        if (blockfile == null) {
            return null;
        }
        File metafile = FSDataset.findMetaFile(blockfile);
        return new Block(blkid, blockfile.length(), FSDataset.parseGenerationStamp(blockfile, metafile));
    }

    synchronized ReplicaInfo fetchReplicaInfo(long blockId) {
        ReplicaInfo r = this.volumeMap.get(blockId);
        if (r == null) {
            return null;
        }
        switch (r.getState()) {
            case FINALIZED: {
                return new FinalizedReplica((FinalizedReplica)r);
            }
            case RBW: {
                return new ReplicaBeingWritten((ReplicaBeingWritten)r);
            }
            case RWR: {
                return new ReplicaWaitingToBeRecovered((ReplicaWaitingToBeRecovered)r);
            }
            case RUR: {
                return new ReplicaUnderRecovery((ReplicaUnderRecovery)r);
            }
            case TEMPORARY: {
                return new ReplicaInPipeline((ReplicaInPipeline)r);
            }
        }
        return null;
    }

    @Override
    public boolean metaFileExists(Block b) throws IOException {
        return this.getMetaFile(b).exists();
    }

    @Override
    public long getMetaDataLength(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return checksumFile.length();
    }

    @Override
    public FSDatasetInterface.MetaDataInputStream getMetaDataInputStream(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return new FSDatasetInterface.MetaDataInputStream(new FileInputStream(checksumFile), checksumFile.length());
    }

    static File createTmpFile(Block b, File f) throws IOException {
        if (f.exists()) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
        }
        boolean fileCreated = false;
        try {
            fileCreated = f.createNewFile();
        }
        catch (IOException ioe) {
            throw (IOException)new IOException(DISK_ERROR + f).initCause(ioe);
        }
        if (!fileCreated) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
        }
        return f;
    }

    public FSDataset(DataStorage storage, Configuration conf) throws IOException {
        this.maxBlocksPerDir = conf.getInt("dfs.datanode.numblocks", 64);
        this.supportAppends = conf.getBoolean("dfs.support.append", true);
        int volFailuresTolerated = conf.getInt("dfs.datanode.failed.volumes.tolerated", 0);
        this.validVolsRequired = storage.getNumStorageDirs() - volFailuresTolerated;
        if (this.validVolsRequired < 1 || this.validVolsRequired > storage.getNumStorageDirs()) {
            DataNode.LOG.error((Object)("Invalid value " + volFailuresTolerated + " for " + "dfs.datanode.failed.volumes.tolerated"));
        }
        FSVolume[] volArray = new FSVolume[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            volArray[idx] = new FSVolume(storage.getStorageDir(idx).getCurrentDir(), conf);
        }
        this.volumes = new FSVolumeSet(volArray);
        this.volumes.getVolumeMap(this.volumeMap);
        File[] roots = new File[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            roots[idx] = storage.getStorageDir(idx).getCurrentDir();
        }
        this.asyncDiskService = new FSDatasetAsyncDiskService(roots);
        this.registerMBean(storage.getStorageID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDfsUsed() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getDfsUsed();
        }
    }

    @Override
    public boolean hasEnoughResource() {
        return this.volumes.numberOfVolumes() >= this.validVolsRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacity() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRemaining() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getRemaining();
        }
    }

    @Override
    public int getNumFailedVolumes() {
        return this.volumes.numberOfFailedVolumes();
    }

    @Override
    public long getLength(Block b) throws IOException {
        return this.getBlockFile(b).length();
    }

    public synchronized File getBlockFile(Block b) throws IOException {
        File f = this.validateBlockFile(b);
        if (f == null) {
            if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
                InterDatanodeProtocol.LOG.debug((Object)("b=" + b + ", volumeMap=" + this.volumeMap));
            }
            throw new IOException("Block " + b + " is not valid.");
        }
        return f;
    }

    @Override
    public synchronized InputStream getBlockInputStream(Block b) throws IOException {
        return new FileInputStream(this.getBlockFile(b));
    }

    @Override
    public synchronized InputStream getBlockInputStream(Block b, long seekOffset) throws IOException {
        File blockFile = this.getBlockFile(b);
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (seekOffset > 0L) {
            blockInFile.seek(seekOffset);
        }
        return new FileInputStream(blockInFile.getFD());
    }

    private ReplicaInfo getReplicaInfo(Block b) throws IOException {
        ReplicaInfo info = this.volumeMap.get(b);
        if (info == null) {
            throw new IOException("Block " + b + " does not exist in volumeMap.");
        }
        return info;
    }

    @Override
    public synchronized FSDatasetInterface.BlockInputStreams getTmpInputStreams(Block b, long blkOffset, long ckoff) throws IOException {
        ReplicaInfo info = this.getReplicaInfo(b);
        File blockFile = info.getBlockFile();
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (blkOffset > 0L) {
            blockInFile.seek(blkOffset);
        }
        File metaFile = info.getMetaFile();
        RandomAccessFile metaInFile = new RandomAccessFile(metaFile, "r");
        if (ckoff > 0L) {
            metaInFile.seek(ckoff);
        }
        return new FSDatasetInterface.BlockInputStreams(new FileInputStream(blockInFile.getFD()), new FileInputStream(metaInFile.getFD()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlinkBlock(Block block, int numLinks) throws IOException {
        ReplicaInfo info = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            info = this.getReplicaInfo(block);
        }
        return info.unlinkBlock(numLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void truncateBlock(File blockFile, File metaFile, long oldlen, long newlen) throws IOException {
        DataNode.LOG.info((Object)("truncateBlock: blockFile=" + blockFile + ", metaFile=" + metaFile + ", oldlen=" + oldlen + ", newlen=" + newlen));
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannout truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(metaFile).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long n = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + n * (long)checksumsize;
        long lastchunkoffset = (n - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
        try {
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        finally {
            blockRAF.close();
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        try {
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
        finally {
            metaRAF.close();
        }
    }

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    @Override
    public synchronized ReplicaInPipelineInterface append(Block b, long newGS, long expectedBlockLen) throws IOException {
        if (newGS < b.getGenerationStamp()) {
            throw new IOException("The new generation stamp " + newGS + " should be greater than the replica " + b + "'s generation stamp");
        }
        ReplicaInfo replicaInfo = this.volumeMap.get(b);
        if (replicaInfo == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        DataNode.LOG.info((Object)("Appending to replica " + replicaInfo));
        if (replicaInfo.getState() != HdfsConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + b);
        }
        if (replicaInfo.getNumBytes() != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + expectedBlockLen);
        }
        return this.append((FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
    }

    private synchronized ReplicaBeingWritten append(FinalizedReplica replicaInfo, long newGS, long estimateBlockLen) throws IOException {
        replicaInfo.unlinkBlock(1);
        File blkfile = replicaInfo.getBlockFile();
        FSVolume v = replicaInfo.getVolume();
        if (v.getAvailable() < estimateBlockLen - replicaInfo.getNumBytes()) {
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for appending to " + replicaInfo);
        }
        File newBlkFile = new File(v.rbwDir, replicaInfo.getBlockName());
        File oldmeta = replicaInfo.getMetaFile();
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(replicaInfo.getBlockId(), replicaInfo.getNumBytes(), newGS, v, newBlkFile.getParentFile(), Thread.currentThread());
        File newmeta = newReplicaInfo.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        if (!oldmeta.renameTo(newmeta)) {
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to rbw dir " + newmeta);
        }
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("Renaming " + blkfile + " to " + newBlkFile));
            DataNode.LOG.debug((Object)("Old block file length is " + blkfile.length()));
        }
        if (!blkfile.renameTo(newBlkFile)) {
            if (!newmeta.renameTo(oldmeta)) {
                DataNode.LOG.warn((Object)("Cannot move meta file " + newmeta + "back to the finalized directory " + oldmeta));
            }
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move block file " + blkfile + " to rbw dir " + newBlkFile);
        }
        this.volumeMap.add(newReplicaInfo);
        return newReplicaInfo;
    }

    private ReplicaInfo recoverCheck(Block b, long newGS, long expectedBlockLen) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockId());
        if (replicaInfo == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        if (replicaInfo.getState() != HdfsConstants.ReplicaState.FINALIZED && replicaInfo.getState() != HdfsConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover append/close to a replica that's not FINALIZED and not RBW " + replicaInfo);
        }
        long replicaGenerationStamp = replicaInfo.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpeted generation stamp " + replicaGenerationStamp + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        long replicaLen = replicaInfo.getNumBytes();
        if (replicaInfo.getState() == HdfsConstants.ReplicaState.RBW) {
            ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
            rbw.stopWriter();
            rbw.setWriter(Thread.currentThread());
            if (replicaLen != rbw.getBytesOnDisk() || replicaLen != rbw.getBytesAcked()) {
                throw new ReplicaAlreadyExistsException("RBW replica " + replicaInfo + "bytesRcvd(" + rbw.getNumBytes() + "), bytesOnDisk(" + rbw.getBytesOnDisk() + "), and bytesAcked(" + rbw.getBytesAcked() + ") are not the same.");
            }
        }
        if (replicaLen != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaLen + " expected length is " + expectedBlockLen);
        }
        return replicaInfo;
    }

    @Override
    public synchronized ReplicaInPipelineInterface recoverAppend(Block b, long newGS, long expectedBlockLen) throws IOException {
        DataNode.LOG.info((Object)("Recover failed append to " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        if (replicaInfo.getState() == HdfsConstants.ReplicaState.FINALIZED) {
            return this.append((FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
        }
        this.bumpReplicaGS(replicaInfo, newGS);
        return (ReplicaBeingWritten)replicaInfo;
    }

    @Override
    public void recoverClose(Block b, long newGS, long expectedBlockLen) throws IOException {
        DataNode.LOG.info((Object)("Recover failed close " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        this.bumpReplicaGS(replicaInfo, newGS);
        if (replicaInfo.getState() == HdfsConstants.ReplicaState.RBW) {
            this.finalizeBlock(replicaInfo);
        }
    }

    private void bumpReplicaGS(ReplicaInfo replicaInfo, long newGS) throws IOException {
        long oldGS = replicaInfo.getGenerationStamp();
        File oldmeta = replicaInfo.getMetaFile();
        replicaInfo.setGenerationStamp(newGS);
        File newmeta = replicaInfo.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        if (!oldmeta.renameTo(newmeta)) {
            replicaInfo.setGenerationStamp(oldGS);
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to " + newmeta);
        }
    }

    @Override
    public synchronized ReplicaInPipelineInterface createRbw(Block b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockId());
        if (replicaInfo != null) {
            throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
        }
        FSVolume v = this.volumes.getNextVolume(b.getNumBytes());
        File f = v.createRbwFile(b);
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile());
        this.volumeMap.add(newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public synchronized ReplicaInPipelineInterface recoverRbw(Block b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        DataNode.LOG.info((Object)("Recover the RBW replica " + b));
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockId());
        if (replicaInfo == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        if (replicaInfo.getState() != HdfsConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover a non-RBW replica " + replicaInfo);
        }
        ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
        DataNode.LOG.info((Object)("Recovering replica " + rbw));
        rbw.stopWriter();
        rbw.setWriter(Thread.currentThread());
        long replicaGenerationStamp = rbw.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpeted generation stamp " + b + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        if (rbw.getBytesAcked() < minBytesRcvd || rbw.getNumBytes() > maxBytesRcvd) {
            throw new ReplicaNotFoundException("Unmatched length replica " + replicaInfo + ": BytesAcked = " + rbw.getBytesAcked() + " BytesRcvd = " + rbw.getNumBytes() + " are not in the range of [" + minBytesRcvd + ", " + maxBytesRcvd + "].");
        }
        this.bumpReplicaGS(rbw, newGS);
        return rbw;
    }

    @Override
    public synchronized ReplicaInPipelineInterface createTemporary(Block b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockId());
        if (replicaInfo != null) {
            throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
        }
        FSVolume v = this.volumes.getNextVolume(b.getNumBytes());
        File f = v.createTmpFile(b);
        ReplicaInPipeline newReplicaInfo = new ReplicaInPipeline(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile());
        this.volumeMap.add(newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public void adjustCrcChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams, int checksumSize) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.checksumOut;
        FileChannel channel = file.getChannel();
        long oldPos = channel.position();
        long newPos = oldPos - (long)checksumSize;
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("Changing meta file offset of block " + b + " from " + oldPos + " to " + newPos));
        }
        channel.position(newPos);
    }

    synchronized File createTmpFile(FSVolume vol, Block blk) throws IOException {
        if (vol == null && (vol = this.getReplicaInfo(blk).getVolume()) == null) {
            throw new IOException("Could not find volume for block " + blk);
        }
        return vol.createTmpFile(blk);
    }

    @Override
    public synchronized void finalizeBlock(Block b) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(b);
        if (replicaInfo.getState() == HdfsConstants.ReplicaState.FINALIZED) {
            return;
        }
        this.finalizeReplica(replicaInfo);
    }

    private synchronized FinalizedReplica finalizeReplica(ReplicaInfo replicaInfo) throws IOException {
        FinalizedReplica newReplicaInfo = null;
        if (replicaInfo.getState() == HdfsConstants.ReplicaState.RUR && ((ReplicaUnderRecovery)replicaInfo).getOrignalReplicaState() == HdfsConstants.ReplicaState.FINALIZED) {
            newReplicaInfo = (FinalizedReplica)((ReplicaUnderRecovery)replicaInfo).getOriginalReplica();
        } else {
            FSVolume v = replicaInfo.getVolume();
            File f = replicaInfo.getBlockFile();
            if (v == null) {
                throw new IOException("No volume for temporary file " + f + " for block " + replicaInfo);
            }
            File dest = v.addBlock(replicaInfo, f);
            newReplicaInfo = new FinalizedReplica(replicaInfo, v, dest.getParentFile());
        }
        this.volumeMap.add(newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public synchronized void unfinalizeBlock(Block b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b);
        if (replicaInfo != null && replicaInfo.getState() == HdfsConstants.ReplicaState.TEMPORARY) {
            this.volumeMap.remove(b);
            if (this.delBlockFromDisk(replicaInfo.getBlockFile(), replicaInfo.getMetaFile(), b)) {
                DataNode.LOG.warn((Object)("Block " + b + " unfinalized and removed. "));
            }
        }
    }

    private boolean delBlockFromDisk(File blockFile, File metaFile, Block b) {
        if (blockFile == null) {
            DataNode.LOG.warn((Object)("No file exists for block: " + b));
            return true;
        }
        if (!blockFile.delete()) {
            DataNode.LOG.warn((Object)("Not able to delete the block file: " + blockFile));
            return false;
        }
        if (metaFile != null && !metaFile.delete()) {
            DataNode.LOG.warn((Object)("Not able to delete the meta block file: " + metaFile));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockListAsLongs getBlockReport() {
        ArrayList<ReplicaInfo> finalized = new ArrayList<ReplicaInfo>(this.volumeMap.size());
        ArrayList<ReplicaInfo> uc = new ArrayList<ReplicaInfo>();
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            block9: for (ReplicaInfo b : this.volumeMap.replicas()) {
                switch (b.getState()) {
                    case FINALIZED: {
                        finalized.add(b);
                        continue block9;
                    }
                    case RBW: 
                    case RWR: {
                        uc.add(b);
                        continue block9;
                    }
                    case RUR: {
                        ReplicaUnderRecovery rur = (ReplicaUnderRecovery)b;
                        uc.add(rur.getOriginalReplica());
                        continue block9;
                    }
                    case TEMPORARY: {
                        continue block9;
                    }
                }
                assert (false) : "Illegal ReplicaInfo state.";
            }
            return new BlockListAsLongs(finalized, uc);
        }
    }

    synchronized Block[] getBlockList(boolean deepcopy) {
        Block[] list = this.volumeMap.replicas().toArray(new Block[this.volumeMap.size()]);
        if (deepcopy) {
            for (int i = 0; i < list.length; ++i) {
                list[i] = new Block(list[i]);
            }
        }
        return list;
    }

    synchronized List<Block> getFinalizedBlocks() {
        ArrayList<Block> finalized = new ArrayList<Block>(this.volumeMap.size());
        for (ReplicaInfo b : this.volumeMap.replicas()) {
            if (b.getState() != HdfsConstants.ReplicaState.FINALIZED) continue;
            finalized.add(new Block(b));
        }
        return finalized;
    }

    @Override
    public boolean isValidBlock(Block b) {
        ReplicaInfo replicaInfo = this.volumeMap.get(b);
        if (replicaInfo == null || replicaInfo.getState() != HdfsConstants.ReplicaState.FINALIZED) {
            return false;
        }
        return replicaInfo.getBlockFile().exists();
    }

    File validateBlockFile(Block b) throws IOException {
        File f = this.getFile(b);
        if (f != null) {
            if (f.exists()) {
                return f;
            }
            DataNode datanode = DataNode.getDataNode();
            datanode.checkDiskError();
        }
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.debug((Object)("b=" + b + ", f=" + f));
        }
        return null;
    }

    static void checkReplicaFiles(ReplicaInfo r) throws IOException {
        File f = r.getBlockFile();
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f + " not found, r=" + r);
        }
        if (r.getBytesOnDisk() != f.length()) {
            throw new IOException("File length mismatched.  The length of " + f + " is " + f.length() + " but r=" + r);
        }
        File metafile = FSDataset.getMetaFile(f, r);
        if (!metafile.exists()) {
            throw new IOException("Metafile " + metafile + " does not exist, r=" + r);
        }
        if (metafile.length() == 0L) {
            throw new IOException("Metafile " + metafile + " is empty, r=" + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            FSVolume v;
            File f = null;
            FSDataset fSDataset = this;
            synchronized (fSDataset) {
                f = this.getFile(invalidBlks[i]);
                ReplicaInfo dinfo = this.volumeMap.get(invalidBlks[i]);
                if (dinfo == null || dinfo.getGenerationStamp() != invalidBlks[i].getGenerationStamp()) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". BlockInfo not found in volumeMap."));
                    error = true;
                    continue;
                }
                v = dinfo.getVolume();
                if (f == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Block not found in blockMap." + (v == null ? " " : " Block found in volumeMap.")));
                    error = true;
                    continue;
                }
                if (v == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". No volume for this block." + " Block found in blockMap. " + f + "."));
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Parent not found for file " + f + "."));
                    error = true;
                    continue;
                }
                HdfsConstants.ReplicaState replicaState = dinfo.getState();
                if (replicaState == HdfsConstants.ReplicaState.FINALIZED || replicaState == HdfsConstants.ReplicaState.RUR && ((ReplicaUnderRecovery)dinfo).getOrignalReplicaState() == HdfsConstants.ReplicaState.FINALIZED) {
                    v.clearPath(parent);
                }
                this.volumeMap.remove(invalidBlks[i]);
            }
            File metaFile = FSDataset.getMetaFile(f, invalidBlks[i]);
            long dfsBytes = f.length() + metaFile.length();
            this.asyncDiskService.deleteAsync(v, f, metaFile, dfsBytes, invalidBlks[i].toString());
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    public synchronized File getFile(Block b) {
        return this.getFile(b.getBlockId());
    }

    private File getFile(long blockId) {
        ReplicaInfo info = this.volumeMap.get(blockId);
        if (info != null) {
            return info.getBlockFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDataDir() throws DiskChecker.DiskErrorException {
        long totalBlocks = 0L;
        long removedBlocks = 0L;
        List<FSVolume> failedVols = this.volumes.checkDirs();
        if (failedVols == null) {
            return;
        }
        long mlsec = System.currentTimeMillis();
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            Iterator<ReplicaInfo> ib = this.volumeMap.replicas().iterator();
            block3: while (ib.hasNext()) {
                ReplicaInfo b = ib.next();
                ++totalBlocks;
                FSVolume vol = b.getVolume();
                for (FSVolume fv : failedVols) {
                    if (vol != fv) continue;
                    DataNode.LOG.warn((Object)("Removing replica info for block " + b.getBlockId() + " on failed volume " + ((FSVolume)vol).dataDir.dir.getAbsolutePath()));
                    ib.remove();
                    ++removedBlocks;
                    continue block3;
                }
            }
        }
        mlsec = System.currentTimeMillis() - mlsec;
        DataNode.LOG.warn((Object)("Removed " + removedBlocks + " out of " + totalBlocks + "(took " + mlsec + " millisecs)"));
        StringBuilder sb = new StringBuilder();
        for (FSVolume fv : failedVols) {
            sb.append(((FSVolume)fv).dataDir.dir.getAbsolutePath() + ";");
        }
        throw new DiskChecker.DiskErrorException("DataNode failed volumes:" + sb);
    }

    @Override
    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String storageId) {
        String storageName = storageId == null || storageId.equals("") ? "UndefinedStorageId" + this.rand.nextInt() : storageId;
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeanUtil.registerMBean((String)"DataNode", (String)("FSDatasetState-" + storageName), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        DataNode.LOG.info((Object)"Registered FSDatasetStatusMBean");
    }

    @Override
    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
        }
        if (this.asyncDiskService != null) {
            this.asyncDiskService.shutdown();
        }
        if (this.volumes != null) {
            for (FSVolume volume : this.volumes.volumes) {
                if (volume == null) continue;
                volume.dfsUsage.shutdown();
            }
        }
    }

    @Override
    public String getStorageInfo() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdate(long blockId, File diskFile, File diskMetaFile, FSVolume vol) {
        DataNode datanode = DataNode.getDataNode();
        Block corruptBlock = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            long diskGS;
            ReplicaInfo memBlockInfo = this.volumeMap.get(blockId);
            if (memBlockInfo != null && memBlockInfo.getState() != HdfsConstants.ReplicaState.FINALIZED) {
                return;
            }
            long l = diskGS = diskMetaFile != null && diskMetaFile.exists() ? Block.getGenerationStamp(diskMetaFile.getName()) : 0L;
            if (diskFile == null || !diskFile.exists()) {
                if (memBlockInfo == null) {
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        DataNode.LOG.warn((Object)("Deleted a metadata file without a block " + diskMetaFile.getAbsolutePath()));
                    }
                    return;
                }
                if (!memBlockInfo.getBlockFile().exists()) {
                    this.volumeMap.remove(blockId);
                    if (datanode.blockScanner != null) {
                        datanode.blockScanner.deleteBlock(new Block(blockId));
                    }
                    DataNode.LOG.warn((Object)("Removed block " + blockId + " from memory with missing block file on the disk"));
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        DataNode.LOG.warn((Object)("Deleted a metadata file for the deleted block " + diskMetaFile.getAbsolutePath()));
                    }
                }
                return;
            }
            if (memBlockInfo == null) {
                FinalizedReplica diskBlockInfo = new FinalizedReplica(blockId, diskFile.length(), diskGS, vol, diskFile.getParentFile());
                this.volumeMap.add(diskBlockInfo);
                if (datanode.blockScanner != null) {
                    datanode.blockScanner.addBlock(diskBlockInfo);
                }
                DataNode.LOG.warn((Object)("Added missing block to memory " + diskBlockInfo));
                return;
            }
            File memFile = memBlockInfo.getBlockFile();
            if (memFile.exists()) {
                if (memFile.compareTo(diskFile) != 0) {
                    DataNode.LOG.warn((Object)("Block file " + memFile.getAbsolutePath() + " does not match file found by scan " + diskFile.getAbsolutePath()));
                }
            } else {
                DataNode.LOG.warn((Object)("Block file in volumeMap " + memFile.getAbsolutePath() + " does not exist. Updating it to the file found during scan " + diskFile.getAbsolutePath()));
                memBlockInfo.setDir(diskFile.getParentFile());
                memFile = diskFile;
                DataNode.LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + diskGS));
                memBlockInfo.setGenerationStamp(diskGS);
            }
            if (memBlockInfo.getGenerationStamp() != diskGS) {
                File memMetaFile = FSDataset.getMetaFile(diskFile, memBlockInfo);
                if (memMetaFile.exists()) {
                    if (memMetaFile.compareTo(diskMetaFile) != 0) {
                        DataNode.LOG.warn((Object)("Metadata file in memory " + memMetaFile.getAbsolutePath() + " does not match file found by scan " + diskMetaFile.getAbsolutePath()));
                    }
                } else {
                    long gs = diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.getParent().equals(memFile.getParent()) ? diskGS : 0L;
                    DataNode.LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + gs));
                    memBlockInfo.setGenerationStamp(gs);
                }
            }
            if (memBlockInfo.getNumBytes() != memFile.length()) {
                corruptBlock = new Block(memBlockInfo);
                DataNode.LOG.warn((Object)("Updating size of block " + blockId + " from " + memBlockInfo.getNumBytes() + " to " + memFile.length()));
                memBlockInfo.setNumBytes(memFile.length());
            }
        }
        if (corruptBlock != null) {
            DatanodeInfo[] dnArr = new DatanodeInfo[]{new DatanodeInfo(datanode.dnRegistration)};
            LocatedBlock[] blocks = new LocatedBlock[]{new LocatedBlock(corruptBlock, dnArr)};
            try {
                datanode.namenode.reportBadBlocks(blocks);
                DataNode.LOG.warn((Object)("Reporting the block " + corruptBlock + " as corrupt due to length mismatch"));
            }
            catch (IOException e) {
                DataNode.LOG.warn((Object)("Failed to repot bad block " + corruptBlock + "Exception:" + StringUtils.stringifyException((Throwable)e)));
            }
        }
    }

    @Override
    @Deprecated
    public ReplicaInfo getReplica(long blockId) {
        assert (Thread.holdsLock(this));
        return this.volumeMap.get(blockId);
    }

    @Override
    public synchronized ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return FSDataset.initReplicaRecovery(this.volumeMap, rBlock.getBlock(), rBlock.getNewGenerationStamp());
    }

    static ReplicaRecoveryInfo initReplicaRecovery(ReplicasMap map, Block block, long recoveryId) throws IOException {
        ReplicaUnderRecovery rur;
        ReplicaInfo replica = map.get(block.getBlockId());
        DataNode.LOG.info((Object)("initReplicaRecovery: block=" + block + ", recoveryId=" + recoveryId + ", replica=" + replica));
        if (replica == null) {
            return null;
        }
        if (replica instanceof ReplicaInPipeline) {
            ReplicaInPipeline rip = (ReplicaInPipeline)replica;
            rip.stopWriter();
            if (rip.getBytesOnDisk() < rip.getVisibleLength()) {
                throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: getBytesOnDisk() < getVisibleLength(), rip=" + rip);
            }
            FSDataset.checkReplicaFiles(rip);
        }
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        if (replica.getGenerationStamp() >= recoveryId) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getGenerationStamp() >= recoveryId = " + recoveryId + ", block=" + block + ", replica=" + replica);
        }
        if (replica.getState() == HdfsConstants.ReplicaState.RUR) {
            rur = (ReplicaUnderRecovery)replica;
            if (rur.getRecoveryID() >= recoveryId) {
                throw new RecoveryInProgressException("rur.getRecoveryID() >= recoveryId = " + recoveryId + ", block=" + block + ", rur=" + rur);
            }
            long oldRecoveryID = rur.getRecoveryID();
            rur.setRecoveryID(recoveryId);
            DataNode.LOG.info((Object)("initReplicaRecovery: update recovery id for " + block + " from " + oldRecoveryID + " to " + recoveryId));
        } else {
            rur = new ReplicaUnderRecovery(replica, recoveryId);
            map.add(rur);
            DataNode.LOG.info((Object)("initReplicaRecovery: changing replica state for " + block + " from " + (Object)((Object)replica.getState()) + " to " + (Object)((Object)rur.getState())));
        }
        return rur.createInfo();
    }

    @Override
    public synchronized ReplicaInfo updateReplicaUnderRecovery(Block oldBlock, long recoveryId, long newlength) throws IOException {
        ReplicaInfo replica = this.volumeMap.get(oldBlock.getBlockId());
        DataNode.LOG.info((Object)("updateReplica: block=" + oldBlock + ", recoveryId=" + recoveryId + ", length=" + newlength + ", replica=" + replica));
        if (replica == null) {
            throw new ReplicaNotFoundException(oldBlock);
        }
        if (replica.getState() != HdfsConstants.ReplicaState.RUR) {
            throw new IOException("replica.getState() != " + (Object)((Object)HdfsConstants.ReplicaState.RUR) + ", replica=" + replica);
        }
        if (replica.getBytesOnDisk() != oldBlock.getNumBytes()) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getBytesOnDisk() != block.getNumBytes(), block=" + oldBlock + ", replica=" + replica);
        }
        FSDataset.checkReplicaFiles(replica);
        FinalizedReplica finalized = this.updateReplicaUnderRecovery((ReplicaUnderRecovery)replica, recoveryId, newlength);
        FSDataset.checkReplicaFiles(finalized);
        return finalized;
    }

    private FinalizedReplica updateReplicaUnderRecovery(ReplicaUnderRecovery rur, long recoveryId, long newlength) throws IOException {
        if (rur.getRecoveryID() != recoveryId) {
            throw new IOException("rur.getRecoveryID() != recoveryId = " + recoveryId + ", rur=" + rur);
        }
        this.bumpReplicaGS(rur, recoveryId);
        File replicafile = rur.getBlockFile();
        if (rur.getNumBytes() < newlength) {
            throw new IOException("rur.getNumBytes() < newlength = " + newlength + ", rur=" + rur);
        }
        if (rur.getNumBytes() > newlength) {
            rur.unlinkBlock(1);
            FSDataset.truncateBlock(replicafile, rur.getMetaFile(), rur.getNumBytes(), newlength);
            rur.setNumBytes(newlength);
        }
        return this.finalizeReplica(rur);
    }

    @Override
    public synchronized long getReplicaVisibleLength(Block block) throws IOException {
        ReplicaInfo replica = this.volumeMap.get(block.getBlockId());
        if (replica == null) {
            throw new ReplicaNotFoundException(block);
        }
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        return replica.getVisibleLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Collection<VolumeInfo> getVolumeInfo() {
        ArrayList<VolumeInfo> info = new ArrayList<VolumeInfo>();
        FSVolume[] fSVolumeArray = this.volumes.volumes;
        synchronized (this.volumes.volumes) {
            for (FSVolume volume : this.volumes.volumes) {
                long used = 0L;
                try {
                    used = volume.getDfsUsed();
                }
                catch (IOException e) {
                    DataNode.LOG.warn((Object)e.getMessage());
                }
                long free = 0L;
                try {
                    free = volume.getAvailable();
                }
                catch (IOException e) {
                    DataNode.LOG.warn((Object)e.getMessage());
                }
                info.add(new VolumeInfo(volume.toString(), used, free, volume.getReserved()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return info;
        }
    }

    static class VolumeInfo {
        final String directory;
        final long usedSpace;
        final long freeSpace;
        final long reservedSpace;

        VolumeInfo(String dir, long usedSpace, long freeSpace, long reservedSpace) {
            this.directory = dir;
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
            this.reservedSpace = reservedSpace;
        }
    }

    static class FSVolumeSet {
        FSVolume[] volumes = null;
        int curVolume = 0;
        int numFailedVolumes = 0;

        FSVolumeSet(FSVolume[] volumes) {
            this.volumes = volumes;
        }

        private int numberOfVolumes() {
            return this.volumes.length;
        }

        private int numberOfFailedVolumes() {
            return this.numFailedVolumes;
        }

        synchronized FSVolume getNextVolume(long blockSize) throws IOException {
            if (this.volumes.length < 1) {
                throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
            }
            if (this.curVolume >= this.volumes.length) {
                this.curVolume = 0;
            }
            int startVolume = this.curVolume;
            do {
                FSVolume volume = this.volumes[this.curVolume];
                this.curVolume = (this.curVolume + 1) % this.volumes.length;
                if (volume.getAvailable() <= blockSize) continue;
                return volume;
            } while (this.curVolume != startVolume);
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block");
        }

        long getDfsUsed() throws IOException {
            long dfsUsed = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                dfsUsed += this.volumes[idx].getDfsUsed();
            }
            return dfsUsed;
        }

        long getCapacity() throws IOException {
            long capacity = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                capacity += this.volumes[idx].getCapacity();
            }
            return capacity;
        }

        long getRemaining() throws IOException {
            long remaining = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                remaining += this.volumes[idx].getAvailable();
            }
            return remaining;
        }

        synchronized void getVolumeMap(ReplicasMap volumeMap) throws IOException {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getVolumeMap(volumeMap);
            }
        }

        synchronized List<FSVolume> checkDirs() {
            ArrayList<FSVolume> removedVols = null;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                FSVolume fsv = this.volumes[idx];
                try {
                    fsv.checkDirs();
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    DataNode.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                    if (removedVols == null) {
                        removedVols = new ArrayList<FSVolume>(1);
                    }
                    removedVols.add(this.volumes[idx]);
                    this.volumes[idx] = null;
                    ++this.numFailedVolumes;
                }
            }
            if (removedVols != null && removedVols.size() > 0) {
                FSVolume[] newVols = new FSVolume[this.volumes.length - removedVols.size()];
                int i = 0;
                for (FSVolume vol : this.volumes) {
                    if (vol == null) continue;
                    newVols[i++] = vol;
                }
                this.volumes = newVols;
                DataNode.LOG.info((Object)("Completed FSVolumeSet.checkDirs. Removed " + removedVols.size() + " volumes. List of current volumes: " + this));
            }
            return removedVols;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                sb.append(this.volumes[idx].toString());
                if (idx == this.volumes.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public boolean isValid(FSVolume volume) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                if (this.volumes[idx] != volume) continue;
                return true;
            }
            return false;
        }
    }

    class FSVolume {
        private File currentDir;
        private FSDir dataDir;
        private File rbwDir;
        private File tmpDir;
        private DF usage;
        private DU dfsUsage;
        private long reserved;

        FSVolume(File currentDir, Configuration conf) throws IOException {
            this.reserved = conf.getLong("dfs.datanode.du.reserved", 0L);
            this.currentDir = currentDir;
            File parent = currentDir.getParentFile();
            File finalizedDir = new File(currentDir, "finalized");
            this.tmpDir = new File(parent, "tmp");
            if (this.tmpDir.exists()) {
                FileUtil.fullyDelete((File)this.tmpDir);
            }
            this.rbwDir = new File(currentDir, "rbw");
            if (this.rbwDir.exists() && !FSDataset.this.supportAppends) {
                FileUtil.fullyDelete((File)this.rbwDir);
            }
            this.dataDir = new FSDir(finalizedDir);
            if (!this.rbwDir.mkdirs() && !this.rbwDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.rbwDir.toString());
            }
            if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
            }
            this.usage = new DF(parent, conf);
            this.dfsUsage = new DU(parent, conf);
            this.dfsUsage.start();
        }

        File getCurrentDir() {
            return this.currentDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decDfsUsed(long value) {
            FSDataset fSDataset = FSDataset.this;
            synchronized (fSDataset) {
                this.dfsUsage.decDfsUsed(value);
            }
        }

        long getDfsUsed() throws IOException {
            return this.dfsUsage.getUsed();
        }

        long getCapacity() throws IOException {
            long remaining = this.usage.getCapacity() - this.reserved;
            return remaining > 0L ? remaining : 0L;
        }

        long getAvailable() throws IOException {
            long available;
            long remaining = this.getCapacity() - this.getDfsUsed();
            if (remaining > (available = this.usage.getAvailable())) {
                remaining = available;
            }
            return remaining > 0L ? remaining : 0L;
        }

        long getReserved() {
            return this.reserved;
        }

        String getMount() throws IOException {
            return this.usage.getMount();
        }

        File getDir() {
            return this.dataDir.dir;
        }

        File createTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return FSDataset.createTmpFile(b, f);
        }

        File createRbwFile(Block b) throws IOException {
            File f = new File(this.rbwDir, b.getBlockName());
            return FSDataset.createTmpFile(b, f);
        }

        File addBlock(Block b, File f) throws IOException {
            File blockFile = this.dataDir.addBlock(b, f);
            File metaFile = FSDataset.getMetaFile(blockFile, b);
            this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
            return blockFile;
        }

        void checkDirs() throws DiskChecker.DiskErrorException {
            this.dataDir.checkDirTree();
            DiskChecker.checkDir((File)this.tmpDir);
            DiskChecker.checkDir((File)this.rbwDir);
        }

        void getVolumeMap(ReplicasMap volumeMap) throws IOException {
            this.dataDir.getVolumeMap(volumeMap, this);
            this.addToReplicasMap(volumeMap, this.rbwDir, false);
        }

        private void addToReplicasMap(ReplicasMap volumeMap, File dir, boolean isFinalized) {
            File[] blockFiles;
            for (File blockFile : blockFiles = dir.listFiles()) {
                if (!Block.isBlockFilename(blockFile)) continue;
                long genStamp = FSDataset.getGenerationStampFromFile(blockFiles, blockFile);
                long blockId = Block.filename2id(blockFile.getName());
                ReplicaInfo newReplica = null;
                newReplica = isFinalized ? new FinalizedReplica(blockId, blockFile.length(), genStamp, this, blockFile.getParentFile()) : new ReplicaWaitingToBeRecovered(blockId, this.validateIntegrity(blockFile, genStamp), genStamp, this, blockFile.getParentFile());
                ReplicaInfo oldReplica = volumeMap.add(newReplica);
                if (oldReplica == null) continue;
                DataNode.LOG.warn((Object)("Two block files with the same block id exist on disk: " + oldReplica.getBlockFile() + " and " + blockFile));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long validateIntegrity(File blockFile, long genStamp) {
            long l;
            FileInputStream blockIn;
            DataInputStream checksumIn;
            block14: {
                long l2;
                block13: {
                    long l3;
                    block12: {
                        checksumIn = null;
                        blockIn = null;
                        try {
                            int checksumSize;
                            DataChecksum checksum;
                            int bytesPerChecksum;
                            long numChunks;
                            File metaFile = new File(FSDataset.getMetaFileName(blockFile.toString(), genStamp));
                            long blockFileLen = blockFile.length();
                            long metaFileLen = metaFile.length();
                            int crcHeaderLen = DataChecksum.getChecksumHeaderSize();
                            if (!blockFile.exists() || blockFileLen == 0L || !metaFile.exists() || metaFileLen < (long)crcHeaderLen) {
                                long l4 = 0L;
                                return l4;
                            }
                            checksumIn = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), FSConstants.BUFFER_SIZE));
                            BlockMetadataHeader header = BlockMetadataHeader.readHeader(checksumIn);
                            short version = header.getVersion();
                            if (version != 1) {
                                DataNode.LOG.warn((Object)("Wrong version (" + version + ") for metadata file " + metaFile + " ignoring ..."));
                            }
                            if ((numChunks = Math.min((blockFileLen + (long)(bytesPerChecksum = (checksum = header.getChecksum()).getBytesPerChecksum()) - 1L) / (long)bytesPerChecksum, (metaFileLen - (long)crcHeaderLen) / (long)(checksumSize = checksum.getChecksumSize()))) == 0L) {
                                l3 = 0L;
                                IOUtils.closeStream((Closeable)checksumIn);
                                break block12;
                            }
                            IOUtils.skipFully((InputStream)checksumIn, (long)((numChunks - 1L) * (long)checksumSize));
                            blockIn = new FileInputStream(blockFile);
                            long lastChunkStartPos = (numChunks - 1L) * (long)bytesPerChecksum;
                            IOUtils.skipFully((InputStream)blockIn, (long)lastChunkStartPos);
                            int lastChunkSize = (int)Math.min((long)bytesPerChecksum, blockFileLen - lastChunkStartPos);
                            byte[] buf = new byte[lastChunkSize + checksumSize];
                            checksumIn.readFully(buf, lastChunkSize, checksumSize);
                            IOUtils.readFully((InputStream)blockIn, (byte[])buf, (int)0, (int)lastChunkSize);
                            checksum.update(buf, 0, lastChunkSize);
                            if (checksum.compare(buf, lastChunkSize)) {
                                l2 = lastChunkStartPos + (long)lastChunkSize;
                                IOUtils.closeStream((Closeable)checksumIn);
                                break block13;
                            }
                            l = lastChunkStartPos;
                            IOUtils.closeStream((Closeable)checksumIn);
                            break block14;
                        }
                        catch (IOException e) {
                            DataNode.LOG.warn((Object)e);
                            long l5 = 0L;
                            return l5;
                        }
                    }
                    IOUtils.closeStream(blockIn);
                    return l3;
                }
                IOUtils.closeStream((Closeable)blockIn);
                return l2;
            }
            IOUtils.closeStream((Closeable)blockIn);
            return l;
            finally {
                IOUtils.closeStream(checksumIn);
                IOUtils.closeStream(blockIn);
            }
        }

        void clearPath(File f) {
            this.dataDir.clearPath(f);
        }

        public String toString() {
            return this.getDir().getAbsolutePath();
        }
    }

    class FSDir {
        File dir;
        int numBlocks = 0;
        FSDir[] children;
        int lastChildIdx = 0;

        public FSDir(File dir) throws IOException {
            this.dir = dir;
            this.children = null;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + dir.toString());
                }
            } else {
                File[] files = dir.listFiles();
                int numChildren = 0;
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        ++numChildren;
                        continue;
                    }
                    if (!Block.isBlockFilename(files[idx])) continue;
                    ++this.numBlocks;
                }
                if (numChildren > 0) {
                    this.children = new FSDir[numChildren];
                    int curdir = 0;
                    for (int idx = 0; idx < files.length; ++idx) {
                        if (!files[idx].isDirectory()) continue;
                        this.children[curdir] = new FSDir(files[idx]);
                        ++curdir;
                    }
                }
            }
        }

        public File addBlock(Block b, File src) throws IOException {
            File file = this.addBlock(b, src, false, false);
            return file != null ? file : this.addBlock(b, src, true, true);
        }

        private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
            if (this.numBlocks < FSDataset.this.maxBlocksPerDir) {
                File newmeta;
                File dest = new File(this.dir, b.getBlockName());
                File metaData = FSDataset.getMetaFile(src, b);
                if (!metaData.renameTo(newmeta = FSDataset.getMetaFile(dest, b)) || !src.renameTo(dest)) {
                    throw new IOException("could not move files for " + b + " from " + src + " to " + dest.getAbsolutePath() + " or from" + metaData + " to " + newmeta);
                }
                if (DataNode.LOG.isDebugEnabled()) {
                    DataNode.LOG.debug((Object)("addBlock: Moved " + metaData + " to " + newmeta));
                    DataNode.LOG.debug((Object)("addBlock: Moved " + src + " to " + dest));
                }
                ++this.numBlocks;
                return dest;
            }
            if (this.lastChildIdx < 0 && resetIdx) {
                this.lastChildIdx = random.nextInt(this.children.length);
            }
            if (this.lastChildIdx >= 0 && this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    int idx = (this.lastChildIdx + i) % this.children.length;
                    File file = this.children[idx].addBlock(b, src, false, resetIdx);
                    if (file == null) continue;
                    this.lastChildIdx = idx;
                    return file;
                }
                this.lastChildIdx = -1;
            }
            if (!createOk) {
                return null;
            }
            if (this.children == null || this.children.length == 0) {
                this.children = new FSDir[FSDataset.this.maxBlocksPerDir];
                for (int idx = 0; idx < FSDataset.this.maxBlocksPerDir; ++idx) {
                    this.children[idx] = new FSDir(new File(this.dir, "subdir" + idx));
                }
            }
            this.lastChildIdx = random.nextInt(this.children.length);
            return this.children[this.lastChildIdx].addBlock(b, src, true, false);
        }

        void getVolumeMap(ReplicasMap volumeMap, FSVolume volume) throws IOException {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getVolumeMap(volumeMap, volume);
                }
            }
            this.recoverTempUnlinkedBlock();
            volume.addToReplicasMap(volumeMap, this.dir, true);
        }

        private void recoverTempUnlinkedBlock() throws IOException {
            File[] files;
            for (File file : files = this.dir.listFiles()) {
                if (!FSDataset.isUnlinkTmpFile(file)) continue;
                File blockFile = FSDataset.getOrigFile(file);
                if (blockFile.exists()) {
                    if (file.delete()) continue;
                    throw new IOException("Unable to cleanup unlinked tmp file " + file);
                }
                if (file.renameTo(blockFile)) continue;
                throw new IOException("Unable to cleanup detached file " + file);
            }
        }

        public void checkDirTree() throws DiskChecker.DiskErrorException {
            DiskChecker.checkDir((File)this.dir);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].checkDirTree();
                }
            }
        }

        void clearPath(File f) {
            String[] dirNames;
            String root = this.dir.getAbsolutePath();
            String dir = f.getAbsolutePath();
            if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
                return;
            }
            this.clearPath(f, null, -1);
        }

        private boolean clearPath(File f, String[] dirNames, int idx) {
            if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
                --this.numBlocks;
                return true;
            }
            if (dirNames != null) {
                int childIdx;
                if (idx > dirNames.length - 1 || this.children == null) {
                    return false;
                }
                try {
                    childIdx = Integer.parseInt(dirNames[idx]);
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
            }
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].clearPath(f, null, -1)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
        }
    }
}

