/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.io.IOUtils;

class ReplicaInPipeline
extends ReplicaInfo
implements ReplicaInPipelineInterface {
    private long bytesAcked;
    private long bytesOnDisk;
    private byte[] lastChecksum;
    private Thread writer;

    ReplicaInPipeline(long blockId, long genStamp, FSDataset.FSVolume vol, File dir) {
        this(blockId, 0L, genStamp, vol, dir, Thread.currentThread());
    }

    ReplicaInPipeline(Block block, FSDataset.FSVolume vol, File dir, Thread writer) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir, writer);
    }

    ReplicaInPipeline(long blockId, long len, long genStamp, FSDataset.FSVolume vol, File dir, Thread writer) {
        super(blockId, len, genStamp, vol, dir);
        this.bytesAcked = len;
        this.bytesOnDisk = len;
        this.writer = writer;
    }

    ReplicaInPipeline(ReplicaInPipeline from) {
        super(from);
        this.bytesAcked = from.getBytesAcked();
        this.bytesOnDisk = from.getBytesOnDisk();
        this.writer = from.writer;
    }

    @Override
    public long getVisibleLength() {
        return -1L;
    }

    @Override
    public HdfsConstants.ReplicaState getState() {
        return HdfsConstants.ReplicaState.TEMPORARY;
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public void setBytesAcked(long bytesAcked) {
        this.bytesAcked = bytesAcked;
    }

    @Override
    public long getBytesOnDisk() {
        return this.bytesOnDisk;
    }

    @Override
    public synchronized void setLastChecksumAndDataLen(long dataLength, byte[] lastChecksum) {
        this.bytesOnDisk = dataLength;
        this.lastChecksum = lastChecksum;
    }

    @Override
    public synchronized ChunkChecksum getLastChecksumAndDataLen() {
        return new ChunkChecksum(this.getBytesOnDisk(), this.lastChecksum);
    }

    public void setWriter(Thread writer) {
        this.writer = writer;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    void stopWriter() throws IOException {
        if (this.writer != null && this.writer != Thread.currentThread() && this.writer.isAlive()) {
            this.writer.interrupt();
            try {
                this.writer.join();
            }
            catch (InterruptedException e) {
                throw new IOException("Waiting for writer thread is interrupted.");
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public FSDatasetInterface.BlockWriteStreams createStreams(boolean isCreate, int bytesPerChunk, int checksumSize) throws IOException {
        File blockFile = this.getBlockFile();
        File metaFile = this.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("writeTo blockfile is " + blockFile + " of size " + blockFile.length()));
            DataNode.LOG.debug((Object)("writeTo metafile is " + metaFile + " of size " + metaFile.length()));
        }
        long blockDiskSize = 0L;
        long crcDiskSize = 0L;
        if (!isCreate) {
            blockDiskSize = this.bytesOnDisk;
            crcDiskSize = (long)BlockMetadataHeader.getHeaderSize() + (blockDiskSize + (long)bytesPerChunk - 1L) / (long)bytesPerChunk * (long)checksumSize;
            if (blockDiskSize > 0L && (blockDiskSize > blockFile.length() || crcDiskSize > metaFile.length())) {
                throw new IOException("Corrupted block: " + this);
            }
        }
        FileOutputStream blockOut = null;
        FileOutputStream crcOut = null;
        try {
            blockOut = new FileOutputStream(new RandomAccessFile(blockFile, "rw").getFD());
            crcOut = new FileOutputStream(new RandomAccessFile(metaFile, "rw").getFD());
            if (!isCreate) {
                blockOut.getChannel().position(blockDiskSize);
                crcOut.getChannel().position(crcDiskSize);
            }
            return new FSDatasetInterface.BlockWriteStreams(blockOut, crcOut);
        }
        catch (IOException e) {
            IOUtils.closeStream(blockOut);
            IOUtils.closeStream(crcOut);
            throw e;
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bytesAcked=" + this.bytesAcked + "\n  bytesOnDisk=" + this.bytesOnDisk;
    }
}

