/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpServer;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class SecureDataNodeStarter
implements Daemon {
    private String[] args;
    private SecureResources resources;

    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing secure datanode resources");
        Configuration conf = new Configuration();
        if (!conf.get("hadoop.security.authentication").equals("kerberos")) {
            throw new RuntimeException("Cannot start secure datanode in unsecure cluster");
        }
        this.args = context.getArguments();
        InetSocketAddress socAddr = DataNode.getStreamingAddr(conf);
        int socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        ServerSocket ss = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        ss.bind(socAddr, 0);
        if (ss.getLocalPort() != socAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified streaming port in secure context. Needed " + socAddr.getPort() + ", got " + ss.getLocalPort());
        }
        SelectChannelConnector listener = (SelectChannelConnector)HttpServer.createDefaultChannelConnector();
        InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
        listener.setHost(infoSocAddr.getHostName());
        listener.setPort(infoSocAddr.getPort());
        listener.open();
        if (listener.getPort() != infoSocAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified info port in secure context. Needed " + socAddr.getPort() + ", got " + ss.getLocalPort());
        }
        System.err.println("Successfully obtained privileged resources (streaming port = " + ss + " ) (http listener port = " + listener.getConnection() + ")");
        if (ss.getLocalPort() >= 1023 || listener.getPort() >= 1023) {
            throw new RuntimeException("Cannot start secure datanode with unprivileged ports");
        }
        this.resources = new SecureResources(ss, listener);
    }

    public void start() throws Exception {
        System.err.println("Starting regular datanode initialization");
        DataNode.secureMain(this.args, this.resources);
    }

    public void destroy() {
    }

    public void stop() throws Exception {
    }

    public static class SecureResources {
        private final ServerSocket streamingSocket;
        private final SelectChannelConnector listener;

        public SecureResources(ServerSocket streamingSocket, SelectChannelConnector listener) {
            this.streamingSocket = streamingSocket;
            this.listener = listener;
        }

        public ServerSocket getStreamingSocket() {
            return this.streamingSocket;
        }

        public SelectChannelConnector getListener() {
            return this.listener;
        }
    }
}

