/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;

class EditLogBackupOutputStream
extends EditLogOutputStream {
    static int DEFAULT_BUFFER_SIZE = 256;
    private NamenodeProtocol backupNode;
    private NamenodeRegistration bnRegistration;
    private NamenodeRegistration nnRegistration;
    private ArrayList<JournalRecord> bufCurrent;
    private ArrayList<JournalRecord> bufReady;
    private DataOutputBuffer out;

    EditLogBackupOutputStream(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.bnRegistration = bnReg;
        this.nnRegistration = nnReg;
        InetSocketAddress bnAddress = NetUtils.createSocketAddr((String)this.bnRegistration.getAddress());
        Storage.LOG.info((Object)("EditLogBackupOutputStream connects to: " + bnAddress));
        try {
            this.backupNode = (NamenodeProtocol)RPC.getProxy(NamenodeProtocol.class, (long)5L, (InetSocketAddress)bnAddress, (Configuration)new HdfsConfiguration());
        }
        catch (IOException e) {
            Storage.LOG.error((Object)("Error connecting to: " + bnAddress), (Throwable)e);
            throw e;
        }
        this.bufCurrent = new ArrayList();
        this.bufReady = new ArrayList();
        this.out = new DataOutputBuffer(DEFAULT_BUFFER_SIZE);
    }

    @Override
    public String getName() {
        return this.bnRegistration.getAddress();
    }

    @Override
    public JournalStream.JournalType getType() {
        return JournalStream.JournalType.BACKUP;
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    void write(byte op, Writable ... writables) throws IOException {
        this.bufCurrent.add(new JournalRecord(op, writables));
    }

    @Override
    void create() throws IOException {
        this.bufCurrent.clear();
        assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
    }

    @Override
    public void close() throws IOException {
        int size = this.bufCurrent.size();
        if (size != 0) {
            throw new IOException("BackupEditStream has " + size + " records still to be flushed and cannot be closed.");
        }
        RPC.stopProxy((Object)this.backupNode);
        this.bufReady = null;
        this.bufCurrent = null;
    }

    @Override
    void setReadyToFlush() throws IOException {
        assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
        ArrayList<JournalRecord> tmp = this.bufReady;
        this.bufReady = this.bufCurrent;
        this.bufCurrent = tmp;
    }

    @Override
    protected void flushAndSync() throws IOException {
        assert (this.out.size() == 0) : "Output buffer is not empty";
        int bufReadySize = this.bufReady.size();
        for (int idx = 0; idx < bufReadySize; ++idx) {
            JournalRecord jRec = null;
            while (idx < bufReadySize) {
                jRec = this.bufReady.get(idx);
                if (jRec.op >= 102) break;
                jRec.write((DataOutputStream)this.out);
                ++idx;
            }
            if (this.out.size() > 0) {
                this.send(101);
            }
            if (idx == bufReadySize) break;
            jRec.write((DataOutputStream)this.out);
            this.send(jRec.op);
        }
        this.bufReady.clear();
        this.out.reset();
    }

    @Override
    long length() throws IOException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(int ja) throws IOException {
        try {
            int length = this.out.getLength();
            this.out.write(-1);
            this.backupNode.journal(this.nnRegistration, ja, length, this.out.getData());
        }
        finally {
            this.out.reset();
        }
    }

    NamenodeRegistration getRegistration() {
        return this.bnRegistration;
    }

    boolean isAlive() {
        try {
            this.send(100);
        }
        catch (IOException ei) {
            Storage.LOG.info((Object)((Object)((Object)this.bnRegistration.getRole()) + " " + this.bnRegistration.getAddress() + " is not alive. "), (Throwable)ei);
            return false;
        }
        return true;
    }

    static class JournalRecord {
        byte op;
        Writable[] args;

        JournalRecord(byte op, Writable ... writables) {
            this.op = op;
            this.args = writables;
        }

        void write(DataOutputStream out) throws IOException {
            out.write(this.op);
            if (this.args == null) {
                return;
            }
            for (Writable w : this.args) {
                w.write((DataOutput)out);
            }
        }
    }
}

