/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;

class EditLogFileOutputStream
extends EditLogOutputStream {
    private static int EDITS_FILE_HEADER_SIZE_BYTES = 4;
    private File file;
    private FileOutputStream fp;
    private FileChannel fc;
    private DataOutputBuffer bufCurrent;
    private DataOutputBuffer bufReady;
    private final int initBufferSize;
    static ByteBuffer fill = ByteBuffer.allocateDirect(512);

    EditLogFileOutputStream(File name, int size) throws IOException {
        this.file = name;
        this.initBufferSize = size;
        this.bufCurrent = new DataOutputBuffer(size);
        this.bufReady = new DataOutputBuffer(size);
        RandomAccessFile rp = new RandomAccessFile(name, "rw");
        this.fp = new FileOutputStream(rp.getFD());
        this.fc = rp.getChannel();
        this.fc.position(this.fc.size());
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public JournalStream.JournalType getType() {
        return JournalStream.JournalType.FILE;
    }

    @Override
    public void write(int b) throws IOException {
        this.bufCurrent.write(b);
    }

    @Override
    void write(byte op, Writable ... writables) throws IOException {
        this.write(op);
        for (Writable w : writables) {
            w.write((DataOutput)this.bufCurrent);
        }
    }

    @Override
    void create() throws IOException {
        this.fc.truncate(0L);
        this.fc.position(0L);
        this.bufCurrent.writeInt(FSConstants.LAYOUT_VERSION);
        this.setReadyToFlush();
        this.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bufCurrent != null) {
            int bufSize = this.bufCurrent.size();
            if (bufSize != 0) {
                throw new IOException("FSEditStream has " + bufSize + " bytes still to be flushed and cannot " + "be closed.");
            }
            this.bufCurrent.close();
            this.bufCurrent = null;
        }
        if (this.bufReady != null) {
            this.bufReady.close();
            this.bufReady = null;
        }
        if (this.fc != null && this.fc.isOpen()) {
            this.fc.truncate(this.fc.position());
            this.fc.close();
        }
        if (this.fp != null) {
            this.fp.close();
        }
    }

    @Override
    void setReadyToFlush() throws IOException {
        assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
        this.write(-1);
        DataOutputBuffer tmp = this.bufReady;
        this.bufReady = this.bufCurrent;
        this.bufCurrent = tmp;
    }

    @Override
    protected void flushAndSync() throws IOException {
        this.preallocate();
        this.bufReady.writeTo((OutputStream)this.fp);
        this.bufReady.reset();
        this.fc.force(false);
        this.fc.position(this.fc.position() - 1L);
    }

    @Override
    public boolean shouldForceSync() {
        return this.bufReady.size() >= this.initBufferSize;
    }

    @Override
    long length() throws IOException {
        return this.fc.size() - (long)EDITS_FILE_HEADER_SIZE_BYTES + (long)this.bufReady.size() + (long)this.bufCurrent.size();
    }

    private void preallocate() throws IOException {
        long position = this.fc.position();
        if (position + 4096L >= this.fc.size()) {
            if (FSNamesystem.LOG.isDebugEnabled()) {
                FSNamesystem.LOG.debug((Object)("Preallocating Edit log, current size " + this.fc.size()));
            }
            long newsize = position + 0x100000L;
            fill.position(0);
            int written = this.fc.write(fill, newsize);
            if (FSNamesystem.LOG.isDebugEnabled()) {
                FSNamesystem.LOG.debug((Object)("Edit log size is now " + this.fc.size() + " written " + written + " bytes " + " at offset " + newsize));
            }
        }
    }

    @Override
    boolean isOperationSupported(byte op) {
        return op < 101;
    }

    File getFile() {
        return this.file;
    }
}

