/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSEditLog {
    static final String NO_JOURNAL_STREAMS_WARNING = "!!! WARNING !!! File system changes are not persistent. No journal streams.";
    private static final Log LOG = LogFactory.getLog(FSEditLog.class);
    private volatile int sizeOutputFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private volatile boolean isSyncRunning;
    private volatile boolean isAutoSyncScheduled = false;
    private long numTransactions;
    private long numTransactionsBatchedInSync;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = Util.now();
    }

    private File getEditFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditFile(sd);
    }

    private File getEditNewFile(Storage.StorageDirectory sd) {
        return this.fsimage.getEditNewFile(sd);
    }

    private int getNumEditsDirs() {
        return this.fsimage.getNumStorageDirs(FSImage.NameNodeDirType.EDITS);
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    ArrayList<EditLogOutputStream> getEditStreams() {
        return this.editStreams;
    }

    boolean isOpen() {
        return this.getNumEditStreams() > 0;
    }

    synchronized void open() throws IOException {
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        if (this.editStreams == null) {
            this.editStreams = new ArrayList();
        }
        ArrayList<Storage.StorageDirectory> al = null;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File eFile = this.getEditFile(sd);
            try {
                this.addNewEditLogStream(eFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to open edit log file " + eFile));
                if (al == null) {
                    al = new ArrayList<Storage.StorageDirectory>(1);
                }
                al.add(sd);
            }
        }
        if (al != null) {
            this.fsimage.processIOError(al, false);
        }
        if (this.fsimage.getNumStorageDirs(FSImage.NameNodeDirType.EDITS) == 0) {
            throw new IOException("Failed to initialize edits log in any storage directory.");
        }
    }

    synchronized void addNewEditLogStream(File eFile) throws IOException {
        EditLogFileOutputStream eStream = new EditLogFileOutputStream(eFile, this.sizeOutputFlushBuffer);
        this.editStreams.add(eStream);
    }

    synchronized void createEditLogFile(File name) throws IOException {
        this.waitForSyncToFinish();
        EditLogFileOutputStream eStream = new EditLogFileOutputStream(name, this.sizeOutputFlushBuffer);
        ((EditLogOutputStream)eStream).create();
        ((EditLogOutputStream)eStream).close();
    }

    synchronized void close() {
        this.waitForSyncToFinish();
        if (this.editStreams == null || this.editStreams.isEmpty()) {
            return;
        }
        this.printStatistics(true);
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        ArrayList<EditLogOutputStream> errorStreams = null;
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(null);
        while (it.hasNext()) {
            EditLogOutputStream eStream = it.next();
            try {
                this.closeStream(eStream);
            }
            catch (IOException e) {
                LOG.warn((Object)("FSEditLog:close - failed to close stream " + eStream.getName()));
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
        this.editStreams.clear();
    }

    private synchronized void removeStream(int index) {
        EditLogOutputStream eStream = this.editStreams.get(index);
        try {
            eStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editStreams.remove(index);
    }

    synchronized void processIOError(List<EditLogOutputStream> errorStreams, boolean propagate) {
        if (errorStreams == null || errorStreams.size() == 0) {
            return;
        }
        String lsd = this.fsimage.listStorageDirectories();
        LOG.info((Object)("current list of storage dirs:" + lsd));
        ArrayList<Storage.StorageDirectory> al = null;
        block2: for (EditLogOutputStream eStream : errorStreams) {
            Storage.StorageDirectory storageDir;
            LOG.error((Object)("Unable to log edits to " + eStream.getName() + "; removing it"));
            if (propagate && eStream.getType() == JournalStream.JournalType.FILE && (storageDir = this.getStorage(eStream)) != null) {
                LOG.info((Object)("about to remove corresponding storage:" + storageDir.getRoot().getAbsolutePath()));
                if (al == null) {
                    al = new ArrayList<Storage.StorageDirectory>(1);
                }
                al.add(storageDir);
            }
            Iterator<EditLogOutputStream> ies = this.editStreams.iterator();
            while (ies.hasNext()) {
                EditLogOutputStream es = ies.next();
                if (es != eStream) continue;
                try {
                    eStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to close eStream " + eStream.getName() + " before removing it (might be ok)"));
                }
                ies.remove();
                continue block2;
            }
        }
        if (this.editStreams == null || this.editStreams.size() <= 0) {
            String msg = "Fatal Error: All storage directories are inaccessible.";
            LOG.fatal((Object)msg, (Throwable)new IOException(msg));
            Runtime.getRuntime().exit(-1);
        }
        if (propagate && al != null) {
            this.fsimage.processIOError(al, false);
        }
        if (propagate) {
            this.incrementCheckpointTime();
        }
        lsd = this.fsimage.listStorageDirectories();
        LOG.info((Object)("at the end current list of storage dirs:" + lsd));
    }

    Storage.StorageDirectory getStorage(EditLogOutputStream es) {
        String parentStorageDir = ((EditLogFileOutputStream)es).getFile().getParentFile().getParentFile().getAbsolutePath();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            LOG.info((Object)("comparing: " + parentStorageDir + " and " + sd.getRoot().getAbsolutePath()));
            if (!parentStorageDir.equals(sd.getRoot().getAbsolutePath())) continue;
            return sd;
        }
        return null;
    }

    synchronized EditLogOutputStream getEditsStream(Storage.StorageDirectory sd) {
        for (EditLogOutputStream es : this.editStreams) {
            File parentStorageDir = ((EditLogFileOutputStream)es).getFile().getParentFile().getParentFile();
            if (!parentStorageDir.getName().equals(sd.getRoot().getName())) continue;
            return es;
        }
        return null;
    }

    boolean existsNew(Storage.StorageDirectory sd) {
        return this.getEditNewFile(sd).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logEdit(byte op, Writable ... writables) {
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            this.waitIfAutoSyncScheduled();
            if (this.getNumEditStreams() == 0) {
                throw new IllegalStateException(NO_JOURNAL_STREAMS_WARNING);
            }
            ArrayList<EditLogOutputStream> errorStreams = null;
            long start = Util.now();
            for (EditLogOutputStream eStream : this.editStreams) {
                if (!eStream.isOperationSupported(op)) continue;
                try {
                    eStream.write(op, writables);
                }
                catch (IOException ie) {
                    LOG.error((Object)("logEdit: removing " + eStream.getName()), (Throwable)ie);
                    if (errorStreams == null) {
                        errorStreams = new ArrayList<EditLogOutputStream>(1);
                    }
                    errorStreams.add(eStream);
                }
            }
            this.processIOError(errorStreams, true);
            this.recordTransaction(start);
            if (!this.shouldForceSync()) {
                return;
            }
            this.isAutoSyncScheduled = true;
        }
        this.logSync();
    }

    synchronized void waitIfAutoSyncScheduled() {
        try {
            while (this.isAutoSyncScheduled) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void doneWithAutoSyncScheduling() {
        if (this.isAutoSyncScheduled) {
            this.isAutoSyncScheduled = false;
            this.notifyAll();
        }
    }

    private boolean shouldForceSync() {
        for (EditLogOutputStream eStream : this.editStreams) {
            if (!eStream.shouldForceSync()) continue;
            return true;
        }
        return false;
    }

    private void recordTransaction(long start) {
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = Util.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        if (this.metrics != null) {
            this.metrics.transactions.inc(end - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSyncAll() throws IOException {
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            TransactionId id = myTransactionId.get();
            id.txid = this.txid;
        }
        this.logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logSync() {
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        long mytxid = FSEditLog.myTransactionId.get().txid;
        ArrayList<EditLogOutputStream> streams = new ArrayList<EditLogOutputStream>();
        boolean sync = false;
        try {
            FSEditLog fSEditLog = this;
            synchronized (fSEditLog) {
                try {
                    this.printStatistics(false);
                    while (mytxid > this.synctxid && this.isSyncRunning) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    if (mytxid <= this.synctxid) {
                        ++this.numTransactionsBatchedInSync;
                        if (this.metrics == null) return;
                        this.metrics.transactionsBatchedInSync.inc();
                        return;
                    }
                    syncStart = this.txid;
                    this.isSyncRunning = true;
                    sync = true;
                    assert (this.editStreams.size() > 0) : "no editlog streams";
                    for (EditLogOutputStream eStream : this.editStreams) {
                        try {
                            eStream.setReadyToFlush();
                            streams.add(eStream);
                        }
                        catch (IOException ie) {
                            LOG.error((Object)"Unable to get ready to flush.", (Throwable)ie);
                            if (errorStreams == null) {
                                errorStreams = new ArrayList<EditLogOutputStream>(1);
                            }
                            errorStreams.add(eStream);
                        }
                    }
                }
                finally {
                    this.doneWithAutoSyncScheduling();
                }
            }
            long start = Util.now();
            for (EditLogOutputStream eStream : streams) {
                try {
                    eStream.flush();
                }
                catch (IOException ie) {
                    LOG.error((Object)"Unable to sync edit log.", (Throwable)ie);
                    if (errorStreams == null) {
                        errorStreams = new ArrayList(1);
                    }
                    errorStreams.add(eStream);
                }
            }
            long elapsed = Util.now() - start;
            this.processIOError(errorStreams, true);
            if (this.metrics == null) return;
            this.metrics.syncs.inc(elapsed);
            return;
        }
        finally {
            FSEditLog ie = this;
            synchronized (ie) {
                if (sync) {
                    this.synctxid = syncStart;
                    this.isSyncRunning = false;
                }
                this.notifyAll();
            }
        }
    }

    private void printStatistics(boolean force) {
        long now = Util.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null || this.editStreams.size() == 0) {
            return;
        }
        this.lastPrintTime = now;
        StringBuilder buf = new StringBuilder();
        buf.append("Number of transactions: ");
        buf.append(this.numTransactions);
        buf.append(" Total time for transactions(ms): ");
        buf.append(this.totalTimeTransactions);
        buf.append("Number of transactions batched in Syncs: ");
        buf.append(this.numTransactionsBatchedInSync);
        buf.append(" Number of syncs: ");
        buf.append(this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        int numEditStreams = this.editStreams.size();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        LOG.info((Object)buf);
    }

    public void logOpenFile(String path, INodeFileUnderConstruction newNode) {
        DeprecatedUTF8[] nameReplicationPair = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)0, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])nameReplicationPair), new ArrayWritable(Block.class, (Writable[])newNode.getBlocks()), newNode.getPermissionStatus(), new DeprecatedUTF8(newNode.getClientName()), new DeprecatedUTF8(newNode.getClientMachine())});
    }

    public void logCloseFile(String path, INodeFile newNode) {
        DeprecatedUTF8[] nameReplicationPair = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)9, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])nameReplicationPair), new ArrayWritable(Block.class, (Writable[])newNode.getBlocks()), newNode.getPermissionStatus()});
    }

    public void logMkDir(String path, INode newNode) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(path), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getAccessTime())};
        this.logEdit((byte)3, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), newNode.getPermissionStatus()});
    }

    void logRename(String src, String dst, long timestamp) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), new DeprecatedUTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)1, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logRename(String src, String dst, long timestamp, Options.Rename ... options) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), new DeprecatedUTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)15, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), FSEditLog.toBytesWritable(options)});
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new Writable[]{new DeprecatedUTF8(src), FSEditLog.toLogReplication(replication)});
    }

    void logSetQuota(String src, long nsQuota, long dsQuota) {
        this.logEdit((byte)14, new Writable[]{new DeprecatedUTF8(src), new LongWritable(nsQuota), new LongWritable(dsQuota)});
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new Writable[]{new DeprecatedUTF8(src), permissions});
    }

    void logSetOwner(String src, String username, String groupname) {
        DeprecatedUTF8 u = new DeprecatedUTF8(username == null ? "" : username);
        DeprecatedUTF8 g = new DeprecatedUTF8(groupname == null ? "" : groupname);
        this.logEdit((byte)8, new Writable[]{new DeprecatedUTF8(src), u, g});
    }

    void logConcat(String trg, String[] srcs, long timestamp) {
        int size = 1 + srcs.length + 1;
        DeprecatedUTF8[] info = new DeprecatedUTF8[size];
        int idx = 0;
        info[idx++] = new DeprecatedUTF8(trg);
        for (int i = 0; i < srcs.length; ++i) {
            info[idx++] = new DeprecatedUTF8(srcs[i]);
        }
        info[idx] = FSEditLog.toLogLong(timestamp);
        this.logEdit((byte)16, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logDelete(String src, long timestamp) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)2, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new Writable[]{new LongWritable(genstamp)});
    }

    void logTimes(String src, long mtime, long atime) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(src), FSEditLog.toLogLong(mtime), FSEditLog.toLogLong(atime)};
        this.logEdit((byte)13, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info)});
    }

    void logSymlink(String path, String value, long mtime, long atime, INodeSymlink node) {
        DeprecatedUTF8[] info = new DeprecatedUTF8[]{new DeprecatedUTF8(path), new DeprecatedUTF8(value), FSEditLog.toLogLong(mtime), FSEditLog.toLogLong(atime)};
        this.logEdit((byte)17, new Writable[]{new ArrayWritable(DeprecatedUTF8.class, (Writable[])info), node.getPermissionStatus()});
    }

    void logGetDelegationToken(DelegationTokenIdentifier id, long expiryTime) {
        this.logEdit((byte)18, new Writable[]{id, FSEditLog.toLogLong(expiryTime)});
    }

    void logRenewDelegationToken(DelegationTokenIdentifier id, long expiryTime) {
        this.logEdit((byte)19, new Writable[]{id, FSEditLog.toLogLong(expiryTime)});
    }

    void logCancelDelegationToken(DelegationTokenIdentifier id) {
        this.logEdit((byte)20, new Writable[]{id});
    }

    void logUpdateMasterKey(DelegationKey key) {
        this.logEdit((byte)21, new Writable[]{key});
    }

    private static DeprecatedUTF8 toLogReplication(short replication) {
        return new DeprecatedUTF8(Short.toString(replication));
    }

    private static DeprecatedUTF8 toLogLong(long timestamp) {
        return new DeprecatedUTF8(Long.toString(timestamp));
    }

    synchronized long getEditLogSize() throws IOException {
        assert (this.getNumEditsDirs() <= this.getNumEditStreams()) : "Number of edits directories should not exceed the number of streams.";
        long size = 0L;
        ArrayList<EditLogOutputStream> al = null;
        for (int idx = 0; idx < this.getNumEditStreams(); ++idx) {
            EditLogOutputStream es = this.editStreams.get(idx);
            try {
                long curSize = es.length();
                assert (size == 0L || size == curSize || curSize == 0L) : "Wrong streams size";
                size = Math.max(size, curSize);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)("getEditLogSize: editstream.length failed. removing editlog (" + idx + ") " + es.getName()));
                if (al == null) {
                    al = new ArrayList<EditLogOutputStream>(1);
                }
                al.add(es);
            }
        }
        if (al != null) {
            this.processIOError(al, true);
        }
        return size;
    }

    synchronized void rollEditLog() throws IOException {
        this.waitForSyncToFinish();
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (!it.hasNext()) {
            return;
        }
        boolean alreadyExists = this.existsNew(it.next());
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (alreadyExists == this.existsNew(sd)) continue;
            throw new IOException(this.getEditNewFile(sd) + "should " + (alreadyExists ? "" : "not ") + "exist.");
        }
        if (alreadyExists) {
            return;
        }
        this.fsimage.attemptRestoreRemovedStorage();
        this.divertFileStreams("current/" + FSImage.NameNodeFile.EDITS_NEW.getName());
    }

    synchronized void divertFileStreams(String dest) throws IOException {
        this.waitForSyncToFinish();
        assert (this.getNumEditStreams() >= this.getNumEditsDirs()) : "Inconsistent number of streams";
        ArrayList<EditLogOutputStream> errorStreams = null;
        EditStreamIterator itE = (EditStreamIterator)this.getOutputStreamIterator(JournalStream.JournalType.FILE);
        Iterator<Storage.StorageDirectory> itD = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (itE.hasNext() && itD.hasNext()) {
            EditLogOutputStream eStream = itE.next();
            Storage.StorageDirectory sd = itD.next();
            if (!eStream.getName().startsWith(sd.getRoot().getPath())) {
                throw new IOException("Inconsistent order of edit streams: " + eStream);
            }
            try {
                this.closeStream(eStream);
                eStream = new EditLogFileOutputStream(new File(sd.getRoot(), dest), this.sizeOutputFlushBuffer);
                eStream.create();
                itE.replace(eStream);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)e);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
    }

    synchronized void purgeEditLog() throws IOException {
        this.waitForSyncToFinish();
        this.revertFileStreams("current/" + FSImage.NameNodeFile.EDITS_NEW.getName());
    }

    synchronized void waitForSyncToFinish() {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void revertFileStreams(String source) throws IOException {
        this.waitForSyncToFinish();
        assert (this.getNumEditStreams() >= this.getNumEditsDirs()) : "Inconsistent number of streams";
        ArrayList<EditLogOutputStream> errorStreams = null;
        EditStreamIterator itE = (EditStreamIterator)this.getOutputStreamIterator(JournalStream.JournalType.FILE);
        Iterator<Storage.StorageDirectory> itD = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (itE.hasNext() && itD.hasNext()) {
            EditLogOutputStream eStream = itE.next();
            Storage.StorageDirectory sd = itD.next();
            if (!eStream.getName().startsWith(sd.getRoot().getPath())) {
                throw new IOException("Inconsistent order of edit streams: " + eStream + " does not start with " + sd.getRoot().getPath());
            }
            try {
                this.closeStream(eStream);
                File editFile = this.getEditFile(sd);
                File prevEditFile = new File(sd.getRoot(), source);
                if (!(!prevEditFile.exists() || prevEditFile.renameTo(editFile) || editFile.delete() && prevEditFile.renameTo(editFile))) {
                    throw new IOException("Rename failed for " + sd.getRoot());
                }
                eStream = new EditLogFileOutputStream(editFile, this.sizeOutputFlushBuffer);
                itE.replace(eStream);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)e);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
    }

    synchronized File getFsEditName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            sd = it.next();
            if (!sd.getRoot().canRead()) continue;
            return this.getEditFile(sd);
        }
        return null;
    }

    synchronized long getFsEditTime() {
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (it.hasNext()) {
            return this.getEditFile(it.next()).lastModified();
        }
        return 0L;
    }

    synchronized long getSyncTxId() {
        return this.synctxid;
    }

    public void setBufferCapacity(int size) {
        this.sizeOutputFlushBuffer = size;
    }

    boolean isEmpty() throws IOException {
        return this.getEditLogSize() <= 0L;
    }

    synchronized void logJSpoolStart(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        if (bnReg.isRole(HdfsConstants.NamenodeRole.CHECKPOINT)) {
            return;
        }
        if (this.editStreams == null) {
            this.editStreams = new ArrayList();
        }
        EditLogOutputStream boStream = null;
        for (EditLogOutputStream eStream : this.editStreams) {
            if (!eStream.getName().equals(bnReg.getAddress())) continue;
            boStream = eStream;
            break;
        }
        if (boStream == null) {
            boStream = new EditLogBackupOutputStream(bnReg, nnReg);
            this.editStreams.add(boStream);
        }
        this.logEdit((byte)102, (Writable[])null);
    }

    synchronized void logEdit(int length, byte[] data) {
        if (this.getNumEditStreams() == 0) {
            throw new IllegalStateException(NO_JOURNAL_STREAMS_WARNING);
        }
        ArrayList<EditLogOutputStream> errorStreams = null;
        long start = Util.now();
        for (EditLogOutputStream eStream : this.editStreams) {
            try {
                eStream.write(data, 0, length);
            }
            catch (IOException ie) {
                LOG.warn((Object)("Error in editStream " + eStream.getName()), (Throwable)ie);
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
            }
        }
        this.processIOError(errorStreams, true);
        this.recordTransaction(start);
    }

    public Iterator<EditLogOutputStream> getOutputStreamIterator(JournalStream.JournalType streamType) {
        return new EditStreamIterator(streamType);
    }

    private void closeStream(EditLogOutputStream eStream) throws IOException {
        eStream.setReadyToFlush();
        eStream.flush();
        eStream.close();
    }

    void incrementCheckpointTime() {
        this.fsimage.incrementCheckpointTime();
        Writable[] args = new Writable[]{new LongWritable(this.fsimage.getCheckpointTime())};
        this.logEdit((byte)103, args);
    }

    synchronized void releaseBackupStream(NamenodeRegistration registration) {
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(JournalStream.JournalType.BACKUP);
        ArrayList<EditLogBackupOutputStream> errorStreams = null;
        NamenodeRegistration backupNode = null;
        while (it.hasNext()) {
            EditLogBackupOutputStream eStream = (EditLogBackupOutputStream)it.next();
            backupNode = eStream.getRegistration();
            if (!backupNode.getAddress().equals(registration.getAddress()) || !backupNode.isRole(registration.getRole())) continue;
            errorStreams = new ArrayList<EditLogBackupOutputStream>(1);
            errorStreams.add(eStream);
            break;
        }
        assert (backupNode == null || backupNode.isRole(HdfsConstants.NamenodeRole.BACKUP)) : "Not a backup node corresponds to a backup stream";
        this.processIOError(errorStreams, true);
    }

    synchronized boolean checkBackupRegistration(NamenodeRegistration registration) {
        Iterator<EditLogOutputStream> it = this.getOutputStreamIterator(JournalStream.JournalType.BACKUP);
        boolean regAllowed = !it.hasNext();
        NamenodeRegistration backupNode = null;
        ArrayList<EditLogBackupOutputStream> errorStreams = null;
        while (it.hasNext()) {
            EditLogBackupOutputStream eStream = (EditLogBackupOutputStream)it.next();
            backupNode = eStream.getRegistration();
            if (backupNode.getAddress().equals(registration.getAddress()) && backupNode.isRole(registration.getRole())) {
                regAllowed = true;
                break;
            }
            if (eStream.isAlive()) continue;
            if (errorStreams == null) {
                errorStreams = new ArrayList<EditLogBackupOutputStream>(1);
            }
            errorStreams.add(eStream);
            regAllowed = true;
        }
        assert (backupNode == null || backupNode.isRole(HdfsConstants.NamenodeRole.BACKUP)) : "Not a backup node corresponds to a backup stream";
        this.processIOError(errorStreams, true);
        return regAllowed;
    }

    static BytesWritable toBytesWritable(Options.Rename ... options) {
        byte[] bytes = new byte[options.length];
        for (int i = 0; i < options.length; ++i) {
            bytes[i] = options[i].value();
        }
        return new BytesWritable(bytes);
    }

    private class EditStreamIterator
    implements Iterator<EditLogOutputStream> {
        JournalStream.JournalType type;
        int prevIndex;
        int nextIndex;

        EditStreamIterator(JournalStream.JournalType streamType) {
            this.type = streamType;
            this.nextIndex = 0;
            this.prevIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                if (FSEditLog.this.editStreams == null || FSEditLog.this.editStreams.isEmpty() || this.nextIndex >= FSEditLog.this.editStreams.size()) {
                    return false;
                }
                while (this.nextIndex < FSEditLog.this.editStreams.size() && !((EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex)).getType().isOfType(this.type)) {
                    ++this.nextIndex;
                }
                return this.nextIndex < FSEditLog.this.editStreams.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EditLogOutputStream next() {
            EditLogOutputStream stream = null;
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                stream = (EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex);
                this.prevIndex = this.nextIndex++;
                while (this.nextIndex < FSEditLog.this.editStreams.size() && !((EditLogOutputStream)FSEditLog.this.editStreams.get(this.nextIndex)).getType().isOfType(this.type)) {
                    ++this.nextIndex;
                }
            }
            return stream;
        }

        @Override
        public void remove() {
            this.nextIndex = this.prevIndex;
            FSEditLog.this.removeStream(this.prevIndex);
            this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replace(EditLogOutputStream newStream) {
            FSEditLog fSEditLog = FSEditLog.this;
            synchronized (fSEditLog) {
                assert (0 <= this.prevIndex && this.prevIndex < FSEditLog.this.editStreams.size()) : "Index out of bound.";
                FSEditLog.this.editStreams.set(this.prevIndex, newStream);
            }
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }

    static abstract class Ops {
        public static final byte OP_INVALID = -1;
        public static final byte OP_ADD = 0;
        public static final byte OP_RENAME_OLD = 1;
        public static final byte OP_DELETE = 2;
        public static final byte OP_MKDIR = 3;
        public static final byte OP_SET_REPLICATION = 4;
        @Deprecated
        public static final byte OP_DATANODE_ADD = 5;
        @Deprecated
        public static final byte OP_DATANODE_REMOVE = 6;
        public static final byte OP_SET_PERMISSIONS = 7;
        public static final byte OP_SET_OWNER = 8;
        public static final byte OP_CLOSE = 9;
        public static final byte OP_SET_GENSTAMP = 10;
        public static final byte OP_SET_NS_QUOTA = 11;
        public static final byte OP_CLEAR_NS_QUOTA = 12;
        public static final byte OP_TIMES = 13;
        public static final byte OP_SET_QUOTA = 14;
        public static final byte OP_RENAME = 15;
        public static final byte OP_CONCAT_DELETE = 16;
        public static final byte OP_SYMLINK = 17;
        public static final byte OP_GET_DELEGATION_TOKEN = 18;
        public static final byte OP_RENEW_DELEGATION_TOKEN = 19;
        public static final byte OP_CANCEL_DELEGATION_TOKEN = 20;
        public static final byte OP_UPDATE_MASTER_KEY = 21;
        static final byte OP_JSPOOL_START = 102;
        static final byte OP_CHECKPOINT_TIME = 103;

        Ops() {
        }
    }
}

