/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";

    private static void printUsage(PrintStream err) throws IOException {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)err);
        System.exit(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((Path)file, (Configuration)conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTPS url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        String[] remaining = parser.getRemainingArgs();
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        final Path tokenFile = new Path(local.getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
                        id.readFields(in);
                        System.out.println("Token (" + (Object)((Object)id) + ") for " + token.getService());
                    }
                    return null;
                }
                if (webUrl != null) {
                    if (renew) {
                        for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                            long result = DelegationTokenFetcher.renewDelegationToken(webUrl, (Token<DelegationTokenIdentifier>)token);
                            System.out.println("Renewed token via " + webUrl + " for " + token.getService() + " until: " + new Date(result));
                        }
                    } else if (cancel) {
                        for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                            DelegationTokenFetcher.cancelDelegationToken(webUrl, (Token<DelegationTokenIdentifier>)token);
                            System.out.println("Cancelled token via " + webUrl + " for " + token.getService());
                        }
                    } else {
                        Credentials creds = DelegationTokenFetcher.getDTfromRemote(webUrl, renewer);
                        creds.writeTokenStorageFile(tokenFile, conf);
                        for (Token token : creds.getAllTokens()) {
                            System.out.println("Fetched token via " + webUrl + " for " + token.getService() + " into " + tokenFile);
                        }
                    }
                } else {
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    if (cancel) {
                        for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                            ((DistributedFileSystem)fs).cancelDelegationToken((Token<DelegationTokenIdentifier>)token);
                            System.out.println("Cancelled token for " + token.getService());
                        }
                    } else if (renew) {
                        for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                            long result = ((DistributedFileSystem)fs).renewDelegationToken((Token<DelegationTokenIdentifier>)token);
                            System.out.println("Renewed token for " + token.getService() + " until: " + new Date(result));
                        }
                    } else {
                        Token token = fs.getDelegationToken(renewer);
                        Credentials cred = new Credentials();
                        cred.addToken(token.getService(), token);
                        cred.writeTokenStorageFile(tokenFile, conf);
                        System.out.println("Fetched token for " + token.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }

    public static Credentials getDTfromRemote(String nnAddr, String renewer) throws IOException {
        FilterInputStream dis = null;
        try {
            StringBuffer url = new StringBuffer();
            if (renewer != null) {
                url.append(nnAddr).append("/getDelegationToken").append("?").append(RENEWER).append("=").append(renewer);
            } else {
                url.append(nnAddr).append("/getDelegationToken");
            }
            URL remoteURL = new URL(url.toString());
            SecurityUtil.fetchServiceTicket((URL)remoteURL);
            URLConnection connection = remoteURL.openConnection();
            InputStream in = connection.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields((DataInput)((Object)dis));
            Credentials credentials = ts;
            return credentials;
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain remote token", e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static long renewDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/renewDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        BufferedReader in = null;
        try {
            URL url = new URL(buf.toString());
            SecurityUtil.fetchServiceTicket((URL)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error renewing token: " + connection.getResponseMessage());
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            long result = Long.parseLong(in.readLine());
            in.close();
            return result;
        }
        catch (IOException ie) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw ie;
        }
    }

    public static void cancelDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/cancelDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        Object in = null;
        try {
            URL url = new URL(buf.toString());
            SecurityUtil.fetchServiceTicket((URL)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error cancelling token: " + connection.getResponseMessage());
            }
        }
        catch (IOException ie) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw ie;
        }
    }

    static {
        System.setProperty("https.cipherSuites", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
    }
}

