/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;

class ImageLoaderCurrent
implements ImageLoader {
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static int[] versions = new int[]{-16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -31, -32, -33};
    private int imageVersion = 0;

    ImageLoaderCurrent() {
    }

    @Override
    public boolean canLoadVersion(int version) {
        for (int v : versions) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadImage(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        try {
            v.start();
            v.visitEnclosingElement(ImageVisitor.ImageElement.FS_IMAGE);
            this.imageVersion = in.readInt();
            if (!this.canLoadVersion(this.imageVersion)) {
                throw new IOException("Cannot process fslayout version " + this.imageVersion);
            }
            v.visit(ImageVisitor.ImageElement.IMAGE_VERSION, this.imageVersion);
            v.visit(ImageVisitor.ImageElement.NAMESPACE_ID, in.readInt());
            long numInodes = in.readLong();
            v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
            if (LayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, this.imageVersion)) {
                boolean isCompressed = in.readBoolean();
                v.visit(ImageVisitor.ImageElement.IS_COMPRESSED, this.imageVersion);
                if (isCompressed) {
                    String codecClassName = Text.readString((DataInput)in);
                    v.visit(ImageVisitor.ImageElement.COMPRESS_CODEC, codecClassName);
                    CompressionCodecFactory codecFac = new CompressionCodecFactory(new Configuration());
                    CompressionCodec codec = codecFac.getCodecByClassName(codecClassName);
                    if (codec == null) {
                        throw new IOException("Image compression codec not supported: " + codecClassName);
                    }
                    in = new DataInputStream((InputStream)codec.createInputStream((InputStream)in));
                }
            }
            this.processINodes(in, v, numInodes, skipBlocks);
            this.processINodesUC(in, v, skipBlocks);
            if (LayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, this.imageVersion)) {
                this.processDelegationTokens(in, v);
            }
            v.leaveEnclosingElement();
            v.finish();
        }
        catch (IOException e) {
            v.finishAbnormally();
            throw e;
        }
    }

    private void processDelegationTokens(DataInputStream in, ImageVisitor v) throws IOException {
        v.visit(ImageVisitor.ImageElement.CURRENT_DELEGATION_KEY_ID, in.readInt());
        int numDKeys = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_KEYS, ImageVisitor.ImageElement.NUM_DELEGATION_KEYS, numDKeys);
        for (int i = 0; i < numDKeys; ++i) {
            DelegationKey key = new DelegationKey();
            key.readFields((DataInput)in);
            v.visit(ImageVisitor.ImageElement.DELEGATION_KEY, key.toString());
        }
        v.leaveEnclosingElement();
        v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_SEQUENCE_NUMBER, in.readInt());
        int numDTokens = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_TOKENS, ImageVisitor.ImageElement.NUM_DELEGATION_TOKENS, numDTokens);
        for (int i = 0; i < numDTokens; ++i) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            id.readFields(in);
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER, id.toString());
        }
        v.leaveEnclosingElement();
    }

    private void processINodesUC(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        int numINUC = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES_UNDER_CONSTRUCTION, ImageVisitor.ImageElement.NUM_INODES_UNDER_CONSTRUCTION, numINUC);
        for (int i = 0; i < numINUC; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION);
            byte[] name = FSImageSerialization.readBytes(in);
            String n = new String(name, "UTF8");
            v.visit(ImageVisitor.ImageElement.INODE_PATH, n);
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            v.visit(ImageVisitor.ImageElement.PREFERRED_BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            this.processPermission(in, v);
            v.visit(ImageVisitor.ImageElement.CLIENT_NAME, FSImageSerialization.readString(in));
            v.visit(ImageVisitor.ImageElement.CLIENT_MACHINE, FSImageSerialization.readString(in));
            int numLocs = in.readInt();
            for (int j = 0; j < numLocs; ++j) {
                in.readShort();
                in.readLong();
                in.readLong();
                in.readLong();
                in.readInt();
                FSImageSerialization.readString(in);
                FSImageSerialization.readString(in);
                WritableUtils.readEnum((DataInput)in, DatanodeInfo.AdminStates.class);
            }
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processBlocks(DataInputStream in, ImageVisitor v, int numBlocks, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCKS, ImageVisitor.ImageElement.NUM_BLOCKS, numBlocks);
        if (numBlocks == -1 || numBlocks == -2) {
            v.leaveEnclosingElement();
            return;
        }
        if (skipBlocks) {
            int bytesToSkip = 24 * numBlocks;
            if (in.skipBytes(bytesToSkip) != bytesToSkip) {
                throw new IOException("Error skipping over blocks");
            }
        } else {
            for (int j = 0; j < numBlocks; ++j) {
                v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCK);
                v.visit(ImageVisitor.ImageElement.BLOCK_ID, in.readLong());
                v.visit(ImageVisitor.ImageElement.NUM_BYTES, in.readLong());
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
                v.leaveEnclosingElement();
            }
        }
        v.leaveEnclosingElement();
    }

    private void processPermission(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.PERMISSIONS);
        v.visit(ImageVisitor.ImageElement.USER_NAME, Text.readString((DataInput)in));
        v.visit(ImageVisitor.ImageElement.GROUP_NAME, Text.readString((DataInput)in));
        FsPermission fsp = new FsPermission(in.readShort());
        v.visit(ImageVisitor.ImageElement.PERMISSION_STRING, fsp.toString());
        v.leaveEnclosingElement();
    }

    private void processINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES, ImageVisitor.ImageElement.NUM_INODES, numInodes);
        for (long i = 0L; i < numInodes; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE);
            v.visit(ImageVisitor.ImageElement.INODE_PATH, FSImageSerialization.readString(in));
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.ACCESS_TIME, this.formatDate(in.readLong()));
            }
            v.visit(ImageVisitor.ImageElement.BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            if (numBlocks > 0 || numBlocks == -1) {
                v.visit(ImageVisitor.ImageElement.NS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
                if (LayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, this.imageVersion)) {
                    v.visit(ImageVisitor.ImageElement.DS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
                }
            }
            if (numBlocks == -2) {
                v.visit(ImageVisitor.ImageElement.SYMLINK, Text.readString((DataInput)in));
            }
            this.processPermission(in, v);
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private String formatDate(long date) {
        return this.dateFormat.format(new Date(date));
    }
}

