/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;

@InterfaceAudience.Private
public class DelegationTokenSelector
extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
    public static final String SERVICE_NAME_KEY = "hdfs.service.host_";
    private static final DelegationTokenSelector INSTANCE = new DelegationTokenSelector();

    public static Token<DelegationTokenIdentifier> selectHdfsDelegationToken(InetSocketAddress nnAddr, UserGroupInformation ugi, Configuration conf) {
        String key = SERVICE_NAME_KEY + SecurityUtil.buildTokenService((InetSocketAddress)nnAddr);
        String nnServiceName = conf.get(key);
        int nnRpcPort = 8020;
        if (nnServiceName != null) {
            nnRpcPort = NetUtils.createSocketAddr((String)nnServiceName, (int)nnRpcPort).getPort();
        }
        Text serviceName = SecurityUtil.buildTokenService((InetSocketAddress)new InetSocketAddress(nnAddr.getHostName(), nnRpcPort));
        return INSTANCE.selectToken(serviceName, ugi.getTokens());
    }

    public DelegationTokenSelector() {
        super(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }
}

