/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
class DatanodeUtil {
    private static final String DISK_ERROR = "Possible disk error on file creation: ";

    DatanodeUtil() {
    }

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    static File createTmpFile(Block b, File f) throws IOException {
        boolean fileCreated;
        if (f.exists()) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
        }
        try {
            fileCreated = f.createNewFile();
        }
        catch (IOException ioe) {
            throw (IOException)new IOException(DISK_ERROR + f).initCause(ioe);
        }
        if (!fileCreated) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
        }
        return f;
    }
}

