/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public abstract class ReplicaInfo
extends Block
implements Replica {
    private FSDataset.FSVolume volume;
    private File dir;

    ReplicaInfo(long blockId, long genStamp, FSDataset.FSVolume vol, File dir) {
        this(blockId, 0L, genStamp, vol, dir);
    }

    ReplicaInfo(Block block, FSDataset.FSVolume vol, File dir) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir);
    }

    ReplicaInfo(long blockId, long len, long genStamp, FSDataset.FSVolume vol, File dir) {
        super(blockId, len, genStamp);
        this.volume = vol;
        this.dir = dir;
    }

    ReplicaInfo(ReplicaInfo from) {
        this(from, from.getVolume(), from.getDir());
    }

    private String getMetaFileName() {
        return this.getBlockName() + "_" + this.getGenerationStamp() + ".meta";
    }

    File getBlockFile() {
        return new File(this.getDir(), this.getBlockName());
    }

    File getMetaFile() {
        return new File(this.getDir(), this.getMetaFileName());
    }

    FSDataset.FSVolume getVolume() {
        return this.volume;
    }

    void setVolume(FSDataset.FSVolume vol) {
        this.volume = vol;
    }

    File getDir() {
        return this.dir;
    }

    void setDir(File dir) {
        this.dir = dir;
    }

    boolean isUnlinked() {
        return true;
    }

    void setUnlinked() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkFile(File file, Block b) throws IOException {
        File tmpFile = DatanodeUtil.createTmpFile(b, FSDataset.getUnlinkTmpFile(file));
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)16384);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            if (file.length() != tmpFile.length()) {
                throw new IOException("Copy of file " + file + " size " + file.length() + " into file " + tmpFile + " resulted in a size of " + tmpFile.length());
            }
            FileUtil.replaceFile((File)tmpFile, (File)file);
        }
        catch (IOException e) {
            boolean done = tmpFile.delete();
            if (!done) {
                DataNode.LOG.info((Object)("detachFile failed to delete temporary file " + tmpFile));
            }
            throw e;
        }
    }

    boolean unlinkBlock(int numLinks) throws IOException {
        if (this.isUnlinked()) {
            return false;
        }
        File file = this.getBlockFile();
        if (file == null || this.getVolume() == null) {
            throw new IOException("detachBlock:Block not found. " + this);
        }
        File meta = this.getMetaFile();
        if (meta == null) {
            throw new IOException("Meta file not found for block " + this);
        }
        if (HardLink.getLinkCount((File)file) > numLinks) {
            DataNode.LOG.info((Object)("CopyOnWrite for block " + this));
            this.unlinkFile(file, this);
        }
        if (HardLink.getLinkCount((File)meta) > numLinks) {
            this.unlinkFile(meta, this);
        }
        this.setUnlinked();
        return true;
    }

    void setNewerGenerationStamp(long newGS) throws IOException {
        long curGS = this.getGenerationStamp();
        if (newGS <= curGS) {
            throw new IOException("New generation stamp (" + newGS + ") must be greater than current one (" + curGS + ")");
        }
        this.setGenerationStamp(newGS);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ", " + super.toString() + ", " + (Object)((Object)this.getState()) + "\n  getNumBytes()     = " + this.getNumBytes() + "\n  getBytesOnDisk()  = " + this.getBytesOnDisk() + "\n  getVisibleLength()= " + this.getVisibleLength() + "\n  getVolume()       = " + this.getVolume() + "\n  getBlockFile()    = " + this.getBlockFile();
    }
}

