/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;

class EditLogBackupInputStream
extends EditLogInputStream {
    String address;
    private ByteBufferInputStream inner;
    private DataInputStream in;
    private FSEditLogOp.Reader reader = null;
    private FSEditLogLoader.PositionTrackingInputStream tracker = null;
    private int version = 0;

    EditLogBackupInputStream(String name) throws IOException {
        this.address = name;
        this.inner = new ByteBufferInputStream();
        this.in = null;
        this.reader = null;
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public JournalStream.JournalType getType() {
        return JournalStream.JournalType.BACKUP;
    }

    @Override
    public FSEditLogOp readOp() throws IOException {
        Preconditions.checkState((this.reader != null ? 1 : 0) != 0, (Object)"Must call setBytes() before readOp()");
        return this.reader.readOp();
    }

    @Override
    public int getVersion() throws IOException {
        return this.version;
    }

    @Override
    public long getPosition() {
        return this.tracker.getPos();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    long length() throws IOException {
        return this.inner.length();
    }

    void setBytes(byte[] newBytes, int version) throws IOException {
        this.inner.setData(newBytes);
        this.tracker = new FSEditLogLoader.PositionTrackingInputStream(this.inner);
        this.in = new DataInputStream(this.tracker);
        this.version = version;
        this.reader = new FSEditLogOp.Reader(this.in, version);
    }

    void clear() throws IOException {
        this.setBytes(null, 0);
        this.reader = null;
        this.version = 0;
    }

    private static class ByteBufferInputStream
    extends ByteArrayInputStream {
        ByteBufferInputStream() {
            super(new byte[0]);
        }

        void setData(byte[] newBytes) {
            this.buf = newBytes;
            this.count = newBytes == null ? 0 : newBytes.length;
            this.mark = 0;
            this.reset();
        }

        int length() {
            return this.count;
        }
    }
}

