/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.UpgradeManager;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImagePreTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Private
public class NNStorage
extends Storage
implements Closeable {
    private static final Log LOG = LogFactory.getLog((String)NNStorage.class.getName());
    static final String DEPRECATED_MESSAGE_DIGEST_PROPERTY = "imageMD5Digest";
    private UpgradeManager upgradeManager = null;
    protected String blockpoolID = "";
    private boolean restoreFailedStorage = false;
    private Object restorationLock = new Object();
    private boolean disablePreUpgradableLayoutCheck = false;
    protected long mostRecentCheckpointTxId = -12345L;
    protected final List<Storage.StorageDirectory> removedStorageDirs = new CopyOnWriteArrayList<Storage.StorageDirectory>();
    private HashMap<String, String> deprecatedProperties;

    public NNStorage(Configuration conf, Collection<URI> imageDirs, Collection<URI> editsDirs) throws IOException {
        super(HdfsServerConstants.NodeType.NAME_NODE);
        this.storageDirs = new CopyOnWriteArrayList();
        this.setStorageDirectories(imageDirs, editsDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        if (this.disablePreUpgradableLayoutCheck) {
            return false;
        }
        File oldImageDir = new File(sd.getRoot(), "image");
        if (!oldImageDir.exists()) {
            return false;
        }
        File oldF = new File(oldImageDir, "fsimage");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            oldFile.seek(0L);
            int oldVersion = oldFile.readInt();
            if (oldVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldFile.close();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.unlockAll();
        this.storageDirs.clear();
    }

    void setRestoreFailedStorage(boolean val) {
        LOG.warn((Object)("set restore failed storage to " + val));
        this.restoreFailedStorage = val;
    }

    boolean getRestoreFailedStorage() {
        return this.restoreFailedStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptRestoreRemovedStorage() {
        if (!this.restoreFailedStorage || this.removedStorageDirs.size() == 0) {
            return;
        }
        Object object = this.restorationLock;
        synchronized (object) {
            LOG.info((Object)("NNStorage.attemptRestoreRemovedStorage: check removed(failed) storarge. removedStorages size = " + this.removedStorageDirs.size()));
            for (Storage.StorageDirectory sd : this.removedStorageDirs) {
                File root = sd.getRoot();
                LOG.info((Object)("currently disabled dir " + root.getAbsolutePath() + "; type=" + sd.getStorageDirType() + ";canwrite=" + root.canWrite()));
                if (!root.exists() || !root.canWrite()) continue;
                LOG.info((Object)("restoring dir " + sd.getRoot().getAbsolutePath()));
                this.addStorageDir(sd);
                this.removedStorageDirs.remove(sd);
            }
        }
    }

    List<Storage.StorageDirectory> getRemovedStorageDirs() {
        return this.removedStorageDirs;
    }

    @VisibleForTesting
    synchronized void setStorageDirectories(Collection<URI> fsNameDirs, Collection<URI> fsEditsDirs) throws IOException {
        this.storageDirs.clear();
        this.removedStorageDirs.clear();
        for (URI dirName : fsNameDirs) {
            NameNodeDirType dirType;
            NNStorage.checkSchemeConsistency(dirName);
            boolean isAlsoEdits = false;
            for (URI editsDirName : fsEditsDirs) {
                if (editsDirName.compareTo(dirName) != 0) continue;
                isAlsoEdits = true;
                fsEditsDirs.remove(editsDirName);
                break;
            }
            NameNodeDirType nameNodeDirType = dirType = isAlsoEdits ? NameNodeDirType.IMAGE_AND_EDITS : NameNodeDirType.IMAGE;
            if (dirName.getScheme().compareTo(JournalStream.JournalType.FILE.name().toLowerCase()) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), dirType));
        }
        for (URI dirName : fsEditsDirs) {
            NNStorage.checkSchemeConsistency(dirName);
            if (dirName.getScheme().compareTo(JournalStream.JournalType.FILE.name().toLowerCase()) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), NameNodeDirType.EDITS));
        }
    }

    private static void checkSchemeConsistency(URI u) throws IOException {
        String scheme = u.getScheme();
        if (scheme == null) {
            throw new IOException("Undefined scheme for " + u);
        }
        try {
            JournalStream.JournalType.valueOf(scheme.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Unknown scheme " + scheme + ". It should correspond to a JournalType enumeration value");
        }
    }

    Collection<URI> getImageDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.IMAGE);
    }

    Collection<URI> getEditsDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.EDITS);
    }

    int getNumStorageDirs(NameNodeDirType dirType) {
        if (dirType == null) {
            return this.getNumStorageDirs();
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator(dirType);
        int numDirs = 0;
        while (it.hasNext()) {
            ++numDirs;
            it.next();
        }
        return numDirs;
    }

    Collection<URI> getDirectories(NameNodeDirType dirType) throws IOException {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<URI> list = new ArrayList<URI>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                list.add(Util.fileAsURI(sd.getRoot()));
            }
            catch (IOException e) {
                throw new IOException("Exception while processing StorageDirectory " + sd.getRoot(), e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readTransactionIdFile(Storage.StorageDirectory sd) throws IOException {
        File txidFile = NNStorage.getStorageFile(sd, NameNodeFile.SEEN_TXID);
        long txid = 0L;
        if (txidFile.exists() && txidFile.canRead()) {
            BufferedReader br = new BufferedReader(new FileReader(txidFile));
            try {
                txid = Long.valueOf(br.readLine());
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{br});
        }
        return txid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTransactionIdFile(Storage.StorageDirectory sd, long txid) throws IOException {
        Preconditions.checkArgument((txid >= 0L ? 1 : 0) != 0, (Object)("bad txid: " + txid));
        File txIdFile = NNStorage.getStorageFile(sd, NameNodeFile.SEEN_TXID);
        AtomicFileOutputStream fos = new AtomicFileOutputStream(txIdFile);
        try {
            ((OutputStream)fos).write(String.valueOf(txid).getBytes());
            ((OutputStream)fos).write(10);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos});
    }

    void setMostRecentCheckpointTxId(long txid) {
        this.mostRecentCheckpointTxId = txid;
    }

    long getMostRecentCheckpointTxId() {
        return this.mostRecentCheckpointTxId;
    }

    public void writeTransactionIdFileToStorage(long txid) {
        for (Storage.StorageDirectory sd : this.storageDirs) {
            try {
                this.writeTransactionIdFile(sd, txid);
            }
            catch (IOException e) {
                LOG.warn((Object)("writeTransactionIdToStorage failed on " + sd), (Throwable)e);
                this.reportErrorsOnDirectory(sd);
            }
        }
    }

    public File[] getFsImageNameCheckpoint(long txid) {
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            list.add(NNStorage.getStorageFile(it.next(), NameNodeFile.IMAGE_NEW, txid));
        }
        return list.toArray(new File[list.size()]);
    }

    public File getFsImageName(long txid) {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = it.next();
            File fsImage = NNStorage.getStorageFile(sd, NameNodeFile.IMAGE, txid);
            if (!sd.getRoot().canRead() || !fsImage.exists()) continue;
            return fsImage;
        }
        return null;
    }

    private void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        this.writeProperties(sd);
        this.writeTransactionIdFile(sd, 0L);
        LOG.info((Object)("Storage directory " + sd.getRoot() + " has been successfully formatted."));
    }

    public void format(String clusterId) throws IOException {
        this.layoutVersion = HdfsConstants.LAYOUT_VERSION;
        this.namespaceID = this.newNamespaceID();
        this.clusterID = clusterId;
        this.blockpoolID = this.newBlockPoolID();
        this.cTime = 0L;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            this.format(sd);
        }
    }

    private int newNamespaceID() {
        int newID = 0;
        while (newID == 0) {
            newID = DFSUtil.getRandom().nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFieldsFromProperties(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.getRoot() + " is not formatted.");
        }
        if (LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            String sbpid = props.getProperty("blockpoolID");
            this.setBlockPoolID(sd.getRoot(), sbpid);
        }
        String sDUS = props.getProperty("distributedUpgradeState");
        String sDUV = props.getProperty("distributedUpgradeVersion");
        this.setDistributedUpgradeState(sDUS == null ? false : Boolean.parseBoolean(sDUS), sDUV == null ? this.getLayoutVersion() : Integer.parseInt(sDUV));
        this.setDeprecatedPropertiesForUpgrade(props);
    }

    private void setDeprecatedPropertiesForUpgrade(Properties props) {
        this.deprecatedProperties = new HashMap();
        String md5 = props.getProperty(DEPRECATED_MESSAGE_DIGEST_PROPERTY);
        if (md5 != null) {
            this.deprecatedProperties.put(DEPRECATED_MESSAGE_DIGEST_PROPERTY, md5);
        }
    }

    String getDeprecatedProperty(String prop) {
        assert (this.getLayoutVersion() > HdfsConstants.LAYOUT_VERSION) : "getDeprecatedProperty should only be done when loading storage from past versions during upgrade.";
        return this.deprecatedProperties.get(prop);
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setPropertiesFromFields(props, sd);
        if (LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            props.setProperty("blockpoolID", this.blockpoolID);
        }
        boolean uState = this.getDistributedUpgradeState();
        int uVersion = this.getDistributedUpgradeVersion();
        if (uState && uVersion != this.getLayoutVersion()) {
            props.setProperty("distributedUpgradeState", Boolean.toString(uState));
            props.setProperty("distributedUpgradeVersion", Integer.toString(uVersion));
        }
    }

    static File getStorageFile(Storage.StorageDirectory sd, NameNodeFile type, long imageTxId) {
        return new File(sd.getCurrentDir(), String.format("%s_%019d", type.getName(), imageTxId));
    }

    static File getStorageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    @VisibleForTesting
    public static String getCheckpointImageFileName(long txid) {
        return String.format("%s_%019d", NameNodeFile.IMAGE_NEW.getName(), txid);
    }

    @VisibleForTesting
    public static String getImageFileName(long txid) {
        return String.format("%s_%019d", NameNodeFile.IMAGE.getName(), txid);
    }

    @VisibleForTesting
    public static String getInProgressEditsFileName(long startTxId) {
        return String.format("%s_%019d", NameNodeFile.EDITS_INPROGRESS.getName(), startTxId);
    }

    static File getInProgressEditsFile(Storage.StorageDirectory sd, long startTxId) {
        return new File(sd.getCurrentDir(), NNStorage.getInProgressEditsFileName(startTxId));
    }

    static File getFinalizedEditsFile(Storage.StorageDirectory sd, long startTxId, long endTxId) {
        return new File(sd.getCurrentDir(), NNStorage.getFinalizedEditsFileName(startTxId, endTxId));
    }

    static File getImageFile(Storage.StorageDirectory sd, long txid) {
        return new File(sd.getCurrentDir(), NNStorage.getImageFileName(txid));
    }

    @VisibleForTesting
    public static String getFinalizedEditsFileName(long startTxId, long endTxId) {
        return String.format("%s_%019d-%019d", NameNodeFile.EDITS.getName(), startTxId, endTxId);
    }

    File findFinalizedEditsFile(long startTxId, long endTxId) throws IOException {
        File ret = this.findFile(NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName(startTxId, endTxId));
        if (ret == null) {
            throw new IOException("No edits file for txid " + startTxId + "-" + endTxId + " exists!");
        }
        return ret;
    }

    File findImageFile(long txid) throws IOException {
        return this.findFile(NameNodeDirType.IMAGE, NNStorage.getImageFileName(txid));
    }

    private File findFile(NameNodeDirType dirType, String name) {
        for (Storage.StorageDirectory sd : this.dirIterable(dirType)) {
            File candidate = new File(sd.getCurrentDir(), name);
            if (!sd.getCurrentDir().canRead() || !candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    List<File> getFiles(NameNodeDirType dirType, String fileName) {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            list.add(new File(it.next().getCurrentDir(), fileName));
        }
        return list;
    }

    void setUpgradeManager(UpgradeManager um) {
        this.upgradeManager = um;
    }

    boolean getDistributedUpgradeState() {
        return this.upgradeManager == null ? false : this.upgradeManager.getUpgradeState();
    }

    int getDistributedUpgradeVersion() {
        return this.upgradeManager == null ? 0 : this.upgradeManager.getUpgradeVersion();
    }

    private void setDistributedUpgradeState(boolean uState, int uVersion) {
        if (this.upgradeManager != null) {
            this.upgradeManager.setUpgradeState(uState, uVersion);
        }
    }

    void verifyDistributedUpgradeProgress(HdfsServerConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK || startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            return;
        }
        assert (this.upgradeManager != null) : "FSNameSystem.upgradeManager is null.";
        if (startOpt != HdfsServerConstants.StartupOption.UPGRADE) {
            if (this.upgradeManager.getUpgradeState()) {
                throw new IOException("\n   Previous distributed upgrade was not completed. \n   Please restart NameNode with -upgrade option.");
            }
            if (this.upgradeManager.getDistributedUpgrades() != null) {
                throw new IOException("\n   Distributed upgrade for NameNode version " + this.upgradeManager.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is required.\n   Please restart NameNode" + " with -upgrade option.");
            }
        }
    }

    void initializeDistributedUpgrade() throws IOException {
        if (!this.upgradeManager.initializeUpgrade()) {
            return;
        }
        this.writeAll();
        LOG.info((Object)("\n   Distributed upgrade for NameNode version " + this.upgradeManager.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is initialized."));
    }

    void setDisablePreUpgradableLayoutCheck(boolean val) {
        this.disablePreUpgradableLayoutCheck = val;
    }

    void reportErrorsOnDirectories(List<Storage.StorageDirectory> sds) {
        for (Storage.StorageDirectory sd : sds) {
            this.reportErrorsOnDirectory(sd);
        }
    }

    void reportErrorsOnDirectory(Storage.StorageDirectory sd) {
        LOG.error((Object)("Error reported on storage directory " + sd));
        String lsd = this.listStorageDirectories();
        LOG.debug((Object)("current list of storage dirs:" + lsd));
        LOG.warn((Object)("About to remove corresponding storage: " + sd.getRoot().getAbsolutePath()));
        try {
            sd.unlock();
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unlock bad storage directory: " + sd.getRoot().getPath()), (Throwable)e);
        }
        if (this.storageDirs.remove(sd)) {
            this.removedStorageDirs.add(sd);
        }
        lsd = this.listStorageDirectories();
        LOG.debug((Object)("at the end current list of storage dirs:" + lsd));
    }

    void processStartupOptionsForUpgrade(HdfsServerConstants.StartupOption startOpt, int layoutVersion) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.UPGRADE) {
            if (!LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, layoutVersion)) {
                if (startOpt.getClusterId() == null) {
                    startOpt.setClusterId(NNStorage.newClusterID());
                }
                this.setClusterID(startOpt.getClusterId());
                this.setBlockPoolID(this.newBlockPoolID());
            } else if (startOpt.getClusterId() != null && !startOpt.getClusterId().equals(this.getClusterID())) {
                LOG.warn((Object)("Clusterid mismatch - current clusterid: " + this.getClusterID() + ", Ignoring given clusterid: " + startOpt.getClusterId()));
            }
            LOG.info((Object)("Using clusterid: " + this.getClusterID()));
        }
    }

    void reportErrorOnFile(File f) {
        String absPath = f.getAbsolutePath();
        for (Storage.StorageDirectory sd : this.storageDirs) {
            String dirPath = sd.getRoot().getAbsolutePath();
            if (!dirPath.endsWith("/")) {
                dirPath = dirPath + "/";
            }
            if (!absPath.startsWith(dirPath)) continue;
            this.reportErrorsOnDirectory(sd);
            return;
        }
    }

    public static String newClusterID() {
        return "CID-" + UUID.randomUUID().toString();
    }

    void setClusterID(String cid) {
        this.clusterID = cid;
    }

    public String determineClusterId() {
        String cid = null;
        Iterator<Storage.StorageDirectory> sdit = this.dirIterator(NameNodeDirType.IMAGE);
        while (sdit.hasNext()) {
            Storage.StorageDirectory sd = sdit.next();
            try {
                Properties props = NNStorage.readPropertiesFile(sd.getVersionFile());
                cid = props.getProperty("clusterID");
                LOG.info((Object)("current cluster id for sd=" + sd.getCurrentDir() + ";lv=" + this.layoutVersion + ";cid=" + cid));
                if (cid == null || cid.equals("")) continue;
                return cid;
            }
            catch (Exception e) {
                LOG.warn((Object)("this sd not available: " + e.getLocalizedMessage()));
            }
        }
        LOG.warn((Object)"couldn't find any VERSION file containing valid ClusterId");
        return null;
    }

    String newBlockPoolID() throws UnknownHostException {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP((String)"default");
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Could not find ip address of \"default\" inteface.");
            throw e;
        }
        int rand = DFSUtil.getSecureRandom().nextInt(Integer.MAX_VALUE);
        String bpid = "BP-" + rand + "-" + ip + "-" + System.currentTimeMillis();
        return bpid;
    }

    void setBlockPoolID(String bpid) {
        this.blockpoolID = bpid;
    }

    private void setBlockPoolID(File storage, String bpid) throws InconsistentFSStateException {
        if (bpid == null || bpid.equals("")) {
            throw new InconsistentFSStateException(storage, "file VERSION has no block pool Id.");
        }
        if (!this.blockpoolID.equals("") && !this.blockpoolID.equals(bpid)) {
            throw new InconsistentFSStateException(storage, "Unexepcted blockpoolID " + bpid + " . Expected " + this.blockpoolID);
        }
        this.setBlockPoolID(bpid);
    }

    public String getBlockPoolID() {
        return this.blockpoolID;
    }

    void inspectStorageDirs(FSImageStorageInspector inspector) throws IOException {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            inspector.inspectDirectory(sd);
        }
    }

    FSImageStorageInspector readAndInspectDirs() throws IOException {
        FSImageStorageInspector inspector;
        int minLayoutVersion = Integer.MAX_VALUE;
        int maxLayoutVersion = Integer.MIN_VALUE;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getVersionFile().exists()) {
                FSImage.LOG.warn((Object)("Storage directory " + sd + " contains no VERSION file. Skipping..."));
                continue;
            }
            this.readProperties(sd);
            minLayoutVersion = Math.min(minLayoutVersion, this.getLayoutVersion());
            maxLayoutVersion = Math.max(maxLayoutVersion, this.getLayoutVersion());
        }
        if (minLayoutVersion > maxLayoutVersion) {
            throw new IOException("No storage directories contained VERSION information");
        }
        assert (minLayoutVersion <= maxLayoutVersion);
        if (LayoutVersion.supports(LayoutVersion.Feature.TXID_BASED_LAYOUT, minLayoutVersion)) {
            inspector = new FSImageTransactionalStorageInspector();
            if (!LayoutVersion.supports(LayoutVersion.Feature.TXID_BASED_LAYOUT, maxLayoutVersion)) {
                FSImage.LOG.warn((Object)"Ignoring one or more storage directories with old layouts");
            }
        } else {
            inspector = new FSImagePreTransactionalStorageInspector();
        }
        this.inspectStorageDirs(inspector);
        return inspector;
    }

    static enum NameNodeDirType implements Storage.StorageDirType
    {
        UNDEFINED,
        IMAGE,
        EDITS,
        IMAGE_AND_EDITS;


        @Override
        public Storage.StorageDirType getStorageDirType() {
            return this;
        }

        @Override
        public boolean isOfType(Storage.StorageDirType type) {
            if (this == IMAGE_AND_EDITS && (type == IMAGE || type == EDITS)) {
                return true;
            }
            return this == type;
        }
    }

    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        SEEN_TXID("seen_txid"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new"),
        EDITS_INPROGRESS("edits_inprogress");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

