/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.constant.Constable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.BackupImage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

@Metrics(context="dfs")
@InterfaceAudience.Private
public class FSNamesystem
implements Namesystem,
FSClusterStats,
FSNamesystemMBean,
NameNodeMXBean {
    static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private boolean isPermissionEnabled;
    private UserGroupInformation fsOwner;
    private String fsOwnerShortUserName;
    private String supergroup;
    private PermissionStatus defaultPermission;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private DelegationTokenSecretManager dtSecretManager;
    private boolean alwaysUseDelegationTokensForTests;
    FSDirectory dir;
    private BlockManager blockManager;
    private DatanodeStatistics datanodeStatistics;
    private String blockPoolId;
    LeaseManager leaseManager = new LeaseManager(this);
    Daemon lmthread = null;
    Daemon smmthread = null;
    Daemon nnrmthread = null;
    private volatile boolean hasResourcesAvailable = false;
    private volatile boolean fsRunning = true;
    long systemStart = 0L;
    private long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private FsServerDefaults serverDefaults;
    private boolean supportAppends = true;
    private ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.DEFAULT;
    private volatile SafeModeInfo safeMode;
    private long maxFsObjects = 0L;
    private final GenerationStamp generationStamp = new GenerationStamp();
    private long accessTimePrecision = 0L;
    private ReentrantReadWriteLock fsLock;
    final UpgradeManagerNamenode upgradeManager = new UpgradeManagerNamenode(this);
    private ObjectName mbeanName;

    private HdfsFileStatus getAuditFileInfo(String path, boolean resolveSymlink) throws IOException {
        return auditLog.isInfoEnabled() && FSNamesystem.isExternalInvocation() ? this.dir.getFileInfo(path, resolveSymlink) : null;
    }

    private static void logAuditEvent(String cmd, String src) throws IOException {
        FSNamesystem.logAuditEvent(cmd, src, null, null);
    }

    private static void logAuditEvent(String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (auditLog.isInfoEnabled() && FSNamesystem.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(FSNamesystem.getRemoteUser(), Server.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private static final void logAuditEvent(UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        StringBuilder sb = auditBuffer.get();
        sb.setLength(0);
        sb.append("ugi=").append(ugi).append("\t");
        sb.append("ip=").append(addr).append("\t");
        sb.append("cmd=").append(cmd).append("\t");
        sb.append("src=").append(src).append("\t");
        sb.append("dst=").append(dst).append("\t");
        if (null == stat) {
            sb.append("perm=null");
        } else {
            sb.append("perm=");
            sb.append(stat.getOwner()).append(":");
            sb.append(stat.getGroup()).append(":");
            sb.append(stat.getPermission());
        }
        auditLog.info((Object)sb);
    }

    FSNamesystem(Configuration conf) throws IOException {
        try {
            this.initialize(conf, null);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    private void initialize(Configuration conf, FSImage fsImage) throws IOException {
        this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
        this.nnResourceChecker = new NameNodeResourceChecker(conf);
        this.checkAvailableResources();
        this.systemStart = Util.now();
        this.blockManager = new BlockManager(this, this, conf);
        this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
        this.fsLock = FSNamesystem.createFsLock(conf);
        this.setConfigurationParameters(conf);
        this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
        this.registerMBean();
        if (fsImage == null) {
            this.dir = new FSDirectory(this, conf);
            HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
            this.dir.loadFSImage(startOpt);
            long timeTakenToLoadFSImage = Util.now() - this.systemStart;
            LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
            NameNode.getNameNodeMetrics().setFsImageLoadTime((int)timeTakenToLoadFSImage);
        } else {
            this.dir = new FSDirectory(fsImage, this, conf);
        }
        this.safeMode = new SafeModeInfo(conf);
    }

    private static ReentrantReadWriteLock createFsLock(Configuration conf) {
        boolean fair = conf.getBoolean("dfs.namenode.fslock.fair", true);
        LOG.info((Object)("fsLock is fair:" + fair));
        return new ReentrantReadWriteLock(fair);
    }

    void activateSecretManager() throws IOException {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.startThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(Configuration conf) throws IOException {
        this.writeLock();
        try {
            this.setBlockTotal();
            this.blockManager.activate(conf);
            this.lmthread = new Daemon((Runnable)new LeaseManager.Monitor(this.leaseManager));
            this.lmthread.start();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
        }
        finally {
            this.writeUnlock();
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    private static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        List<String> dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn((Object)("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;" + "\n\t\t- use Backup Node as a persistent and up-to-date storage " + "of the file system meta-data."));
            }
        } else if (dirNames.isEmpty()) {
            dirNames = Collections.singletonList("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs((Collection<String>)dirNames);
    }

    public static Collection<URI> getNamespaceEditsDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir");
    }

    @Override
    public void readLock() {
        this.fsLock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.fsLock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.fsLock.writeLock().lock();
    }

    @Override
    public void writeUnlock() {
        this.fsLock.writeLock().unlock();
    }

    @Override
    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0;
    }

    @Override
    public boolean hasReadOrWriteLock() {
        return this.hasReadLock() || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.fsLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.fsLock.getWriteHoldCount();
    }

    FSNamesystem(FSImage fsImage, Configuration conf) throws IOException {
        this.fsLock = FSNamesystem.createFsLock(conf);
        this.blockManager = new BlockManager(this, this, conf);
        this.setConfigurationParameters(conf);
        this.dir = new FSDirectory(fsImage, this, conf);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
    }

    FSNamesystem(Configuration conf, BackupImage bnImage) throws IOException {
        try {
            this.initialize(conf, bnImage);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    private void setConfigurationParameters(Configuration conf) throws IOException {
        DataChecksum.Type checksumType;
        this.fsOwner = UserGroupInformation.getCurrentUser();
        this.fsOwnerShortUserName = this.fsOwner.getShortUserName();
        LOG.info((Object)("fsOwner=" + this.fsOwner));
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        LOG.info((Object)("supergroup=" + this.supergroup));
        LOG.info((Object)("isPermissionEnabled=" + this.isPermissionEnabled));
        short filePermission = (short)conf.getInt("dfs.namenode.upgrade.permission", 511);
        this.defaultPermission = PermissionStatus.createImmutable((String)this.fsOwner.getShortUserName(), (String)this.supergroup, (FsPermission)new FsPermission(filePermission));
        String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
        try {
            checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
        }
        this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x4000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), checksumType);
        this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
        this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 0L);
        this.supportAppends = conf.getBoolean("dfs.support.append", true);
        this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
    }

    protected PermissionStatus getUpgradePermission() {
        return this.defaultPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = new NamespaceInfo(this.dir.fsImage.getStorage().getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), this.dir.fsImage.getStorage().getCTime(), this.upgradeManager.getUpgradeVersion());
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void close() {
        block23: {
            block22: {
                this.fsRunning = false;
                if (this.blockManager != null) {
                    this.blockManager.close();
                }
                if (this.smmthread != null) {
                    this.smmthread.interrupt();
                }
                if (this.dtSecretManager != null) {
                    this.dtSecretManager.stopThreads();
                }
                if (this.nnrmthread == null) break block22;
                this.nnrmthread.interrupt();
            }
            try {
                if (this.lmthread != null) {
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
                if (this.dir != null) {
                    this.dir.close();
                }
                break block23;
            }
            catch (InterruptedException ie) {
            }
            catch (IOException ie) {
                LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
            }
            break block23;
            catch (Exception e) {
                try {
                    LOG.warn((Object)"Exception shutting down FSNamesystem", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.lmthread != null) {
                            this.lmthread.interrupt();
                            this.lmthread.join(3000L);
                        }
                        if (this.dir != null) {
                            this.dir.close();
                        }
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (IOException ie) {
                        LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                    }
                    throw throwable;
                }
                try {
                    if (this.lmthread != null) {
                        this.lmthread.interrupt();
                        this.lmthread.join(3000L);
                    }
                    if (this.dir != null) {
                        this.dir.close();
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (IOException ie) {
                    LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            long totalInodes = this.dir.totalInodes();
            long totalBlocks = this.getBlocksTotal();
            out.println(totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total");
            this.blockManager.metaSave(out);
            out.flush();
            out.close();
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    long getDefaultBlockSize() {
        return this.serverDefaults.getBlockSize();
    }

    FsServerDefaults getServerDefaults() {
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set permission for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            this.dir.setPermission(src, permission);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        FSNamesystem.logAuditEvent("setPermission", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set owner for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            if (!pc.isSuperUser()) {
                if (username != null && !pc.getUser().equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner");
                }
                if (group != null && !pc.containsGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group);
                }
            }
            this.dir.setOwner(src, username, group);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        FSNamesystem.logAuditEvent("setOwner", src, null, resultingStat);
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks blocks = this.getBlockLocations(src, offset, length, true, true);
        if (blocks != null) {
            this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
        }
        return blocks;
    }

    LocatedBlocks getBlockLocations(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsUpdateTimes(src, offset, length, doAccessTime, needBlockToken);
        FSNamesystem.logAuditEvent("open", src);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlocks getBlockLocationsUpdateTimes(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        for (int attempt = 0; attempt < 2; ++attempt) {
            if (attempt == 0) {
                this.readLock();
            } else {
                this.writeLock();
            }
            try {
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(pc, src, FsAction.READ);
                }
                if (this.isInSafeMode()) {
                    doAccessTime = false;
                }
                long now = Util.now();
                INodeFile inode = this.dir.getFileINode(src);
                if (inode == null) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                assert (!inode.isLink());
                if (doAccessTime && this.isAccessTimeSupported()) {
                    if (now <= inode.getAccessTime() + this.getAccessTimePrecision() && attempt == 0) continue;
                    this.dir.setTimes(src, inode, -1L, now, false);
                }
                LocatedBlocks locatedBlocks = this.blockManager.createLocatedBlocks(inode.getBlocks(), inode.computeFileSize(false), inode.isUnderConstruction(), offset, length, needBlockToken);
                return locatedBlocks;
            }
            finally {
                if (attempt == 0) {
                    this.readUnlock();
                } else {
                    this.writeUnlock();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        if (target.isEmpty()) {
            throw new IllegalArgumentException("Target file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("No sources given");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("Sources and target are not in the same directory");
        }
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot concat " + target, this.safeMode);
            }
            this.concatInternal(pc, target, srcs);
            resultingStat = this.getAuditFileInfo(target, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        FSNamesystem.logAuditEvent("concat", Arrays.toString(srcs), target, resultingStat);
    }

    private void concatInternal(FSPermissionChecker pc, String target, String[] srcs) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, target, FsAction.WRITE);
            for (String aSrc : srcs) {
                this.checkPathAccess(pc, aSrc, FsAction.READ);
                this.checkParentAccess(pc, aSrc, FsAction.WRITE);
            }
        }
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile inode = this.dir.getFileINode(target);
        if (inode == null) {
            throw new IllegalArgumentException("concat: trg file doesn't exist");
        }
        if (inode.isUnderConstruction()) {
            throw new IllegalArgumentException("concat: trg file is uner construction");
        }
        INodeFile trgInode = inode;
        if (trgInode.blocks.length == 0) {
            throw new IllegalArgumentException("concat: " + target + " file is empty");
        }
        long blockSize = trgInode.getPreferredBlockSize();
        if (blockSize != trgInode.blocks[trgInode.blocks.length - 1].getNumBytes()) {
            throw new IllegalArgumentException(target + " blocks size should be the same");
        }
        si.add(trgInode);
        short repl = trgInode.getReplication();
        boolean endSrc = false;
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            if (i == srcs.length - 1) {
                endSrc = true;
            }
            INodeFile srcInode = this.dir.getFileINode(src);
            if (src.isEmpty() || srcInode == null || srcInode.isUnderConstruction() || srcInode.blocks.length == 0) {
                throw new IllegalArgumentException("concat: file " + src + " is invalid or empty or underConstruction");
            }
            if (repl != srcInode.getReplication()) {
                throw new IllegalArgumentException(src + " and " + target + " " + "should have same replication: " + repl + " vs. " + srcInode.getReplication());
            }
            int idx = srcInode.blocks.length - 1;
            if (endSrc) {
                idx = srcInode.blocks.length - 2;
            }
            if (idx >= 0 && srcInode.blocks[idx].getNumBytes() != blockSize) {
                throw new IllegalArgumentException("concat: blocks sizes of " + src + " and " + target + " should all be the same");
            }
            si.add(srcInode);
        }
        if (si.size() < srcs.length + 1) {
            throw new IllegalArgumentException("at least two files are the same");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
        }
        this.dir.concat(target, srcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat;
        block6: {
            if (!this.isAccessTimeSupported() && atime != -1L) {
                throw new IOException("Access time for hdfs is not configured.  Please set dfs.namenode.accesstime.precision configuration parameter.");
            }
            resultingStat = null;
            FSPermissionChecker pc = this.getPermissionChecker();
            this.writeLock();
            try {
                INode inode;
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                if ((inode = this.dir.getINode(src)) != null) {
                    this.dir.setTimes(src, inode, mtime, atime, true);
                    resultingStat = this.getAuditFileInfo(src, false);
                    break block6;
                }
                throw new FileNotFoundException("File/Directory " + src + " does not exist.");
            }
            finally {
                this.writeUnlock();
            }
        }
        FSNamesystem.logAuditEvent("setTimes", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (!createParent) {
                this.verifyParentDir(link);
            }
            this.createSymlinkInternal(pc, target, link, dirPerms, createParent);
            resultingStat = this.getAuditFileInfo(link, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        FSNamesystem.logAuditEvent("createSymlink", link, target, resultingStat);
    }

    private void createSymlinkInternal(FSPermissionChecker pc, String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.createSymlink: target=" + target + " link=" + link));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create symlink " + link, this.safeMode);
        }
        if (!DFSUtil.isValidName(link)) {
            throw new InvalidPathException("Invalid file name: " + link);
        }
        if (!this.dir.isValidToCreate(link)) {
            throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, link, FsAction.WRITE);
        }
        this.checkFsObjectLimit();
        this.dir.addSymlink(link, target, dirPerms, createParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setReplication(String src, short replication) throws IOException {
        boolean isFile;
        this.blockManager.verifyReplication(src, replication, null);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            short[] oldReplication;
            Block[] blocks;
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            boolean bl = isFile = (blocks = this.dir.setReplication(src, replication, oldReplication = new short[1])) != null;
            if (isFile) {
                this.blockManager.setReplication(oldReplication[0], replication, src, blocks);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (isFile) {
            FSNamesystem.logAuditEvent("setReplication", src);
        }
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, filename);
            }
            long l = this.dir.getPreferredBlockSize(filename);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    private void verifyParentDir(String src) throws FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException {
        assert (this.hasReadOrWriteLock());
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode[] pathINodes = this.dir.getExistingPathINodes(parent.toString());
            INode parentNode = pathINodes[pathINodes.length - 1];
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent.toString());
            }
            if (!parentNode.isDirectory() && !parentNode.isLink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.startFileInternal(pc, src, permissions, holder, clientMachine, flag, createParent, replication, blockSize);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
            this.getEditLog().logSync();
        }
        FSNamesystem.logAuditEvent("create", src, null, resultingStat);
    }

    private LocatedBlock startFileInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws SafeModeException, FileAlreadyExistsException, AccessControlException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", createFlag=" + flag.toString()));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create file" + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        boolean pathExists = this.dir.exists(src);
        if (pathExists && this.dir.isDir(src)) {
            throw new FileAlreadyExistsException("Cannot create file " + src + "; already exists as a directory.");
        }
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        boolean append = flag.contains(CreateFlag.APPEND);
        if (this.isPermissionEnabled) {
            if (append || overwrite && pathExists) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(pc, src, FsAction.WRITE);
            }
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        try {
            INodeFile myFile = this.dir.getFileINode(src);
            this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
            try {
                this.blockManager.verifyReplication(src, replication, clientMachine);
            }
            catch (IOException e) {
                throw new IOException("failed to create " + e.getMessage());
            }
            boolean create = flag.contains(CreateFlag.CREATE);
            if (myFile == null) {
                if (!create) {
                    throw new FileNotFoundException("failed to overwrite or append to non-existent file " + src + " on client " + clientMachine);
                }
            } else if (overwrite) {
                this.delete(src, true);
            } else if (!append) {
                throw new FileAlreadyExistsException("failed to create file " + src + " on client " + clientMachine + " because the file exists");
            }
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            if (append && myFile != null) {
                return this.prepareFileForWrite(src, myFile, holder, clientMachine, clientNode, true);
            }
            this.checkFsObjectLimit();
            long genstamp = this.nextGenerationStamp();
            INodeFileUnderConstruction newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode, genstamp);
            if (newNode == null) {
                throw new IOException("DIR* NameSystem.startFile: Unable to add file to namespace.");
            }
            this.leaseManager.addLease(newNode.getClientName(), src);
            this.getEditLog().logOpenFile(src, newNode);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: add " + src + " to namespace for " + holder));
            }
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + ie.getMessage()));
            throw ie;
        }
        return null;
    }

    LocatedBlock prepareFileForWrite(String src, INodeFile file, String leaseHolder, String clientMachine, DatanodeDescriptor clientNode, boolean writeToEditLog) throws IOException {
        INodeFileUnderConstruction cons = new INodeFileUnderConstruction(file.getLocalNameBytes(), file.getReplication(), file.getModificationTime(), file.getPreferredBlockSize(), file.getBlocks(), file.getPermissionStatus(), leaseHolder, clientMachine, clientNode);
        this.dir.replaceNode(src, file, cons);
        this.leaseManager.addLease(cons.getClientName(), src);
        LocatedBlock ret = this.blockManager.convertLastBlockToUnderConstruction(cons);
        if (writeToEditLog) {
            this.getEditLog().logOpenFile(src, cons);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot recover the lease of " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new IOException("Invalid file name: " + src);
            }
            INodeFile inode = this.dir.getFileINode(src);
            if (inode == null) {
                throw new FileNotFoundException("File not found " + src);
            }
            if (!inode.isUnderConstruction()) {
                boolean bl = true;
                return bl;
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
        }
        finally {
            this.writeUnlock();
            this.getEditLog().logSync();
        }
        return false;
    }

    private void recoverLeaseInternal(INode fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        assert (this.hasWriteLock());
        if (fileInode != null && fileInode.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fileInode;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && ((leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease) || lease.getHolder().equals(holder))) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file.");
            }
            lease = this.leaseManager.getLease(pendingFile.getClientName());
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found.");
            }
            if (force) {
                LOG.info((Object)("recoverLease: recover lease " + lease + ", src=" + src + " from client " + pendingFile.getClientName()));
                this.internalReleaseLease(lease, src, holder);
            } else {
                assert (lease.getHolder().equals(pendingFile.getClientName())) : "Current lease holder " + lease.getHolder() + " does not match file creator " + pendingFile.getClientName();
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover lease " + lease + ", src=" + src + " from client " + pendingFile.getClientName()));
                    boolean isClosed = this.internalReleaseLease(lease, src, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException("Failed to close file " + src + ". Lease recovery is in progress. Try again later.");
                    }
                } else {
                    BlockInfoUnderConstruction lastBlock = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException("Recovery in progress, file [" + src + "], " + "lease owner [" + lease.getHolder() + "]");
                    }
                    throw new AlreadyBeingCreatedException("Failed to create file [" + src + "] for [" + holder + "] on client [" + clientMachine + "], because this file is already being created by [" + pendingFile.getClientName() + "] on [" + pendingFile.getClientMachine() + "]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock appendFile(String src, String holder, String clientMachine) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append to hdfs not supported. Please refer to dfs.support.append configuration parameter.");
        }
        LocatedBlock lb = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            lb = this.startFileInternal(pc, src, null, holder, clientMachine, EnumSet.of(CreateFlag.APPEND), false, this.blockManager.maxReplication, 0L);
        }
        finally {
            this.writeUnlock();
            this.getEditLog().logSync();
        }
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        FSNamesystem.logAuditEvent("append", src);
        return lb;
    }

    ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    void setBlockPoolId(String bpid) {
        this.blockPoolId = bpid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalBlock(String src, String clientName, ExtendedBlock previous, HashMap<Node, Node> excludedNodes) throws LeaseExpiredException, NotReplicatedYetException, QuotaExceededException, SafeModeException, UnresolvedLinkException, IOException {
        short replication;
        long blockSize;
        long fileLength;
        this.checkBlock(previous);
        DatanodeDescriptor clientNode = null;
        Block newBlock = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: file " + src + " for " + clientName));
        }
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            this.checkFsObjectLimit();
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            this.commitOrCompleteLastBlock(pendingFile, ExtendedBlock.getLocalBlock(previous));
            fileLength = pendingFile.computeContentSummary().getLength();
            blockSize = pendingFile.getPreferredBlockSize();
            clientNode = pendingFile.getClientNode();
            replication = pendingFile.getReplication();
        }
        finally {
            this.writeUnlock();
        }
        DatanodeInfo[] targets = this.blockManager.chooseTarget(src, replication, clientNode, excludedNodes, blockSize);
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            INode[] pathINodes = this.dir.getExistingPathINodes(src);
            int inodesLen = pathINodes.length;
            this.checkLease(src, clientName, pathINodes[inodesLen - 1]);
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)pathINodes[inodesLen - 1];
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            newBlock = this.allocateBlock(src, pathINodes, (DatanodeDescriptor[])targets);
            for (DatanodeDescriptor datanodeDescriptor : targets) {
                datanodeDescriptor.incBlocksScheduled();
            }
        }
        finally {
            this.writeUnlock();
        }
        LocatedBlock b = new LocatedBlock(this.getExtendedBlock(newBlock), targets, fileLength);
        this.blockManager.setBlockToken(b, BlockTokenSecretManager.AccessMode.WRITE);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, HashMap<Node, Node> excludes, int numAdditionalNodes, String clientName) throws IOException {
        ArrayList<DatanodeDescriptor> chosen;
        long preferredblocksize;
        DatanodeDescriptor clientnode;
        this.dtpReplaceDatanodeOnFailure.checkEnabled();
        this.readLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add datanode; src=" + src + ", blk=" + blk, this.safeMode);
            }
            INodeFileUnderConstruction file = this.checkLease(src, clientName);
            clientnode = file.getClientNode();
            preferredblocksize = file.getPreferredBlockSize();
            chosen = new ArrayList<DatanodeDescriptor>();
            for (DatanodeInfo d : existings) {
                DatanodeDescriptor descriptor = this.blockManager.getDatanodeManager().getDatanode(d);
                if (descriptor == null) continue;
                chosen.add(descriptor);
            }
        }
        finally {
            this.readUnlock();
        }
        DatanodeInfo[] targets = this.blockManager.getBlockPlacementPolicy().chooseTarget(src, numAdditionalNodes, clientnode, chosen, true, excludes, preferredblocksize);
        LocatedBlock lb = new LocatedBlock(blk, targets);
        this.blockManager.setBlockToken(lb, BlockTokenSecretManager.AccessMode.COPY);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean abandonBlock(ExtendedBlock b, String src, String holder) throws LeaseExpiredException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot abandon block " + b + " for fle" + src, this.safeMode);
            }
            INodeFileUnderConstruction file = this.checkLease(src, holder);
            this.dir.removeBlock(src, file, ExtendedBlock.getLocalBlock(b));
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws LeaseExpiredException, UnresolvedLinkException {
        assert (this.hasReadOrWriteLock());
        INodeFile file = this.dir.getFileINode(src);
        this.checkLease(src, holder, file);
        return (INodeFileUnderConstruction)file;
    }

    private void checkLease(String src, String holder, INode file) throws LeaseExpiredException {
        assert (this.hasReadOrWriteLock());
        if (file == null || file.isDirectory()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (holder != null && !pendingFile.getClientName().equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " but is accessed by " + holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeFile(String src, String holder, ExtendedBlock last) throws SafeModeException, UnresolvedLinkException, IOException {
        this.checkBlock(last);
        boolean success = false;
        this.writeLock();
        try {
            success = this.completeFileInternal(src, holder, ExtendedBlock.getLocalBlock(last));
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return success;
    }

    private boolean completeFileInternal(String src, String holder, Block last) throws SafeModeException, UnresolvedLinkException, IOException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete file " + src, this.safeMode);
        }
        INodeFileUnderConstruction pendingFile = this.checkLease(src, holder);
        if (!this.checkFileProgress(pendingFile, false)) {
            return false;
        }
        this.commitOrCompleteLastBlock(pendingFile, last);
        if (!this.checkFileProgress(pendingFile, true)) {
            return false;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info((Object)("DIR* NameSystem.completeFile: file " + src + " is closed by " + holder));
        return true;
    }

    private void checkReplicationFactor(INodeFile file) {
        short numExpectedReplicas = file.getReplication();
        BlockInfo[] pendingBlocks = file.getBlocks();
        int nrBlocks = pendingBlocks.length;
        for (int i = 0; i < nrBlocks; ++i) {
            this.blockManager.checkReplication(pendingBlocks[i], numExpectedReplicas);
        }
    }

    private Block allocateBlock(String src, INode[] inodes, DatanodeDescriptor[] targets) throws QuotaExceededException {
        assert (this.hasWriteLock());
        Block b = new Block(DFSUtil.getRandom().nextLong(), 0L, 0L);
        while (this.isValidBlock(b)) {
            b.setBlockId(DFSUtil.getRandom().nextLong());
        }
        b.setGenerationStamp(this.getGenerationStamp());
        b = this.dir.addBlock(src, inodes, b, targets);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.allocateBlock: " + src + ". " + this.blockPoolId + " " + b));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(INodeFile v, boolean checkall) {
        this.readLock();
        try {
            if (checkall) {
                for (BlockInfo block : v.getBlocks()) {
                    if (block.isComplete()) continue;
                    LOG.info((Object)("BLOCK* NameSystem.checkFileProgress: block " + block + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            } else {
                BlockInfo b = v.getPenultimateBlock();
                if (b != null && !b.isComplete()) {
                    LOG.warn((Object)("BLOCK* NameSystem.checkFileProgress: block " + b + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean renameTo(String src, String dst) throws IOException, UnresolvedLinkException {
        boolean status = false;
        HdfsFileStatus resultingStat = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            status = this.renameToInternal(pc, src, dst);
            if (status) {
                resultingStat = this.getAuditFileInfo(dst, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            FSNamesystem.logAuditEvent("rename", src, dst, resultingStat);
        }
        return status;
    }

    @Deprecated
    private boolean renameToInternal(FSPermissionChecker pc, String src, String dst) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        if (this.isPermissionEnabled) {
            String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
            this.checkParentAccess(pc, src, FsAction.WRITE);
            this.checkAncestorAccess(pc, actualdst, FsAction.WRITE);
        }
        return this.dir.renameTo(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: with options - " + src + " to " + dst));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.renameToInternal(pc, src, dst, options);
            resultingStat = this.getAuditFileInfo(dst, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (resultingStat != null) {
            StringBuilder cmd = new StringBuilder("rename options=");
            for (Options.Rename option : options) {
                cmd.append(option.value()).append(" ");
            }
            FSNamesystem.logAuditEvent(cmd.toString(), src, dst, resultingStat);
        }
    }

    private void renameToInternal(FSPermissionChecker pc, String src, String dst, Options.Rename ... options) throws IOException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        if (this.isPermissionEnabled) {
            this.checkParentAccess(pc, src, FsAction.WRITE);
            this.checkAncestorAccess(pc, dst, FsAction.WRITE);
        }
        this.dir.renameTo(src, dst, options);
    }

    boolean delete(String src, boolean recursive) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        boolean status;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        }
        if (status = this.deleteInternal(src, recursive, true)) {
            FSNamesystem.logAuditEvent("delete", src);
        }
        return status;
    }

    private FSPermissionChecker getPermissionChecker() throws AccessControlException {
        try {
            return new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup, FSNamesystem.getRemoteUser());
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(String src, boolean recursive, boolean enforcePermission) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot delete " + src, this.safeMode);
            }
            if (!recursive && !this.dir.isDirEmpty(src)) {
                throw new IOException(src + " is non empty");
            }
            if (enforcePermission && this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, FsAction.WRITE, null, FsAction.ALL, false);
            }
            if (!this.dir.delete(src, collectedBlocks)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* Namesystem.delete: " + src + " is removed"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlocks(List<Block> blocks) {
        int start = 0;
        int end = 0;
        while (start < blocks.size()) {
            end = BLOCK_DELETION_INCREMENT + start;
            end = end > blocks.size() ? blocks.size() : end;
            this.writeLock();
            try {
                for (int i = start; i < end; ++i) {
                    this.blockManager.removeBlock(blocks.get(i));
                }
            }
            finally {
                this.writeUnlock();
            }
            start = end;
        }
    }

    void removePathAndBlocks(String src, List<Block> blocks) {
        assert (this.hasWriteLock());
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (blocks == null) {
            return;
        }
        for (Block b : blocks) {
            this.blockManager.removeBlock(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            if (!DFSUtil.isValidName(src)) {
                throw new InvalidPathException("Invalid file name: " + src);
            }
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            HdfsFileStatus hdfsFileStatus = this.dir.getFileInfo(src, resolveLink);
            return hdfsFileStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        boolean status = false;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            status = this.mkdirsInternal(pc, src, permissions, createParent);
            if (status) {
                resultingStat = this.getAuditFileInfo(src, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            FSNamesystem.logAuditEvent("mkdirs", src, null, resultingStat);
        }
        return status;
    }

    private boolean mkdirsInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create directory " + src, this.safeMode);
        }
        if (this.isPermissionEnabled) {
            this.checkTraverse(pc, src);
        }
        if (this.dir.isDir(src)) {
            return true;
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, src, FsAction.WRITE);
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(src, permissions, false, Util.now())) {
            throw new IOException("Failed to create directory: " + src);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, FsAction.READ_EXECUTE);
            }
            ContentSummary contentSummary = this.dir.getContentSummary(src);
            return contentSummary;
        }
        finally {
            this.readUnlock();
            FSNamesystem.logAuditEvent("contentSummary", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String path, long nsQuota, long dsQuota) throws IOException, UnresolvedLinkException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set quota on " + path, this.safeMode);
            }
            this.dir.setQuota(path, nsQuota, dsQuota);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName) throws IOException, UnresolvedLinkException {
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.fsync: file " + src + " for " + clientName));
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot fsync file " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            this.dir.persistBlocks(src, pendingFile);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, String recoveryLeaseHolder) throws AlreadyBeingCreatedException, IOException, UnresolvedLinkException {
        boolean penultimateBlockMinReplication;
        HdfsServerConstants.BlockUCState penultimateBlockState;
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering lease=" + lease + ", src=" + src));
        assert (!this.isInSafeMode());
        assert (this.hasWriteLock());
        INodeFile iFile = this.dir.getFileINode(src);
        if (iFile == null) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " file does not exist.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        if (!iFile.isUnderConstruction()) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        BlockInfoUnderConstruction lastBlock = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        if (penultimateBlock == null) {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMPLETE;
            penultimateBlockMinReplication = true;
        } else {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMMITTED;
            penultimateBlockMinReplication = this.blockManager.checkMinReplication(penultimateBlock);
        }
        assert (penultimateBlockState == HdfsServerConstants.BlockUCState.COMPLETE || penultimateBlockState == HdfsServerConstants.BlockUCState.COMMITTED) : "Unexpected state of penultimate block in " + src;
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated." + " Try again later.";
                NameNode.stateChangeLog.warn((Object)message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                if (lastBlock.getNumExpectedLocations() == 0) {
                    lastBlock.setExpectedLocations(this.blockManager.getNodes(lastBlock));
                }
                long blockRecoveryId = this.nextGenerationStamp();
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                lastBlock.initializeBlockRecovery(blockRecoveryId);
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed." + " Lease recovery is in progress. " + "RecoveryId = " + blockRecoveryId + " for block " + lastBlock));
            }
        }
        return false;
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) throws IOException {
        assert (this.hasWriteLock());
        if (newHolder == null) {
            return lease;
        }
        this.logReassignLease(lease.getHolder(), src, newHolder);
        return this.reassignLeaseInternal(lease, src, newHolder, pendingFile);
    }

    LeaseManager.Lease reassignLeaseInternal(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) throws IOException {
        assert (this.hasWriteLock());
        pendingFile.setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void commitOrCompleteLastBlock(INodeFileUnderConstruction fileINode, Block commitBlock) throws IOException {
        assert (this.hasWriteLock());
        if (!this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock)) {
            return;
        }
        long diff = fileINode.getPreferredBlockSize() - commitBlock.getNumBytes();
        if (diff > 0L) {
            try {
                String path = this.leaseManager.findPath(fileINode);
                this.dir.updateSpaceConsumed(path, 0L, -diff * (long)fileINode.getReplication());
            }
            catch (IOException e) {
                LOG.warn((Object)"Unexpected exception while updating disk space.", (Throwable)e);
            }
        }
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        this.leaseManager.removeLease(pendingFile.getClientName(), src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.checkReplicationFactor(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(ExtendedBlock lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException, UnresolvedLinkException {
        String src = "";
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot commitBlockSynchronization while in safe mode", this.safeMode);
            }
            LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")"));
            BlockInfo storedBlock = this.blockManager.getStoredBlock(ExtendedBlock.getLocalBlock(lastblock));
            if (storedBlock == null) {
                throw new IOException("Block (=" + lastblock + ") not found");
            }
            INodeFile iFile = storedBlock.getINode();
            if (!iFile.isUnderConstruction() || storedBlock.isComplete()) {
                throw new IOException("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
            }
            long recoveryId = ((BlockInfoUnderConstruction)storedBlock).getBlockRecoveryId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + lastblock);
            }
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
            if (deleteblock) {
                pendingFile.removeLastBlock(ExtendedBlock.getLocalBlock(lastblock));
                this.blockManager.removeBlockFromMap(storedBlock);
            } else {
                int i;
                storedBlock.setGenerationStamp(newgenerationstamp);
                storedBlock.setNumBytes(newlength);
                DatanodeDescriptor[] descriptors = null;
                if (newtargets.length > 0) {
                    descriptors = new DatanodeDescriptor[newtargets.length];
                    for (i = 0; i < newtargets.length; ++i) {
                        descriptors[i] = this.blockManager.getDatanodeManager().getDatanode(newtargets[i]);
                    }
                }
                if (closeFile) {
                    for (i = 0; i < descriptors.length; ++i) {
                        descriptors[i].addBlock(storedBlock);
                    }
                }
                pendingFile.setLastBlock(storedBlock, descriptors);
            }
            src = this.leaseManager.findPath(pendingFile);
            if (closeFile) {
                this.commitOrCompleteLastBlock(pendingFile, storedBlock);
                this.finalizeINodeFileUnderConstruction(src, pendingFile);
            } else if (this.supportAppends) {
                this.dir.persistBlocks(src, pendingFile);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (closeFile) {
            LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", file=" + src + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
        } else {
            LOG.info((Object)("commitBlockSynchronization(" + lastblock + ") successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewLease(String holder) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
            }
            this.leaseManager.renewLease(holder);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        DirectoryListing dl;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            if (this.isPermissionEnabled) {
                if (this.dir.isDir(src)) {
                    this.checkPathAccess(pc, src, FsAction.READ_EXECUTE);
                } else {
                    this.checkTraverse(pc, src);
                }
            }
            FSNamesystem.logAuditEvent("listStatus", src);
            dl = this.dir.getListing(src, startAfter, needLocation);
        }
        finally {
            this.readUnlock();
        }
        return dl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
            this.checkSafeMode();
        }
        finally {
            this.writeUnlock();
        }
    }

    String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage.getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeCommand[] handleHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, long blockPoolUsed, int xceiverCount, int xmitsInProgress, int failedVolumes) throws IOException {
        this.readLock();
        try {
            int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
            DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, this.blockPoolId, capacity, dfsUsed, remaining, blockPoolUsed, xceiverCount, maxTransfer, failedVolumes);
            if (cmds != null) {
                DatanodeCommand[] datanodeCommandArray = cmds;
                return datanodeCommandArray;
            }
            UpgradeCommand cmd = this.upgradeManager.getBroadcastCommand();
            if (cmd != null) {
                DatanodeCommand[] datanodeCommandArray = new DatanodeCommand[]{cmd};
                return datanodeCommandArray;
            }
            DatanodeCommand[] datanodeCommandArray = null;
            return datanodeCommandArray;
        }
        finally {
            this.readUnlock();
        }
    }

    private boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    private void checkAvailableResources() throws IOException {
        this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableDiskSpace();
    }

    FSImage getFSImage() {
        return this.dir.fsImage;
    }

    FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    private void checkBlock(ExtendedBlock block) throws IOException {
        if (block != null && !this.blockPoolId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + this.blockPoolId);
        }
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    @Metric(value={"TransactionsSinceLastCheckpoint", "Number of transactions since last checkpoint"})
    public long getTransactionsSinceLastCheckpoint() {
        return this.getEditLog().getLastWrittenTxId() - this.getFSImage().getStorage().getMostRecentCheckpointTxId();
    }

    @Metric(value={"TransactionsSinceLastLogRoll", "Number of transactions since last edit log roll"})
    public long getTransactionsSinceLastLogRoll() {
        return this.getEditLog().getLastWrittenTxId() - this.getEditLog().getCurSegmentTxId() + 1L;
    }

    @Metric(value={"LastWrittenTransactionId", "Transaction ID written to the edit log"})
    public long getLastWrittenTransactionId() {
        return this.getEditLog().getLastWrittenTxId();
    }

    @Metric(value={"LastCheckpointTime", "Time in milliseconds since the epoch of the last checkpoint"})
    public long getLastCheckpointTime() {
        return this.getFSImage().getStorage().getMostRecentCheckpointTime();
    }

    long[] getStats() {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        return stats;
    }

    @Override
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        this.readLock();
        try {
            int n = this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            DatanodeInfo[] datanodeInfoArray = arr;
            return datanodeInfoArray;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNamespace() throws AccessControlException, IOException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            this.getFSImage().saveNamespace();
            LOG.info((Object)"New namespace image has been created.");
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws AccessControlException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            if (arg.equals("check")) {
                boolean bl = this.getFSImage().getStorage().getRestoreFailedStorage();
                return bl;
            }
            boolean val = arg.equals("true");
            this.getFSImage().getStorage().setRestoreFailedStorage(val);
            boolean bl = val;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    Date getStartTime() {
        return new Date(this.systemStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            this.getFSImage().finalizeUpgrade();
        }
        finally {
            this.writeUnlock();
        }
    }

    void refreshNodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode(false);
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return safeMode.isOn();
    }

    @Override
    public boolean isInStartupSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow() && safeMode.isOn();
    }

    @Override
    public boolean isPopulatingReplQueues() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return true;
        }
        return safeMode.isPopulatingReplQueues();
    }

    @Override
    public void incrementSafeBlockCount(int replication) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication);
    }

    @Override
    public void decrementSafeBlockCount(Block b) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.decrementSafeBlockCount((short)this.blockManager.countNodes(b).liveReplicas());
    }

    private void setBlockTotal() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal((int)this.getCompleteBlocksTotal());
    }

    @Override
    @Metric
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        this.readLock();
        try {
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                for (String path : lease.getPaths()) {
                    INodeFile node;
                    try {
                        node = this.dir.getFileINode(path);
                    }
                    catch (UnresolvedLinkException e) {
                        throw new AssertionError((Object)"Lease files should reside on this FS");
                    }
                    assert (node != null) : "Found a lease for nonexisting file.";
                    assert (node.isUnderConstruction()) : "Found a lease for file that is not under construction.";
                    INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                    BlockInfo[] blocks = cons.getBlocks();
                    if (blocks == null) continue;
                    for (BlockInfo b : blocks) {
                        if (b.isComplete()) continue;
                        ++numUCBlocks;
                    }
                }
            }
            LOG.info((Object)("Number of blocks under construction: " + numUCBlocks));
            long l = this.getBlocksTotal() - numUCBlocks;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logSyncAll();
            if (!this.isInSafeMode()) {
                this.safeMode = new SafeModeInfo(resourcesLow, this.isPopulatingReplQueues());
                return;
            }
            if (resourcesLow) {
                this.safeMode.setResourcesLow();
            } else {
                this.safeMode.setManual();
            }
            this.getEditLog().logSyncAll();
            NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON. " + this.safeMode.getTurnOffTip()));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveSafeMode(boolean checkForUpgrades) throws SafeModeException {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF.");
                return;
            }
            if (this.upgradeManager.getUpgradeState()) {
                throw new SafeModeException("Distributed upgrade is in progress", this.safeMode);
            }
            this.safeMode.leave(checkForUpgrades);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSafeModeTip() {
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                String string = "";
                return string;
            }
            String string = this.safeMode.getTurnOffTip();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CheckpointSignature rollEditLog() throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Log not rolled", this.safeMode);
            }
            LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
            CheckpointSignature checkpointSignature = this.getFSImage().rollEditLog();
            return checkpointSignature;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not started", this.safeMode);
            }
            LOG.info((Object)("Start checkpoint for " + bnReg.getAddress()));
            NamenodeCommand cmd = this.getFSImage().startCheckpoint(bnReg, nnReg);
            this.getEditLog().logSync();
            NamenodeCommand namenodeCommand = cmd;
            return namenodeCommand;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.readLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not ended", this.safeMode);
            }
            LOG.info((Object)("End checkpoint for " + registration.getAddress()));
            this.getFSImage().endCheckpoint(sig);
        }
        finally {
            this.readUnlock();
        }
    }

    private boolean isValidBlock(Block b) {
        return this.blockManager.getINode(b) != null;
    }

    UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        return this.upgradeManager.distributedUpgradeProgress(action);
    }

    UpgradeCommand processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.upgradeManager.processUpgradeCommand(comm);
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    private void checkOwner(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    private void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    private void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    private void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    private void checkTraverse(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        if (!pc.isSuperUser()) {
            this.dir.waitForReady();
            this.readLock();
            try {
                pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, resolveLink);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    long getMaxObjects() {
        return this.maxFsObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Metric
    public long getFilesTotal() {
        this.readLock();
        try {
            long l = this.dir.totalInodes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Metric
    public long getPendingDeletionBlocks() {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Metric
    public long getExcessBlocks() {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info((Object)"Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
    }

    @Override
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    void setGenerationStamp(long stamp) {
        this.generationStamp.setStamp(stamp);
    }

    long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    private long nextGenerationStamp() throws SafeModeException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get next generation stamp", this.safeMode);
        }
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    private INodeFileUnderConstruction checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get a new generation stamp and an access token for block " + block, this.safeMode);
        }
        BlockInfo storedBlock = this.blockManager.getStoredBlock(ExtendedBlock.getLocalBlock(block));
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + storedBlock);
        }
        INodeFile file = storedBlock.getINode();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + storedBlock + " belonged to does not exist or it is not under construction.");
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (clientName == null || !clientName.equals(pendingFile.getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return pendingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.writeLock();
        try {
            this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp());
            locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
            this.blockManager.setBlockToken(locatedBlock, BlockTokenSecretManager.AccessMode.WRITE);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Pipeline not updated", this.safeMode);
            }
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            LOG.info((Object)("updatePipeline(block=" + oldBlock + ", newGenerationStamp=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", clientName=" + clientName + ")"));
            this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes);
        }
        finally {
            this.writeUnlock();
        }
        if (this.supportAppends) {
            this.getEditLog().logSync();
        }
        LOG.info((Object)("updatePipeline(" + oldBlock + ") successfully to " + newBlock));
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        assert (this.hasWriteLock());
        INodeFileUnderConstruction pendingFile = this.checkUCBlock(oldBlock, clientName);
        BlockInfoUnderConstruction blockinfo = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        if (newBlock.getGenerationStamp() <= blockinfo.getGenerationStamp() || newBlock.getNumBytes() < blockinfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockinfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        blockinfo.setNumBytes(newBlock.getNumBytes());
        blockinfo.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp());
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        DatanodeDescriptor[] descriptors = null;
        if (newNodes.length > 0) {
            descriptors = new DatanodeDescriptor[newNodes.length];
            for (int i = 0; i < newNodes.length; ++i) {
                descriptors[i] = dm.getDatanode(newNodes[i]);
            }
        }
        blockinfo.setExpectedLocations(descriptors);
        String src = this.leaseManager.findPath(pendingFile);
        if (this.supportAppends) {
            this.dir.persistBlocks(src, pendingFile);
        }
    }

    void unprotectedChangeLease(String src, String dst) {
        assert (this.hasWriteLock());
        this.leaseManager.changeLease(src, dst);
    }

    private boolean isRoot(Path path) {
        return path.getParent() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFilesUnderConstruction(DataOutputStream out) throws IOException {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            Map<String, INodeFileUnderConstruction> nodes = this.leaseManager.getINodesUnderConstruction();
            out.writeInt(nodes.size());
            for (Map.Entry<String, INodeFileUnderConstruction> entry : nodes.entrySet()) {
                FSImageSerialization.writeINodeUnderConstruction(out, entry.getValue(), entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerBackupNode(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != bnReg.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)bnReg.getRole()) + " node namespaceID = " + bnReg.getNamespaceID());
            }
            if (bnReg.getRole() == HdfsServerConstants.NamenodeRole.BACKUP) {
                this.getFSImage().getEditLog().registerBackupNode(bnReg, nnReg);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            if (!this.isPopulatingReplQueues()) {
                throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
            }
            int count = 0;
            ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
            Iterator<Block> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            if (cookieTab == null) {
                cookieTab = new String[]{null};
            }
            int skip = FSNamesystem.getIntCookie(cookieTab[0]);
            for (int i = 0; i < skip && blkIterator.hasNext(); ++i) {
                blkIterator.next();
            }
            while (blkIterator.hasNext()) {
                String src;
                Block blk = blkIterator.next();
                INodeFile inode = this.blockManager.getINode(blk);
                ++skip;
                if (inode == null || this.blockManager.countNodes(blk).liveReplicas() != 0 || !(src = FSDirectory.getFullPathName(inode)).startsWith(path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < 100) continue;
                break;
            }
            cookieTab[0] = String.valueOf(skip);
            LOG.info((Object)("list corrupt file blocks returned: " + count));
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token;
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot issue delegation token", this.safeMode);
            }
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn((Object)"trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = FSNamesystem.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
            long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
            this.getEditLog().logGetDelegationToken(dtId, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        long expiryTime;
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew delegation token", this.safeMode);
            }
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
            }
            String renewer = FSNamesystem.getRemoteUser().getShortUserName();
            expiryTime = this.dtSecretManager.renewToken(token, renewer);
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot cancel delegation token", this.safeMode);
            }
            String canceller = FSNamesystem.getRemoteUser().getUserName();
            DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
            this.getEditLog().logCancelDelegationToken(id);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    void saveSecretManagerState(DataOutputStream out) throws IOException {
        this.dtSecretManager.saveSecretManagerState(out);
    }

    void loadSecretManagerState(DataInputStream in) throws IOException {
        this.dtSecretManager.loadSecretManagerState(in);
    }

    public void logUpdateMasterKey(DelegationKey key) throws IOException {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logUpdateMasterKey(key);
        this.getEditLog().logSync();
    }

    public void logExpireDelegationToken(DelegationTokenIdentifier id) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logCancelDelegationToken(id);
    }

    private void logReassignLease(String leaseHolder, String src, String newHolder) throws IOException {
        assert (this.hasWriteLock());
        this.getEditLog().logReassignLease(leaseHolder, src, newHolder);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private static boolean isExternalInvocation() {
        return Server.isRpcInvocation();
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON." + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getMissingBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        for (DatanodeDescriptor node : live) {
            HashMap<String, Object> innerinfo = new HashMap<String, Object>();
            innerinfo.put("lastContact", this.getLastContact(node));
            innerinfo.put("usedSpace", this.getDfsUsed(node));
            innerinfo.put("adminState", node.getAdminState().toString());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, true);
        for (DatanodeDescriptor node : dead) {
            HashMap<String, Constable> innerinfo = new HashMap<String, Constable>();
            innerinfo.put("lastContact", Long.valueOf(this.getLastContact(node)));
            innerinfo.put("decommissioned", Boolean.valueOf(node.isDecommissioned()));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap info = new HashMap();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            HashMap<String, Integer> innerinfo = new HashMap<String, Integer>();
            innerinfo.put("underReplicatedBlocks", node.decommissioningStatus.getUnderReplicatedBlocks());
            innerinfo.put("decommissionOnlyReplicas", node.decommissioningStatus.getDecommissionOnlyReplicas());
            innerinfo.put("underReplicateInOpenFiles", node.decommissioningStatus.getUnderReplicatedInOpenFiles());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (System.currentTimeMillis() - alivenode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        return this.dir.fsImage.getStorage().getClusterID();
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getStorage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken {
        this.getDelegationTokenSecretManager().verifyToken(identifier, password);
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() {
        return this.safeMode;
    }

    @VisibleForTesting
    void setFsLockForTests(ReentrantReadWriteLock lock) {
        this.fsLock = lock;
    }

    @VisibleForTesting
    ReentrantReadWriteLock getFsLockForTests() {
        return this.fsLock;
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (!FSNamesystem.this.fsRunning) {
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread. ");
            } else {
                try {
                    FSNamesystem.this.leaveSafeMode(true);
                }
                catch (SafeModeException es) {
                    String msg = "SafeModeMonitor may not run during distributed upgrade.";
                    assert (false) : msg;
                    throw new RuntimeException(msg, es);
                }
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private double replQueueThreshold;
        private long reached = -1L;
        int blockTotal;
        int blockSafe;
        private int blockThreshold;
        private int blockReplQueueThreshold;
        private long lastStatusReport = 0L;
        boolean initializedReplQueues = false;
        private boolean resourcesLow = false;

        private SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            this.replQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private SafeModeInfo(boolean resourcesLow, boolean isReplQueuesInited) {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replQueueThreshold = 1.5;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.resourcesLow = resourcesLow;
            this.initializedReplQueues = isReplQueuesInited;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match.";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException((Throwable)e));
            }
            return this.reached >= 0L;
        }

        private synchronized boolean isPopulatingReplQueues() {
            return this.initializedReplQueues;
        }

        private void enter() {
            this.reached = 0L;
        }

        private synchronized void leave(boolean checkForUpgrades) {
            if (checkForUpgrades) {
                boolean needUpgrade = false;
                try {
                    needUpgrade = FSNamesystem.this.upgradeManager.startUpgrade();
                }
                catch (IOException e) {
                    LOG.error((Object)"IOException in startDistributedUpgradeIfNeeded", (Throwable)e);
                }
                if (needUpgrade) {
                    FSNamesystem.this.safeMode = new SafeModeInfo(false, this.isPopulatingReplQueues());
                    return;
                }
            }
            if (!this.isPopulatingReplQueues()) {
                this.initializeReplQueues();
            }
            long timeInSafemode = Util.now() - FSNamesystem.this.systemStart;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs."));
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF.");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks"));
        }

        private synchronized void initializeReplQueues() {
            LOG.info((Object)"initializing replication queues");
            assert (!this.isPopulatingReplQueues()) : "Already initialized repl queues";
            long startTimeMisReplicatedScan = Util.now();
            FSNamesystem.this.blockManager.processMisReplicatedBlocks();
            this.initializedReplQueues = true;
            NameNode.stateChangeLog.info((Object)("STATE* Replication Queue initialization scan for invalid, over- and under-replicated blocks completed in " + (Util.now() - startTimeMisReplicatedScan) + " msec"));
        }

        private synchronized boolean canInitializeReplQueues() {
            return this.blockSafe >= this.blockReplQueueThreshold;
        }

        private synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (Util.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return false;
            }
            return !this.needEnter();
        }

        private boolean needEnter() {
            return this.threshold != 0.0 && this.blockSafe < this.blockThreshold || this.datanodeThreshold != 0 && FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                if (this.canInitializeReplQueues() && !this.isPopulatingReplQueues()) {
                    this.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(true);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = Util.now();
            FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered.", true);
            if (this.canInitializeReplQueues() && !this.isPopulatingReplQueues()) {
                this.initializeReplQueues();
            }
        }

        private synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.blockThreshold = (int)((double)this.blockTotal * this.threshold);
            this.blockReplQueueThreshold = (int)((double)this.blockTotal * this.replQueueThreshold);
            this.checkMode();
        }

        private synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        private synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() {
            if (this.reached < 0L) {
                return "Safe mode is OFF.";
            }
            String leaveMsg = "";
            leaveMsg = this.areResourcesLow() ? "Resources are low on NN. Safe mode must be turned off manually" : "Safe mode will be turned off automatically";
            if (this.isManual() && !this.areResourcesLow()) {
                if (FSNamesystem.this.upgradeManager.getUpgradeState()) {
                    return leaveMsg + " upon completion of " + "the distributed upgrade: upgrade progress = " + FSNamesystem.this.upgradeManager.getUpgradeStatus() + "%";
                }
                leaveMsg = "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off";
            }
            if (this.blockTotal < 0) {
                return leaveMsg + ".";
            }
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            if (this.reached == 0L) {
                if (this.blockSafe < this.blockThreshold) {
                    msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.", this.blockSafe, this.blockThreshold - this.blockSafe + 1, this.threshold, this.blockTotal);
                }
                if (numLive < this.datanodeThreshold) {
                    if (!"".equals(msg)) {
                        msg = msg + "\n";
                    }
                    msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            } else {
                msg = String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d.", this.blockSafe, this.threshold, this.blockTotal);
                if (this.datanodeThreshold > 0) {
                    msg = msg + String.format(" The number of live datanodes %d has reached the minimum number %d.", numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            }
            if (this.reached == 0L || this.isManual() && !this.areResourcesLow()) {
                return msg + ".";
            }
            return msg + " in " + Math.abs(this.reached + (long)this.extension - Util.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = Util.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe blocks = " + this.blockSafe + ". Target blocks = " + this.blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        private boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn((Object)(lowResourcesMsg + "Entering safe mode."));
                        } else {
                            LOG.warn((Object)(lowResourcesMsg + "Already in safe mode."));
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }
    }
}

