/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.UpgradeManager;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.common.Upgradeable;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.UpgradeObjectNamenode;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;

class UpgradeManagerNamenode
extends UpgradeManager {
    private final FSNamesystem namesystem;

    @Override
    public HdfsServerConstants.NodeType getType() {
        return HdfsServerConstants.NodeType.NAME_NODE;
    }

    UpgradeManagerNamenode(FSNamesystem namesystem) {
        this.namesystem = namesystem;
    }

    @Override
    public synchronized boolean startUpgrade() throws IOException {
        if (!this.upgradeState) {
            this.initializeUpgrade();
            if (!this.upgradeState) {
                return false;
            }
            this.namesystem.getFSImage().getStorage().writeAll();
        }
        assert (this.currentUpgrades != null) : "currentUpgrades is null";
        this.broadcastCommand = ((Upgradeable)this.currentUpgrades.first()).startUpgrade();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is started."));
        return true;
    }

    synchronized UpgradeCommand processUpgradeCommand(UpgradeCommand command) throws IOException {
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug((Object)("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is processing upgrade command: " + command.getAction() + " status = " + this.getUpgradeStatus() + "%"));
        }
        if (this.currentUpgrades == null) {
            NameNode.LOG.info((Object)("Ignoring upgrade command: " + command.getAction() + " version " + command.getVersion() + ". No distributed upgrades are currently running on the NameNode"));
            return null;
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        if (command.getVersion() != curUO.getVersion()) {
            throw new IncorrectVersionException(command.getVersion(), "UpgradeCommand", curUO.getVersion());
        }
        UpgradeCommand reply = curUO.processUpgradeCommand(command);
        if (curUO.getUpgradeStatus() < 100) {
            return reply;
        }
        curUO.completeUpgrade();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + curUO.getVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " is complete."));
        this.currentUpgrades.remove(curUO);
        if (this.currentUpgrades.isEmpty()) {
            this.completeUpgrade();
        } else {
            curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
            this.broadcastCommand = curUO.startUpgrade();
        }
        return reply;
    }

    @Override
    public synchronized void completeUpgrade() throws IOException {
        this.setUpgradeState(false, HdfsConstants.LAYOUT_VERSION);
        this.namesystem.getFSImage().getStorage().writeAll();
        this.currentUpgrades = null;
        this.broadcastCommand = null;
        this.namesystem.leaveSafeMode(false);
    }

    synchronized UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        boolean isFinalized = false;
        if (this.currentUpgrades == null) {
            FSImage fsimage = this.namesystem.getFSImage();
            isFinalized = fsimage.isUpgradeFinalized();
            if (isFinalized) {
                return null;
            }
            return new UpgradeStatusReport(fsimage.getStorage().getLayoutVersion(), 101, isFinalized);
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        boolean details = false;
        switch (action) {
            case GET_STATUS: {
                break;
            }
            case DETAILED_STATUS: {
                details = true;
                break;
            }
            case FORCE_PROCEED: {
                curUO.forceProceed();
            }
        }
        return curUO.getUpgradeStatusReport(details);
    }
}

