/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockCommand
extends DatanodeCommand {
    public static final long NO_ACK = Long.MAX_VALUE;
    String poolId;
    Block[] blocks;
    DatanodeInfo[][] targets;
    private static final DatanodeInfo[][] EMPTY_TARGET = new DatanodeInfo[0][];

    public BlockCommand() {
    }

    public BlockCommand(int action, String poolId, List<DatanodeDescriptor.BlockTargetPair> blocktargetlist) {
        super(action);
        this.poolId = poolId;
        this.blocks = new Block[blocktargetlist.size()];
        this.targets = new DatanodeInfo[this.blocks.length][];
        for (int i = 0; i < this.blocks.length; ++i) {
            DatanodeDescriptor.BlockTargetPair p = blocktargetlist.get(i);
            this.blocks[i] = p.block;
            this.targets[i] = p.targets;
        }
    }

    public BlockCommand(int action, String poolId, Block[] blocks) {
        super(action);
        this.poolId = poolId;
        this.blocks = blocks;
        this.targets = EMPTY_TARGET;
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public DatanodeInfo[][] getTargets() {
        return this.targets;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.poolId);
        out.writeInt(this.blocks.length);
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(out);
        }
        out.writeInt(this.targets.length);
        for (i = 0; i < this.targets.length; ++i) {
            out.writeInt(this.targets[i].length);
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j].write(out);
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.poolId = Text.readString((DataInput)in);
        this.blocks = new Block[in.readInt()];
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Block();
            this.blocks[i].readFields(in);
        }
        this.targets = new DatanodeInfo[in.readInt()][];
        for (i = 0; i < this.targets.length; ++i) {
            this.targets[i] = new DatanodeInfo[in.readInt()];
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j] = new DatanodeInfo();
                this.targets[i][j].readFields(in);
            }
        }
    }

    static {
        WritableFactories.setFactory(BlockCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new BlockCommand();
            }
        });
    }
}

