/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;

abstract class EditLogOutputStream
implements JournalStream {
    private long numSync = 0L;
    private long totalTimeSync = 0L;

    EditLogOutputStream() throws IOException {
    }

    abstract void write(FSEditLogOp var1) throws IOException;

    abstract void writeRaw(byte[] var1, int var2, int var3) throws IOException;

    abstract void create() throws IOException;

    public abstract void close() throws IOException;

    public abstract void abort() throws IOException;

    abstract void setReadyToFlush() throws IOException;

    protected abstract void flushAndSync() throws IOException;

    public void flush() throws IOException {
        ++this.numSync;
        long start = Util.now();
        this.flushAndSync();
        long end = Util.now();
        this.totalTimeSync += end - start;
    }

    abstract long length() throws IOException;

    public boolean shouldForceSync() {
        return false;
    }

    long getTotalSyncTime() {
        return this.totalTimeSync;
    }

    long getNumSync() {
        return this.numSync;
    }

    public String toString() {
        return this.getName();
    }
}

