/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Krb5AndCertsSslSocketConnector;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class SecondaryNameNode
implements Runnable {
    public static final Log LOG;
    private final long starttime = System.currentTimeMillis();
    private volatile long lastCheckpointTime = 0L;
    private String fsName;
    private CheckpointStorage checkpointImage;
    private NamenodeProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private volatile boolean shouldRun;
    private HttpServer infoServer;
    private int infoPort;
    private int imagePort;
    private String infoBindAddress;
    private Collection<URI> checkpointDirs;
    private Collection<URI> checkpointEditsDirs;
    private long checkpointPeriod;
    private long checkpointCheckPeriod;
    private long checkpointTxnCount;
    private int maxRetries;

    public String toString() {
        return this.getClass().getSimpleName() + " Status" + "\nName Node Address    : " + this.nameNodeAddr + "\nStart Time           : " + new Date(this.starttime) + "\nLast Checkpoint Time : " + (this.lastCheckpointTime == 0L ? "--" : new Date(this.lastCheckpointTime)) + "\nCheckpoint Period    : " + this.checkpointPeriod + " seconds" + "\nCheckpoint Size      : " + StringUtils.byteDesc((long)this.checkpointTxnCount) + " (= " + this.checkpointTxnCount + " bytes)" + "\nCheckpoint Dirs      : " + this.checkpointDirs + "\nCheckpoint Edits Dirs: " + this.checkpointEditsDirs;
    }

    @VisibleForTesting
    FSImage getFSImage() {
        return this.checkpointImage;
    }

    @VisibleForTesting
    int getMergeErrorCount() {
        return this.checkpointImage.getMergeErrorCount();
    }

    @VisibleForTesting
    void setFSImage(CheckpointStorage image) {
        this.checkpointImage = image;
    }

    @VisibleForTesting
    NamenodeProtocol getNameNode() {
        return this.namenode;
    }

    @VisibleForTesting
    void setNameNode(NamenodeProtocol namenode) {
        this.namenode = namenode;
    }

    @VisibleForTesting
    List<URI> getCheckpointDirs() {
        return ImmutableList.copyOf(this.checkpointDirs);
    }

    public SecondaryNameNode(Configuration conf) throws IOException {
        this(conf, new CommandLineOpts());
    }

    public SecondaryNameNode(Configuration conf, CommandLineOpts commandLineOpts) throws IOException {
        try {
            NameNode.initializeGenericKeys(conf, DFSUtil.getSecondaryNameServiceId(conf));
            this.initialize(conf, commandLineOpts);
        }
        catch (IOException e) {
            this.shutdown();
            LOG.fatal((Object)"Failed to start secondary namenode. ", (Throwable)e);
            throw e;
        }
        catch (HadoopIllegalArgumentException e) {
            this.shutdown();
            LOG.fatal((Object)"Failed to start secondary namenode. ", (Throwable)e);
            throw e;
        }
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.namenode.secondary.http-address", "0.0.0.0:50090"));
    }

    private void initialize(final Configuration conf, CommandLineOpts commandLineOpts) throws IOException {
        final InetSocketAddress infoSocAddr = SecondaryNameNode.getHttpAddress(conf);
        this.infoBindAddress = infoSocAddr.getHostName();
        UserGroupInformation.setConfiguration((Configuration)conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            SecurityUtil.login((Configuration)conf, (String)"dfs.secondary.namenode.keytab.file", (String)"dfs.secondary.namenode.kerberos.principal", (String)this.infoBindAddress);
        }
        JvmMetrics.create((String)"SecondaryNameNode", (String)conf.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        this.shouldRun = true;
        this.nameNodeAddr = NameNode.getServiceAddress(conf, true);
        this.conf = conf;
        this.namenode = (NamenodeProtocol)RPC.waitForProxy(NamenodeProtocol.class, (long)6L, (InetSocketAddress)this.nameNodeAddr, (Configuration)conf);
        this.fsName = this.getInfoServer();
        this.checkpointDirs = FSImage.getCheckpointDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointEditsDirs = FSImage.getCheckpointEditsDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointImage = new CheckpointStorage(conf, this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointImage.recoverCreate(commandLineOpts.shouldFormat());
        this.checkpointCheckPeriod = conf.getLong("dfs.namenode.checkpoint.check.period", 60L);
        this.checkpointPeriod = conf.getLong("dfs.namenode.checkpoint.period", 3600L);
        this.checkpointTxnCount = conf.getLong("dfs.namenode.checkpoint.txns", 40000L);
        this.maxRetries = conf.getInt("dfs.namenode.checkpoint.max-retries", 3);
        SecondaryNameNode.warnForDeprecatedConfigs(conf);
        UserGroupInformation httpUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SecurityUtil.getServerPrincipal((String)conf.get("dfs.secondary.namenode.kerberos.https.principal"), (String)this.infoBindAddress), (String)conf.get("dfs.secondary.namenode.keytab.file"));
        try {
            this.infoServer = (HttpServer)httpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HttpServer>(){

                @Override
                public HttpServer run() throws IOException, InterruptedException {
                    LOG.info((Object)("Starting web server as: " + UserGroupInformation.getCurrentUser().getUserName()));
                    int tmpInfoPort = infoSocAddr.getPort();
                    SecondaryNameNode.this.infoServer = new HttpServer("secondary", SecondaryNameNode.this.infoBindAddress, tmpInfoPort, tmpInfoPort == 0, conf, new AccessControlList(conf.get("dfs.cluster.administrators", " ")));
                    if (UserGroupInformation.isSecurityEnabled()) {
                        System.setProperty("https.cipherSuites", (String)Krb5AndCertsSslSocketConnector.KRB5_CIPHER_SUITES.get(0));
                        InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)(SecondaryNameNode.this.infoBindAddress + ":" + conf.getInt("dfs.namenode.secondary.https-port", 50490)));
                        SecondaryNameNode.this.imagePort = secInfoSocAddr.getPort();
                        SecondaryNameNode.this.infoServer.addSslListener(secInfoSocAddr, conf, false, true);
                    }
                    SecondaryNameNode.this.infoServer.setAttribute("secondary.name.node", (Object)SecondaryNameNode.this);
                    SecondaryNameNode.this.infoServer.setAttribute("name.system.image", (Object)SecondaryNameNode.this.checkpointImage);
                    SecondaryNameNode.this.infoServer.setAttribute("current.conf", (Object)conf);
                    SecondaryNameNode.this.infoServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class, true);
                    SecondaryNameNode.this.infoServer.start();
                    return SecondaryNameNode.this.infoServer;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)"Web server init done");
        this.infoPort = this.infoServer.getPort();
        if (!UserGroupInformation.isSecurityEnabled()) {
            this.imagePort = this.infoPort;
        }
        conf.set("dfs.namenode.secondary.http-address", this.infoBindAddress + ":" + this.infoPort);
        LOG.info((Object)("Secondary Web-server up at: " + this.infoBindAddress + ":" + this.infoPort));
        LOG.info((Object)("Secondary image servlet up at: " + this.infoBindAddress + ":" + this.imagePort));
        LOG.info((Object)("Checkpoint Period   :" + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)"));
        LOG.info((Object)("Log Size Trigger    :" + this.checkpointTxnCount + " txns"));
    }

    static void warnForDeprecatedConfigs(Configuration conf) {
        for (String key : ImmutableList.of((Object)"fs.checkpoint.size", (Object)"dfs.namenode.checkpoint.size")) {
            if (conf.get(key) == null) continue;
            LOG.warn((Object)("Configuration key " + key + " is deprecated! Ignoring..." + " Instead please specify a value for " + "dfs.namenode.checkpoint.txns"));
        }
    }

    private void join() {
        try {
            this.infoServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shouldRun = false;
        try {
            if (this.infoServer != null) {
                this.infoServer.stop();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception shutting down SecondaryNameNode", (Throwable)e);
        }
        try {
            if (this.checkpointImage != null) {
                this.checkpointImage.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception while closing CheckpointStorage", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while getting login user", (Throwable)e);
                e.printStackTrace();
                ExitUtil.terminate((int)-1);
            }
            ugi.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SecondaryNameNode.this.doWork();
                    return null;
                }
            });
        } else {
            this.doWork();
        }
    }

    public void doWork() {
        long period = Math.min(this.checkpointCheckPeriod, this.checkpointPeriod);
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                if (UserGroupInformation.isSecurityEnabled()) {
                    UserGroupInformation.getCurrentUser().reloginFromKeytab();
                }
                long now = System.currentTimeMillis();
                if (!this.shouldCheckpointBasedOnCount() && now < this.lastCheckpointTime + 1000L * this.checkpointPeriod) continue;
                this.doCheckpoint();
                this.lastCheckpointTime = now;
            }
            catch (IOException e) {
                LOG.error((Object)"Exception in doCheckpoint", (Throwable)e);
                e.printStackTrace();
                if (this.checkpointImage.getMergeErrorCount() <= this.maxRetries) continue;
                LOG.fatal((Object)("Merging failed " + this.checkpointImage.getMergeErrorCount() + " times."));
                ExitUtil.terminate((int)1);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Throwable Exception in doCheckpoint", e);
                e.printStackTrace();
                ExitUtil.terminate((int)1);
            }
        }
    }

    static boolean downloadCheckpointFiles(final String nnHostPort, final FSImage dstImage, final CheckpointSignature sig, final RemoteEditLogManifest manifest) throws IOException {
        if (manifest.getLogs().isEmpty()) {
            throw new IOException("Found no edit logs to download on NN since txid " + sig.mostRecentCheckpointTxId);
        }
        long expectedTxId = sig.mostRecentCheckpointTxId + 1L;
        if (manifest.getLogs().get(0).getStartTxId() != expectedTxId) {
            throw new IOException("Bad edit log manifest (expected txid = " + expectedTxId + ": " + manifest);
        }
        try {
            Boolean b = (Boolean)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    dstImage.getStorage().cTime = sig.cTime;
                    boolean downloadImage = true;
                    if (sig.mostRecentCheckpointTxId == dstImage.getStorage().getMostRecentCheckpointTxId()) {
                        downloadImage = false;
                        LOG.info((Object)"Image has not changed. Will not download image.");
                    } else {
                        LOG.info((Object)"Image has changed. Downloading updated image from NN.");
                        MD5Hash downloadedHash = TransferFsImage.downloadImageToStorage(nnHostPort, sig.mostRecentCheckpointTxId, dstImage.getStorage(), true);
                        dstImage.saveDigestAndRenameCheckpointImage(sig.mostRecentCheckpointTxId, downloadedHash);
                    }
                    for (RemoteEditLog log : manifest.getLogs()) {
                        TransferFsImage.downloadEditsToStorage(nnHostPort, log, dstImage.getStorage());
                    }
                    return downloadImage;
                }
            });
            return b;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    InetSocketAddress getNameNodeAddress() {
        return this.nameNodeAddr;
    }

    private String getInfoServer() throws IOException {
        URI fsName = FileSystem.getDefaultUri((Configuration)this.conf);
        if (!"hdfs".equalsIgnoreCase(fsName.getScheme())) {
            throw new IOException("This is not a DFS");
        }
        String configuredAddress = DFSUtil.getInfoServer(null, this.conf, true);
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        if (sockAddr.getAddress().isAnyLocalAddress()) {
            if (UserGroupInformation.isSecurityEnabled()) {
                throw new IOException("Cannot use a wildcard address with security. Must explicitly set bind address for Kerberos");
            }
            return fsName.getHost() + ":" + sockAddr.getPort();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("configuredAddress = " + configuredAddress));
        }
        return configuredAddress;
    }

    private InetSocketAddress getImageListenAddress() {
        return new InetSocketAddress(this.infoBindAddress, this.imagePort);
    }

    boolean doCheckpoint() throws IOException {
        boolean isSameCluster;
        this.checkpointImage.ensureCurrentDirExists();
        NNStorage dstStorage = this.checkpointImage.getStorage();
        CheckpointSignature sig = this.namenode.rollEditLog();
        boolean loadImage = false;
        boolean isFreshCheckpointer = this.checkpointImage.getNamespaceID() == 0;
        boolean bl = isSameCluster = dstStorage.versionSupportsFederation() && sig.isSameCluster(this.checkpointImage) || !dstStorage.versionSupportsFederation() && sig.namespaceIdMatches(this.checkpointImage);
        if (isFreshCheckpointer || isSameCluster && !sig.storageVersionMatches(this.checkpointImage.getStorage())) {
            dstStorage.setStorageInfo(sig);
            dstStorage.setClusterID(sig.getClusterID());
            dstStorage.setBlockPoolID(sig.getBlockpoolID());
            loadImage = true;
        }
        sig.validateStorageInfo(this.checkpointImage);
        if (DFSUtil.ErrorSimulator.getErrorSimulation(0)) {
            throw new IOException("Simulating error0 after creating edits.new");
        }
        RemoteEditLogManifest manifest = this.namenode.getEditLogManifest(sig.mostRecentCheckpointTxId + 1L);
        loadImage |= SecondaryNameNode.downloadCheckpointFiles(this.fsName, this.checkpointImage, sig, manifest) | this.checkpointImage.hasMergeError();
        try {
            SecondaryNameNode.doMerge(sig, manifest, loadImage, this.checkpointImage);
        }
        catch (IOException ioe) {
            this.checkpointImage.setMergeError();
            throw ioe;
        }
        this.checkpointImage.clearMergeError();
        long txid = this.checkpointImage.getLastAppliedTxId();
        TransferFsImage.uploadImageFromStorage(this.fsName, this.getImageListenAddress(), dstStorage, txid);
        if (DFSUtil.ErrorSimulator.getErrorSimulation(1)) {
            throw new IOException("Simulating error1 after uploading new image to NameNode");
        }
        LOG.warn((Object)("Checkpoint done. New Image Size: " + dstStorage.getFsImageName(txid).length()));
        this.checkpointImage.purgeOldStorage();
        return loadImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processStartupCommand(CommandLineOpts opts) throws Exception {
        if (opts.getCommand() == null) {
            return 0;
        }
        String cmd = opts.getCommand().toString().toLowerCase();
        int exitCode = 0;
        try {
            switch (opts.getCommand()) {
                case CHECKPOINT: {
                    long count = this.countUncheckpointedTxns();
                    if (count > this.checkpointTxnCount || opts.shouldForceCheckpoint()) {
                        this.doCheckpoint();
                        break;
                    }
                    System.err.println("EditLog size " + count + " transactions is " + "smaller than configured checkpoint " + "interval " + this.checkpointTxnCount + " transactions.");
                    System.err.println("Skipping checkpoint.");
                    break;
                }
                case GETEDITSIZE: {
                    long uncheckpointed = this.countUncheckpointedTxns();
                    System.out.println("NameNode has " + uncheckpointed + " uncheckpointed transactions");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("bad command enum: " + (Object)((Object)opts.getCommand())));
                }
            }
        }
        catch (RemoteException e) {
            exitCode = 1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                LOG.error((Object)(cmd + ": " + content[0]));
            }
            catch (Exception ex) {
                LOG.error((Object)(cmd + ": " + ex.getLocalizedMessage()));
            }
        }
        catch (IOException e) {
            exitCode = 1;
            LOG.error((Object)(cmd + ": " + e.getLocalizedMessage()));
        }
        return exitCode;
    }

    private long countUncheckpointedTxns() throws IOException {
        long curTxId = this.namenode.getTransactionID();
        long uncheckpointedTxns = curTxId - this.checkpointImage.getStorage().getMostRecentCheckpointTxId();
        assert (uncheckpointedTxns >= 0L);
        return uncheckpointedTxns;
    }

    boolean shouldCheckpointBasedOnCount() throws IOException {
        return this.countUncheckpointedTxns() >= this.checkpointTxnCount;
    }

    public static void main(String[] argv) throws Exception {
        CommandLineOpts opts = SecondaryNameNode.parseArgs(argv);
        if (opts == null) {
            LOG.fatal((Object)"Failed to parse options");
            ExitUtil.terminate((int)1);
        }
        StringUtils.startupShutdownMessage(SecondaryNameNode.class, (String[])argv, (Log)LOG);
        HdfsConfiguration tconf = new HdfsConfiguration();
        SecondaryNameNode secondary = new SecondaryNameNode(tconf, opts);
        if (opts.getCommand() != null) {
            int ret = secondary.processStartupCommand(opts);
            ExitUtil.terminate((int)ret);
        }
        Daemon checkpointThread = new Daemon((Runnable)secondary);
        checkpointThread.start();
        if (secondary != null) {
            secondary.join();
        }
    }

    private static CommandLineOpts parseArgs(String[] argv) {
        CommandLineOpts opts = new CommandLineOpts();
        try {
            opts.parse(argv);
        }
        catch (ParseException pe) {
            LOG.error((Object)pe.getMessage());
            opts.usage();
            return null;
        }
        return opts;
    }

    static void doMerge(CheckpointSignature sig, RemoteEditLogManifest manifest, boolean loadImage, FSImage dstImage) throws IOException {
        NNStorage dstStorage = dstImage.getStorage();
        dstStorage.setStorageInfo(sig);
        if (loadImage) {
            File file = dstStorage.findImageFile(sig.mostRecentCheckpointTxId);
            if (file == null) {
                throw new IOException("Couldn't find image file at txid " + sig.mostRecentCheckpointTxId + " even though it should have " + "just been downloaded");
            }
            dstImage.reloadFromImageFile(file);
            dstImage.getFSNamesystem().dir.imageLoadComplete();
        }
        Checkpointer.rollForwardByApplyingLogs(manifest, dstImage);
        if (DFSUtil.ErrorSimulator.getErrorSimulation(5)) {
            throw new IOException("Simulating error5 after uploading new image to NameNode");
        }
        dstImage.saveFSImageInAllDirs(dstImage.getLastAppliedTxId());
        dstStorage.writeAll();
    }

    static {
        HdfsConfiguration.init();
        LOG = LogFactory.getLog((String)SecondaryNameNode.class.getName());
    }

    static class CheckpointStorage
    extends FSImage {
        private int mergeErrorCount;

        CheckpointStorage(Configuration conf, Collection<URI> imageDirs, Collection<URI> editsDirs) throws IOException {
            super(conf, null, imageDirs, editsDirs);
            this.setFSNamesystem(new FSNamesystem(this, conf));
            this.getFSNamesystem().dir.disableQuotaChecks();
            this.editLog = null;
            this.mergeErrorCount = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recoverCreate(boolean format) throws IOException {
            this.storage.attemptRestoreRemovedStorage();
            this.storage.unlockAll();
            Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
            block9: while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                boolean isAccessible = true;
                try {
                    if (sd.getRoot().mkdirs()) {
                        // empty if block
                    }
                }
                catch (SecurityException se) {
                    isAccessible = false;
                }
                if (!isAccessible) {
                    throw new InconsistentFSStateException(sd.getRoot(), "cannot access checkpoint directory.");
                }
                if (format) {
                    LOG.info((Object)("Formatting storage directory " + sd));
                    sd.clearDirectory();
                }
                try {
                    Storage.StorageState curState = sd.analyzeStorage(HdfsServerConstants.StartupOption.REGULAR, this.storage);
                    switch (curState) {
                        case NON_EXISTENT: {
                            throw new InconsistentFSStateException(sd.getRoot(), "checkpoint directory does not exist or is not accessible.");
                        }
                        case NOT_FORMATTED: {
                            continue block9;
                        }
                        case NORMAL: {
                            this.storage.readProperties(sd);
                            continue block9;
                        }
                    }
                    sd.doRecover(curState);
                }
                catch (IOException ioe) {
                    sd.unlock();
                    throw ioe;
                }
            }
            return;
        }

        boolean hasMergeError() {
            return this.mergeErrorCount > 0;
        }

        int getMergeErrorCount() {
            return this.mergeErrorCount;
        }

        void setMergeError() {
            ++this.mergeErrorCount;
        }

        void clearMergeError() {
            this.mergeErrorCount = 0;
        }

        void ensureCurrentDirExists() throws IOException {
            Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
            while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                File curDir = sd.getCurrentDir();
                if (curDir.exists() || curDir.mkdirs()) continue;
                throw new IOException("Could not create directory " + curDir);
            }
        }
    }

    static class CommandLineOpts {
        private final Options options = new Options();
        private final Option geteditsizeOpt = new Option("geteditsize", "return the number of uncheckpointed transactions on the NameNode");
        private final Option checkpointOpt;
        private final Option formatOpt;
        Command cmd;
        private boolean shouldForce;
        private boolean shouldFormat;

        CommandLineOpts() {
            OptionBuilder.withArgName((String)"force");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription((String)"checkpoint on startup");
            this.checkpointOpt = OptionBuilder.create((String)"checkpoint");
            this.formatOpt = new Option("format", "format the local storage during startup");
            this.options.addOption(this.geteditsizeOpt);
            this.options.addOption(this.checkpointOpt);
            this.options.addOption(this.formatOpt);
        }

        public boolean shouldFormat() {
            return this.shouldFormat;
        }

        public void parse(String ... argv) throws ParseException {
            PosixParser parser = new PosixParser();
            CommandLine cmdLine = parser.parse(this.options, argv);
            boolean hasGetEdit = cmdLine.hasOption(this.geteditsizeOpt.getOpt());
            boolean hasCheckpoint = cmdLine.hasOption(this.checkpointOpt.getOpt());
            if (hasGetEdit && hasCheckpoint) {
                throw new ParseException("May not pass both " + this.geteditsizeOpt.getOpt() + " and " + this.checkpointOpt.getOpt());
            }
            if (hasGetEdit) {
                this.cmd = Command.GETEDITSIZE;
            } else if (hasCheckpoint) {
                this.cmd = Command.CHECKPOINT;
                String arg = cmdLine.getOptionValue(this.checkpointOpt.getOpt());
                if ("force".equals(arg)) {
                    this.shouldForce = true;
                } else if (arg != null) {
                    throw new ParseException("-checkpoint may only take 'force' as an argument");
                }
            }
            if (cmdLine.hasOption(this.formatOpt.getOpt())) {
                this.shouldFormat = true;
            }
        }

        public Command getCommand() {
            return this.cmd;
        }

        public boolean shouldForceCheckpoint() {
            return this.shouldForce;
        }

        void usage() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("secondarynamenode", this.options);
        }

        static enum Command {
            GETEDITSIZE,
            CHECKPOINT;

        }
    }
}

