/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CheckpointCommand
extends NamenodeCommand {
    private CheckpointSignature cSig;
    private boolean needToReturnImage;

    public CheckpointCommand() {
        this(null, false);
    }

    public CheckpointCommand(CheckpointSignature sig, boolean needToReturnImg) {
        super(51);
        this.cSig = sig;
        this.needToReturnImage = needToReturnImg;
    }

    public CheckpointSignature getSignature() {
        return this.cSig;
    }

    public boolean needToReturnImage() {
        return this.needToReturnImage;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.cSig.write(out);
        out.writeBoolean(this.needToReturnImage);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.cSig = new CheckpointSignature();
        this.cSig.readFields(in);
        this.needToReturnImage = in.readBoolean();
    }

    static {
        WritableFactories.setFactory(CheckpointCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new CheckpointCommand();
            }
        });
    }
}

