/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class ReceivedDeletedBlockInfo
implements Writable {
    Block block;
    String delHints;
    public static final String TODELETE_HINT = "-";

    public ReceivedDeletedBlockInfo() {
    }

    public ReceivedDeletedBlockInfo(Block blk, String delHints) {
        this.block = blk;
        this.delHints = delHints;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block blk) {
        this.block = blk;
    }

    public String getDelHints() {
        return this.delHints;
    }

    public void setDelHints(String hints) {
        this.delHints = hints;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReceivedDeletedBlockInfo)) {
            return false;
        }
        ReceivedDeletedBlockInfo other = (ReceivedDeletedBlockInfo)o;
        return this.block.equals(other.getBlock()) && this.delHints.equals(other.delHints);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean blockEquals(Block b) {
        return this.block.equals(b);
    }

    public boolean isDeletedBlock() {
        return this.delHints.equals(TODELETE_HINT);
    }

    public void write(DataOutput out) throws IOException {
        this.block.write(out);
        Text.writeString((DataOutput)out, (String)this.delHints);
    }

    public void readFields(DataInput in) throws IOException {
        this.block = new Block();
        this.block.readFields(in);
        this.delHints = Text.readString((DataInput)in);
    }

    public String toString() {
        return this.block.toString() + ", delHint: " + this.delHints;
    }
}

