/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.SocketCache;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class DFSInputStream
extends FSInputStream {
    private final SocketCache socketCache;
    private final DFSClient dfsClient;
    private boolean closed = false;
    private final String src;
    private long prefetchSize;
    private BlockReader blockReader = null;
    private boolean verifyChecksum;
    private LocatedBlocks locatedBlocks = null;
    private long lastBlockBeingWrittenLength = 0L;
    private DatanodeInfo currentNode = null;
    private LocatedBlock currentLocatedBlock = null;
    private long pos = 0L;
    private long blockEnd = -1L;
    private int failures = 0;
    private int timeWindow;
    private ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
    private int buffersize = 1;
    private byte[] oneByteBuf = new byte[1];
    private int nCachedConnRetry;

    void addToDeadNodes(DatanodeInfo dnInfo) {
        this.deadNodes.put(dnInfo, dnInfo);
    }

    DFSInputStream(DFSClient dfsClient, String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.dfsClient = dfsClient;
        this.verifyChecksum = verifyChecksum;
        this.buffersize = buffersize;
        this.src = src;
        this.socketCache = dfsClient.socketCache;
        this.prefetchSize = dfsClient.getConf().prefetchSize;
        this.timeWindow = dfsClient.getConf().timeWindow;
        this.nCachedConnRetry = dfsClient.getConf().nCachedConnRetry;
        this.openInfo();
    }

    synchronized void openInfo() throws IOException, UnresolvedLinkException {
        LocatedBlock last;
        LocatedBlocks newInfo = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, 0L, this.prefetchSize);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("newInfo = " + newInfo));
        }
        if (newInfo == null) {
            throw new IOException("Cannot open filename " + this.src);
        }
        if (this.locatedBlocks != null) {
            Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
            Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
            while (oldIter.hasNext() && newIter.hasNext()) {
                if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                throw new IOException("Blocklist for " + this.src + " has changed!");
            }
        }
        this.locatedBlocks = newInfo;
        this.lastBlockBeingWrittenLength = 0L;
        if (!this.locatedBlocks.isLastBlockComplete() && (last = this.locatedBlocks.getLastLocatedBlock()) != null) {
            long len = this.readBlockLength(last);
            last.getBlock().setNumBytes(len);
            this.lastBlockBeingWrittenLength = len;
        }
        this.currentNode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readBlockLength(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null || locatedblock.getLocations().length == 0) {
            return 0L;
        }
        int replicaNotFoundCount = locatedblock.getLocations().length;
        for (DatanodeInfo datanode : locatedblock.getLocations()) {
            ClientDatanodeProtocol cdp;
            block10: {
                long l;
                block11: {
                    cdp = null;
                    try {
                        cdp = DFSUtil.createClientDatanodeProtocolProxy(datanode, this.dfsClient.conf, this.dfsClient.getConf().socketTimeout, locatedblock);
                        long n = cdp.getReplicaVisibleLength(locatedblock.getBlock());
                        if (n < 0L) break block10;
                        l = n;
                        if (cdp == null) break block11;
                    }
                    catch (IOException ioe) {
                        try {
                            if (ioe instanceof RemoteException && ((RemoteException)ioe).unwrapRemoteException() instanceof ReplicaNotFoundException) {
                                --replicaNotFoundCount;
                            }
                            if (DFSClient.LOG.isDebugEnabled()) {
                                DFSClient.LOG.debug((Object)("Failed to getReplicaVisibleLength from datanode " + datanode + " for block " + locatedblock.getBlock()), (Throwable)ioe);
                            }
                            if (cdp == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (cdp != null) {
                                RPC.stopProxy(cdp);
                            }
                            throw throwable;
                        }
                        RPC.stopProxy((Object)cdp);
                        continue;
                    }
                    RPC.stopProxy((Object)cdp);
                }
                return l;
            }
            if (cdp == null) continue;
            RPC.stopProxy((Object)cdp);
        }
        if (replicaNotFoundCount == 0) {
            return 0L;
        }
        throw new IOException("Cannot obtain block length for " + locatedblock);
    }

    public synchronized long getFileLength() {
        return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength() + this.lastBlockBeingWrittenLength;
    }

    public DatanodeInfo getCurrentDatanode() {
        return this.currentNode;
    }

    public synchronized ExtendedBlock getCurrentBlock() {
        if (this.currentLocatedBlock == null) {
            return null;
        }
        return this.currentLocatedBlock.getBlock();
    }

    synchronized List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getBlockRange(0L, this.getFileLength());
    }

    private synchronized LocatedBlock getBlockAt(long offset, boolean updatePosition) throws IOException {
        LocatedBlock blk;
        assert (this.locatedBlocks != null) : "locatedBlocks is null";
        if (offset < 0L || offset >= this.getFileLength()) {
            throw new IOException("offset < 0 || offset > getFileLength(), offset=" + offset + ", updatePosition=" + updatePosition + ", locatedBlocks=" + this.locatedBlocks);
        }
        if (offset >= this.locatedBlocks.getFileLength()) {
            blk = this.locatedBlocks.getLastLocatedBlock();
        } else {
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, offset, this.prefetchSize);
                assert (newBlocks != null) : "Could not find target position " + offset;
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            blk = this.locatedBlocks.get(targetBlockIdx);
        }
        if (updatePosition) {
            this.pos = offset;
            this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
            this.currentLocatedBlock = blk;
        }
        return blk;
    }

    private synchronized void fetchBlockAt(long offset) throws IOException {
        LocatedBlocks newBlocks;
        int targetBlockIdx = this.locatedBlocks.findBlock(offset);
        if (targetBlockIdx < 0) {
            targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
        }
        if ((newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, offset, this.prefetchSize)) == null) {
            throw new IOException("Could not find target position " + offset);
        }
        this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
    }

    private synchronized List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
        if (offset >= this.getFileLength()) {
            throw new IOException("Offset: " + offset + " exceeds file length: " + this.getFileLength());
        }
        long lengthOfCompleteBlk = this.locatedBlocks.getFileLength();
        boolean readOffsetWithinCompleteBlk = offset < lengthOfCompleteBlk;
        boolean readLengthPastCompleteBlk = offset + length > lengthOfCompleteBlk;
        List<LocatedBlock> blocks = readOffsetWithinCompleteBlk ? this.getFinalizedBlockRange(offset, Math.min(length, lengthOfCompleteBlk - offset)) : new ArrayList<LocatedBlock>(1);
        if (readLengthPastCompleteBlk) {
            blocks.add(this.locatedBlocks.getLastLocatedBlock());
        }
        return blocks;
    }

    private synchronized List<LocatedBlock> getFinalizedBlockRange(long offset, long length) throws IOException {
        assert (this.locatedBlocks != null) : "locatedBlocks is null";
        ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
        int blockIdx = this.locatedBlocks.findBlock(offset);
        if (blockIdx < 0) {
            blockIdx = LocatedBlocks.getInsertIndex(blockIdx);
        }
        long remaining = length;
        long curOff = offset;
        while (remaining > 0L) {
            LocatedBlock blk = null;
            if (blockIdx < this.locatedBlocks.locatedBlockCount()) {
                blk = this.locatedBlocks.get(blockIdx);
            }
            if (blk == null || curOff < blk.getStartOffset()) {
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, curOff, remaining);
                this.locatedBlocks.insertRange(blockIdx, newBlocks.getLocatedBlocks());
                continue;
            }
            assert (curOff >= blk.getStartOffset()) : "Block not found";
            blockRange.add(blk);
            long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
            remaining -= bytesRead;
            curOff += bytesRead;
            ++blockIdx;
        }
        return blockRange;
    }

    private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        if (this.blockReader != null) {
            this.closeBlockReader(this.blockReader);
            this.blockReader = null;
        }
        DatanodeInfo chosenNode = null;
        int refetchToken = 1;
        boolean connectFailedOnce = false;
        while (true) {
            LocatedBlock targetBlock = this.getBlockAt(target, true);
            assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DNAddrPair retval = this.chooseDataNode(targetBlock);
            chosenNode = retval.info;
            InetSocketAddress targetAddr = retval.addr;
            try {
                ExtendedBlock blk = targetBlock.getBlock();
                Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
                this.blockReader = this.getBlockReader(targetAddr, chosenNode, this.src, blk, accessToken, offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.buffersize, this.verifyChecksum, this.dfsClient.clientName);
                if (connectFailedOnce) {
                    DFSClient.LOG.info((Object)("Successfully connected to " + targetAddr + " for block " + blk.getBlockId()));
                }
                return chosenNode;
            }
            catch (IOException ex) {
                if (ex instanceof InvalidBlockTokenException && refetchToken > 0) {
                    DFSClient.LOG.info((Object)("Will fetch a new access token and retry, access token was invalid when connecting to " + targetAddr + " : " + ex));
                    --refetchToken;
                    this.fetchBlockAt(target);
                    continue;
                }
                connectFailedOnce = true;
                DFSClient.LOG.warn((Object)("Failed to connect to " + targetAddr + " for block" + ", add to deadNodes and continue. " + ex), (Throwable)ex);
                this.addToDeadNodes(chosenNode);
                continue;
            }
            break;
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.dfsClient.checkOpen();
        if (this.blockReader != null) {
            this.closeBlockReader(this.blockReader);
            this.blockReader = null;
        }
        super.close();
        this.closed = true;
    }

    public synchronized int read() throws IOException {
        int ret = this.read(this.oneByteBuf, 0, 1);
        return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    private synchronized int readBuffer(byte[] buf, int off, int len, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        boolean retryCurrentNode = true;
        while (true) {
            Throwable ioe;
            try {
                return this.blockReader.read(buf, off, len);
            }
            catch (ChecksumException ce) {
                DFSClient.LOG.warn((Object)("Found Checksum error for " + this.getCurrentBlock() + " from " + this.currentNode.getName() + " at " + ce.getPos()));
                ioe = ce;
                retryCurrentNode = false;
                this.addIntoCorruptedBlockMap(this.getCurrentBlock(), this.currentNode, corruptedBlockMap);
            }
            catch (IOException e) {
                if (!retryCurrentNode) {
                    DFSClient.LOG.warn((Object)("Exception while reading from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode), (Throwable)e);
                }
                ioe = e;
            }
            boolean sourceFound = false;
            if (retryCurrentNode) {
                sourceFound = this.seekToBlockSource(this.pos);
            } else {
                this.addToDeadNodes(this.currentNode);
                sourceFound = this.seekToNewSource(this.pos);
            }
            if (!sourceFound) {
                throw ioe;
            }
            retryCurrentNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        this.failures = 0;
        if (this.pos < this.getFileLength()) {
            int retries = 2;
            while (retries > 0) {
                try {
                    int realLen;
                    int result;
                    if (this.pos > this.blockEnd || this.currentNode == null) {
                        this.currentNode = this.blockSeekTo(this.pos);
                    }
                    if ((result = this.readBuffer(buf, off, realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L), corruptedBlockMap)) >= 0) {
                        this.pos += (long)result;
                    } else {
                        throw new IOException("Unexpected EOS from the reader");
                    }
                    if (this.dfsClient.stats != null && result != -1) {
                        this.dfsClient.stats.incrementBytesRead((long)result);
                    }
                    int n = result;
                    return n;
                }
                catch (ChecksumException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    if (retries == 1) {
                        DFSClient.LOG.warn((Object)"DFS Read", (Throwable)e);
                    }
                    this.blockEnd = -1L;
                    if (this.currentNode != null) {
                        this.addToDeadNodes(this.currentNode);
                    }
                    if (--retries != 0) continue;
                    throw e;
                }
                finally {
                    this.reportCheckSumFailure(corruptedBlockMap, this.currentLocatedBlock.getLocations().length);
                }
            }
        }
        return -1;
    }

    private void addIntoCorruptedBlockMap(ExtendedBlock blk, DatanodeInfo node, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) {
        Set<Object> dnSet = null;
        dnSet = corruptedBlockMap.containsKey(blk) ? corruptedBlockMap.get(blk) : new HashSet();
        if (!dnSet.contains(node)) {
            dnSet.add(node);
            corruptedBlockMap.put(blk, dnSet);
        }
    }

    private DNAddrPair chooseDataNode(LocatedBlock block) throws IOException {
        while (true) {
            DatanodeInfo[] nodes = block.getLocations();
            try {
                DatanodeInfo chosenNode = DFSInputStream.bestNode(nodes, this.deadNodes);
                InetSocketAddress targetAddr = NetUtils.createSocketAddr((String)chosenNode.getName());
                return new DNAddrPair(chosenNode, targetAddr);
            }
            catch (IOException ie) {
                String blockInfo = block.getBlock() + " file=" + this.src;
                if (this.failures >= this.dfsClient.getMaxBlockAcquireFailures()) {
                    throw new BlockMissingException(this.src, "Could not obtain block: " + blockInfo, block.getStartOffset());
                }
                if (nodes == null || nodes.length == 0) {
                    DFSClient.LOG.info((Object)("No node available for block: " + blockInfo));
                }
                DFSClient.LOG.info((Object)("Could not obtain block " + block.getBlock() + " from any node: " + ie + ". Will get new block locations from namenode and retry..."));
                try {
                    double waitTime = (double)(this.timeWindow * this.failures) + (double)(this.timeWindow * (this.failures + 1)) * DFSUtil.getRandom().nextDouble();
                    DFSClient.LOG.warn((Object)("DFS chooseDataNode: got # " + (this.failures + 1) + " IOException, will wait for " + waitTime + " msec."));
                    Thread.sleep((long)waitTime);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                this.deadNodes.clear();
                this.openInfo();
                block = this.getBlockAt(block.getStartOffset(), false);
                ++this.failures;
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    private void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeBlockReader(BlockReader reader) throws IOException {
        if (reader.hasSentStatusCode()) {
            Socket oldSock = reader.takeSocket();
            this.socketCache.put(oldSock);
        }
        reader.close();
    }

    protected BlockReader getBlockReader(InetSocketAddress dnAddr, DatanodeInfo chosenNode, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
        if (this.dfsClient.shouldTryShortCircuitRead(dnAddr)) {
            return DFSClient.getLocalBlockReader(this.dfsClient.conf, this.src, block, blockToken, chosenNode, this.dfsClient.hdfsTimeout, startOffset);
        }
        IOException err = null;
        boolean fromCache = true;
        for (int retries = 0; retries <= this.nCachedConnRetry && fromCache; ++retries) {
            Socket sock = null;
            if (retries < this.nCachedConnRetry) {
                sock = this.socketCache.get(dnAddr);
            }
            if (sock == null) {
                fromCache = false;
                sock = this.dfsClient.socketFactory.createSocket();
                sock.setTcpNoDelay(true);
                NetUtils.connect((Socket)sock, (SocketAddress)dnAddr, (int)this.dfsClient.getConf().socketTimeout);
                sock.setSoTimeout(this.dfsClient.getConf().socketTimeout);
            }
            try {
                BlockReader reader = BlockReaderFactory.newBlockReader(this.dfsClient.getConf(), sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName);
                return reader;
            }
            catch (IOException ex) {
                DFSClient.LOG.debug((Object)("Error making BlockReader. Closing stale " + sock), (Throwable)ex);
                sock.close();
                err = ex;
                continue;
            }
        }
        throw err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        long filelen = this.getFileLength();
        if (position < 0L || position >= filelen) {
            return -1;
        }
        int realLen = length;
        if (position + (long)length > filelen) {
            realLen = (int)(filelen - position);
        }
        List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
        int remaining = realLen;
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        for (LocatedBlock blk : blockRange) {
            long targetStart = position - blk.getStartOffset();
            long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
            try {
                this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset, corruptedBlockMap);
            }
            finally {
                this.reportCheckSumFailure(corruptedBlockMap, blk.getLocations().length);
            }
            remaining = (int)((long)remaining - bytesToRead);
            position += bytesToRead;
            offset = (int)((long)offset + bytesToRead);
        }
        assert (remaining == 0) : "Wrong number of bytes read.";
        if (this.dfsClient.stats != null) {
            this.dfsClient.stats.incrementBytesRead((long)realLen);
        }
        return realLen;
    }

    private void reportCheckSumFailure(Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap, int dataNodeCount) {
        if (corruptedBlockMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ExtendedBlock, Set<DatanodeInfo>>> it = corruptedBlockMap.entrySet().iterator();
        Map.Entry<ExtendedBlock, Set<DatanodeInfo>> entry = it.next();
        ExtendedBlock blk = entry.getKey();
        Set<DatanodeInfo> dnSet = entry.getValue();
        if (dnSet.size() < dataNodeCount && dnSet.size() > 0 || dataNodeCount == 1 && dnSet.size() == dataNodeCount) {
            DatanodeInfo[] locs = new DatanodeInfo[dnSet.size()];
            int i = 0;
            for (DatanodeInfo dn : dnSet) {
                locs[i++] = dn;
            }
            LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, locs)};
            this.dfsClient.reportChecksumFailure(this.src, lblocks);
        }
        corruptedBlockMap.clear();
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            long fileLen;
            long curPos = this.getPos();
            if (n + curPos > (fileLen = this.getFileLength())) {
                n = fileLen - curPos;
            }
            this.seek(curPos + n);
            return n;
        }
        return n < 0L ? -1L : 0L;
    }

    public synchronized void seek(long targetPos) throws IOException {
        boolean done;
        block7: {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
            done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                try {
                    this.pos += this.blockReader.skip(diff);
                    if (this.pos == targetPos) {
                        done = true;
                    }
                }
                catch (IOException e) {
                    if (!DFSClient.LOG.isDebugEnabled()) break block7;
                    DFSClient.LOG.debug((Object)("Exception while seek to " + targetPos + " from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode), (Throwable)e);
                }
            }
        }
        if (!done) {
            this.pos = targetPos;
            this.blockEnd = -1L;
        }
    }

    private synchronized boolean seekToBlockSource(long targetPos) throws IOException {
        this.currentNode = this.blockSeekTo(targetPos);
        return true;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        boolean markedDead = this.deadNodes.containsKey(this.currentNode);
        this.addToDeadNodes(this.currentNode);
        DatanodeInfo oldNode = this.currentNode;
        DatanodeInfo newNode = this.blockSeekTo(targetPos);
        if (!markedDead) {
            this.deadNodes.remove(oldNode);
        }
        if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
            this.currentNode = newNode;
            return true;
        }
        return false;
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        long remaining = this.getFileLength() - this.pos;
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    static DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }
}

