/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DataTransferProtoUtil {
    static BlockConstructionStage fromProto(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage stage) {
        return BlockConstructionStage.valueOf(BlockConstructionStage.class, stage.name());
    }

    static DataTransferProtos.OpWriteBlockProto.BlockConstructionStage toProto(BlockConstructionStage stage) {
        return DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf(stage.name());
    }

    public static DataTransferProtos.ChecksumProto toProto(DataChecksum checksum) {
        DataTransferProtos.ChecksumProto.ChecksumType type = DataTransferProtos.ChecksumProto.ChecksumType.valueOf(checksum.getChecksumType().name());
        if (type == null) {
            throw new IllegalArgumentException("Can't convert checksum to protobuf: " + checksum);
        }
        return DataTransferProtos.ChecksumProto.newBuilder().setBytesPerChecksum(checksum.getBytesPerChecksum()).setType(type).build();
    }

    public static DataChecksum fromProto(DataTransferProtos.ChecksumProto proto) {
        if (proto == null) {
            return null;
        }
        int bytesPerChecksum = proto.getBytesPerChecksum();
        DataChecksum.Type type = DataChecksum.Type.valueOf((String)proto.getType().name());
        return DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)bytesPerChecksum);
    }

    static DataTransferProtos.ClientOperationHeaderProto buildClientHeader(ExtendedBlock blk, String client, Token<BlockTokenIdentifier> blockToken) {
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setClientName(client).build();
        return header;
    }

    static DataTransferProtos.BaseHeaderProto buildBaseHeader(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) {
        return DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(HdfsProtoUtil.toProto(blk)).setToken(HdfsProtoUtil.toProto(blockToken)).build();
    }
}

