/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumMap;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.io.IOUtils;

public class FSEditLogLoader {
    private final FSNamesystem fsNamesys;

    public FSEditLogLoader(FSNamesystem fsNamesys) {
        this.fsNamesys = fsNamesys;
    }

    int loadFSEdits(EditLogInputStream edits, long expectedStartingTxId) throws IOException {
        long startTime = Util.now();
        int numEdits = this.loadFSEdits(edits, true, expectedStartingTxId);
        FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (Util.now() - startTime) / 1000L + " seconds."));
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadFSEdits(EditLogInputStream edits, boolean closeOnExit, long expectedStartingTxId) throws IOException {
        int numEdits = 0;
        int logVersion = edits.getVersion();
        try {
            numEdits = this.loadEditRecords(logVersion, edits, false, expectedStartingTxId);
        }
        finally {
            if (closeOnExit) {
                edits.close();
            }
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int loadEditRecords(int logVersion, EditLogInputStream in, boolean closeOnExit, long expectedStartingTxId) throws IOException {
        FSDirectory fsDir = this.fsNamesys.dir;
        int numEdits = 0;
        EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts = new EnumMap<FSEditLogOpCodes, Holder<Integer>>(FSEditLogOpCodes.class);
        this.fsNamesys.writeLock();
        fsDir.writeLock();
        long[] recentOpcodeOffsets = new long[4];
        Arrays.fill(recentOpcodeOffsets, -1L);
        try {
            long txId = expectedStartingTxId - 1L;
            try {
                FSEditLogOp op;
                block34: while ((op = in.readOp()) != null) {
                    recentOpcodeOffsets[numEdits % recentOpcodeOffsets.length] = in.getPosition();
                    if (LayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, logVersion)) {
                        long thisTxId = op.txid;
                        if (thisTxId != txId + 1L) {
                            throw new IOException("Expected transaction ID " + (txId + 1L) + " but got " + thisTxId);
                        }
                        txId = thisTxId;
                    }
                    ++numEdits;
                    this.incrOpCount(op.opCode, opCounts);
                    switch (op.opCode) {
                        case OP_ADD: 
                        case OP_CLOSE: {
                            INodeFile oldFile;
                            FSEditLogOp.AddCloseOp addCloseOp = (FSEditLogOp.AddCloseOp)op;
                            short replication = this.fsNamesys.getBlockManager().adjustReplication(addCloseOp.replication);
                            long blockSize = addCloseOp.blockSize;
                            BlockInfo[] blocks = new BlockInfo[addCloseOp.blocks.length];
                            for (int i = 0; i < addCloseOp.blocks.length; ++i) {
                                blocks[i] = addCloseOp.opCode == FSEditLogOpCodes.OP_ADD && i == addCloseOp.blocks.length - 1 ? new BlockInfoUnderConstruction(addCloseOp.blocks[i], replication) : new BlockInfo(addCloseOp.blocks[i], replication);
                            }
                            PermissionStatus permissions = this.fsNamesys.getUpgradePermission();
                            if (addCloseOp.permissions != null) {
                                permissions = addCloseOp.permissions;
                            }
                            if (-8 <= logVersion && blockSize == 0L) {
                                if (blocks.length > 1) {
                                    blockSize = blocks[0].getNumBytes();
                                } else {
                                    long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                    blockSize = Math.max(this.fsNamesys.getDefaultBlockSize(), first);
                                }
                            }
                            if (FSNamesystem.LOG.isDebugEnabled()) {
                                FSNamesystem.LOG.debug((Object)((Object)((Object)op.opCode) + ": " + addCloseOp.path + " numblocks : " + blocks.length + " clientHolder " + addCloseOp.clientName + " clientMachine " + addCloseOp.clientMachine));
                            }
                            if ((oldFile = fsDir.getFileINode(addCloseOp.path)) == null) {
                                assert (addCloseOp.opCode == FSEditLogOpCodes.OP_ADD) : "Expected opcode OP_ADD, but got " + (Object)((Object)addCloseOp.opCode);
                                fsDir.unprotectedAddFile(addCloseOp.path, permissions, blocks, replication, addCloseOp.mtime, addCloseOp.atime, blockSize, addCloseOp.clientName, addCloseOp.clientMachine);
                                this.fsNamesys.leaseManager.addLease(addCloseOp.clientName, addCloseOp.path);
                                continue block34;
                            }
                            fsDir.updateFile(oldFile, addCloseOp.path, blocks, addCloseOp.mtime, addCloseOp.atime);
                            if (addCloseOp.opCode == FSEditLogOpCodes.OP_CLOSE) {
                                if (!oldFile.isUnderConstruction() && logVersion <= -40) {
                                    throw new IOException("File is not under construction: " + addCloseOp.path);
                                }
                                this.fsNamesys.getBlockManager().completeBlock(oldFile, blocks.length - 1, true);
                                if (!oldFile.isUnderConstruction()) continue block34;
                                INodeFile newFile = ((INodeFileUnderConstruction)oldFile).convertToInodeFile();
                                fsDir.replaceNode(addCloseOp.path, oldFile, newFile);
                                this.fsNamesys.leaseManager.removeLease(((INodeFileUnderConstruction)oldFile).getClientName(), addCloseOp.path);
                                continue block34;
                            }
                            if (oldFile.isUnderConstruction()) continue block34;
                            this.fsNamesys.prepareFileForWrite(addCloseOp.path, oldFile, addCloseOp.clientName, addCloseOp.clientMachine, null, false);
                            continue block34;
                        }
                        case OP_SET_REPLICATION: {
                            FSEditLogOp.SetReplicationOp setReplicationOp = (FSEditLogOp.SetReplicationOp)op;
                            short replication = this.fsNamesys.getBlockManager().adjustReplication(setReplicationOp.replication);
                            fsDir.unprotectedSetReplication(setReplicationOp.path, replication, null);
                            continue block34;
                        }
                        case OP_CONCAT_DELETE: {
                            FSEditLogOp.ConcatDeleteOp concatDeleteOp = (FSEditLogOp.ConcatDeleteOp)op;
                            fsDir.unprotectedConcat(concatDeleteOp.trg, concatDeleteOp.srcs, concatDeleteOp.timestamp);
                            continue block34;
                        }
                        case OP_RENAME_OLD: {
                            FSEditLogOp.RenameOldOp renameOp = (FSEditLogOp.RenameOldOp)op;
                            HdfsFileStatus dinfo = fsDir.getFileInfo(renameOp.dst, false);
                            fsDir.unprotectedRenameTo(renameOp.src, renameOp.dst, renameOp.timestamp);
                            this.fsNamesys.unprotectedChangeLease(renameOp.src, renameOp.dst, dinfo);
                            continue block34;
                        }
                        case OP_DELETE: {
                            FSEditLogOp.DeleteOp deleteOp = (FSEditLogOp.DeleteOp)op;
                            fsDir.unprotectedDelete(deleteOp.path, deleteOp.timestamp);
                            continue block34;
                        }
                        case OP_MKDIR: {
                            FSEditLogOp.MkdirOp mkdirOp = (FSEditLogOp.MkdirOp)op;
                            PermissionStatus permissions = this.fsNamesys.getUpgradePermission();
                            if (mkdirOp.permissions != null) {
                                permissions = mkdirOp.permissions;
                            }
                            fsDir.unprotectedMkdir(mkdirOp.path, permissions, mkdirOp.timestamp);
                            continue block34;
                        }
                        case OP_SET_GENSTAMP: {
                            FSEditLogOp.SetGenstampOp setGenstampOp = (FSEditLogOp.SetGenstampOp)op;
                            this.fsNamesys.setGenerationStamp(setGenstampOp.genStamp);
                            continue block34;
                        }
                        case OP_SET_PERMISSIONS: {
                            FSEditLogOp.SetPermissionsOp setPermissionsOp = (FSEditLogOp.SetPermissionsOp)op;
                            fsDir.unprotectedSetPermission(setPermissionsOp.src, setPermissionsOp.permissions);
                            continue block34;
                        }
                        case OP_SET_OWNER: {
                            FSEditLogOp.SetOwnerOp setOwnerOp = (FSEditLogOp.SetOwnerOp)op;
                            fsDir.unprotectedSetOwner(setOwnerOp.src, setOwnerOp.username, setOwnerOp.groupname);
                            continue block34;
                        }
                        case OP_SET_NS_QUOTA: {
                            FSEditLogOp.SetNSQuotaOp setNSQuotaOp = (FSEditLogOp.SetNSQuotaOp)op;
                            fsDir.unprotectedSetQuota(setNSQuotaOp.src, setNSQuotaOp.nsQuota, Long.MAX_VALUE);
                            continue block34;
                        }
                        case OP_CLEAR_NS_QUOTA: {
                            FSEditLogOp.ClearNSQuotaOp clearNSQuotaOp = (FSEditLogOp.ClearNSQuotaOp)op;
                            fsDir.unprotectedSetQuota(clearNSQuotaOp.src, -1L, Long.MAX_VALUE);
                            continue block34;
                        }
                        case OP_SET_QUOTA: {
                            FSEditLogOp.SetQuotaOp setQuotaOp = (FSEditLogOp.SetQuotaOp)op;
                            fsDir.unprotectedSetQuota(setQuotaOp.src, setQuotaOp.nsQuota, setQuotaOp.dsQuota);
                            continue block34;
                        }
                        case OP_TIMES: {
                            FSEditLogOp.TimesOp timesOp = (FSEditLogOp.TimesOp)op;
                            fsDir.unprotectedSetTimes(timesOp.path, timesOp.mtime, timesOp.atime, true);
                            continue block34;
                        }
                        case OP_SYMLINK: {
                            FSEditLogOp.SymlinkOp symlinkOp = (FSEditLogOp.SymlinkOp)op;
                            fsDir.unprotectedSymlink(symlinkOp.path, symlinkOp.value, symlinkOp.mtime, symlinkOp.atime, symlinkOp.permissionStatus);
                            continue block34;
                        }
                        case OP_RENAME: {
                            FSEditLogOp.RenameOp renameOp = (FSEditLogOp.RenameOp)op;
                            HdfsFileStatus dinfo = fsDir.getFileInfo(renameOp.dst, false);
                            fsDir.unprotectedRenameTo(renameOp.src, renameOp.dst, renameOp.timestamp, renameOp.options);
                            this.fsNamesys.unprotectedChangeLease(renameOp.src, renameOp.dst, dinfo);
                            continue block34;
                        }
                        case OP_GET_DELEGATION_TOKEN: {
                            FSEditLogOp.GetDelegationTokenOp getDelegationTokenOp = (FSEditLogOp.GetDelegationTokenOp)op;
                            this.fsNamesys.getDelegationTokenSecretManager().addPersistedDelegationToken(getDelegationTokenOp.token, getDelegationTokenOp.expiryTime);
                            continue block34;
                        }
                        case OP_RENEW_DELEGATION_TOKEN: {
                            FSEditLogOp.RenewDelegationTokenOp renewDelegationTokenOp = (FSEditLogOp.RenewDelegationTokenOp)op;
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenRenewal(renewDelegationTokenOp.token, renewDelegationTokenOp.expiryTime);
                            continue block34;
                        }
                        case OP_CANCEL_DELEGATION_TOKEN: {
                            FSEditLogOp.CancelDelegationTokenOp cancelDelegationTokenOp = (FSEditLogOp.CancelDelegationTokenOp)op;
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenCancellation(cancelDelegationTokenOp.token);
                            continue block34;
                        }
                        case OP_UPDATE_MASTER_KEY: {
                            FSEditLogOp.UpdateMasterKeyOp updateMasterKeyOp = (FSEditLogOp.UpdateMasterKeyOp)op;
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedMasterKey(updateMasterKeyOp.key);
                            continue block34;
                        }
                        case OP_REASSIGN_LEASE: {
                            FSEditLogOp.ReassignLeaseOp reassignLeaseOp = (FSEditLogOp.ReassignLeaseOp)op;
                            LeaseManager.Lease lease = this.fsNamesys.leaseManager.getLease(reassignLeaseOp.leaseHolder);
                            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fsDir.getFileINode(reassignLeaseOp.path);
                            this.fsNamesys.reassignLeaseInternal(lease, reassignLeaseOp.path, reassignLeaseOp.newHolder, pendingFile);
                            continue block34;
                        }
                        case OP_START_LOG_SEGMENT: 
                        case OP_END_LOG_SEGMENT: {
                            continue block34;
                        }
                        case OP_DATANODE_ADD: 
                        case OP_DATANODE_REMOVE: {
                            continue block34;
                        }
                    }
                    throw new IOException("Invalid operation read " + (Object)((Object)op.opCode));
                }
            }
            catch (IOException ex) {
                this.check203UpgradeFailure(logVersion, ex);
            }
            finally {
                if (closeOnExit) {
                    in.close();
                }
            }
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error replaying edit log at offset " + in.getPosition());
            if (recentOpcodeOffsets[0] != -1L) {
                Arrays.sort(recentOpcodeOffsets);
                sb.append("\nRecent opcode offsets:");
                for (long offset : recentOpcodeOffsets) {
                    if (offset == -1L) continue;
                    sb.append(' ').append(offset);
                }
            }
            String errorMessage = sb.toString();
            FSImage.LOG.error((Object)errorMessage);
            throw new IOException(errorMessage, t);
        }
        finally {
            fsDir.writeUnlock();
            this.fsNamesys.writeUnlock();
        }
        if (FSImage.LOG.isDebugEnabled()) {
            FSEditLogLoader.dumpOpCounts(opCounts);
        }
        return numEdits;
    }

    private static void dumpOpCounts(EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts) {
        StringBuilder sb = new StringBuilder();
        sb.append("Summary of operations loaded from edit log:\n  ");
        Joiner.on((String)"\n  ").withKeyValueSeparator("=").appendTo(sb, opCounts);
        FSImage.LOG.debug((Object)sb.toString());
    }

    private void incrOpCount(FSEditLogOpCodes opCode, EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts) {
        Holder<Integer> holder = opCounts.get((Object)opCode);
        if (holder == null) {
            holder = new Holder<Integer>(1);
            opCounts.put(opCode, holder);
        } else {
            Holder<Integer> holder2 = holder;
            Object t = holder2.held;
            holder2.held = (Integer)holder2.held + 1;
            Integer n = holder2.held;
        }
    }

    private void check203UpgradeFailure(int logVersion, IOException ex) throws IOException {
        if (Storage.is203LayoutVersion(logVersion) && logVersion != HdfsConstants.LAYOUT_VERSION) {
            String msg = "During upgrade failed to load the editlog version " + logVersion + " from release 0.20.203. Please go back to the old " + " release and restart the namenode. This empties the editlog " + " and saves the namespace. Resume the upgrade after this step.";
            throw new IOException(msg, ex);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EditLogValidation validateEditLog(File file) throws IOException {
        EditLogFileInputStream in;
        try {
            in = new EditLogFileInputStream(file);
        }
        catch (EditLogFileInputStream.LogHeaderCorruptException corrupt) {
            FSImage.LOG.warn((Object)("Log at " + file + " has no valid header"), (Throwable)corrupt);
            return new EditLogValidation(0L, 0L);
        }
        try {
            EditLogValidation editLogValidation = FSEditLogLoader.validateEditLog(in);
            return editLogValidation;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
    }

    static EditLogValidation validateEditLog(EditLogInputStream in) {
        long numValid = 0L;
        long lastPos = 0L;
        try {
            while (true) {
                lastPos = in.getPosition();
                if (in.readOp() != null) {
                    ++numValid;
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            FSImage.LOG.debug((Object)("Caught exception after reading " + numValid + " ops from " + in + " while determining its valid length."), t);
        }
        return new EditLogValidation(lastPos, numValid);
    }

    static class PositionTrackingInputStream
    extends FilterInputStream {
        private long curPos = 0L;
        private long markPos = -1L;

        public PositionTrackingInputStream(InputStream is) {
            super(is);
        }

        @Override
        public int read() throws IOException {
            int ret = super.read();
            if (ret != -1) {
                ++this.curPos;
            }
            return ret;
        }

        @Override
        public int read(byte[] data) throws IOException {
            int ret = super.read(data);
            if (ret > 0) {
                this.curPos += (long)ret;
            }
            return ret;
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            int ret = super.read(data, offset, length);
            if (ret > 0) {
                this.curPos += (long)ret;
            }
            return ret;
        }

        @Override
        public void mark(int limit) {
            super.mark(limit);
            this.markPos = this.curPos;
        }

        @Override
        public void reset() throws IOException {
            if (this.markPos == -1L) {
                throw new IOException("Not marked!");
            }
            super.reset();
            this.curPos = this.markPos;
            this.markPos = -1L;
        }

        public long getPos() {
            return this.curPos;
        }
    }

    static class EditLogValidation {
        long validLength;
        long numTransactions;

        EditLogValidation(long validLength, long numTransactions) {
            this.validLength = validLength;
            this.numTransactions = numTransactions;
        }
    }
}

