/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.io.Writable;

public class RemoteEditLogManifest
implements Writable {
    private List<RemoteEditLog> logs;

    public RemoteEditLogManifest() {
    }

    public RemoteEditLogManifest(List<RemoteEditLog> logs) {
        this.logs = logs;
        this.checkState();
    }

    private void checkState() {
        Preconditions.checkNotNull(this.logs);
        RemoteEditLog prev = null;
        for (RemoteEditLog log : this.logs) {
            if (prev != null && log.getStartTxId() != prev.getEndTxId() + 1L) {
                throw new IllegalStateException("Invalid log manifest:" + this);
            }
            prev = log;
        }
    }

    public List<RemoteEditLog> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.logs) + "]";
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.logs.size());
        for (RemoteEditLog log : this.logs) {
            log.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numLogs = in.readInt();
        this.logs = Lists.newArrayList();
        for (int i = 0; i < numLogs; ++i) {
            RemoteEditLog log = new RemoteEditLog();
            log.readFields(in);
            this.logs.add(log);
        }
        this.checkState();
    }
}

