/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsElement;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class EditsVisitor {
    private Tokenizer tokenizer;

    public EditsVisitor(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    abstract void start() throws IOException;

    abstract void finish() throws IOException;

    abstract void finishAbnormally() throws IOException;

    abstract Tokenizer.Token visit(Tokenizer.Token var1) throws IOException;

    public Tokenizer.ByteToken visitByte(EditsElement e) throws IOException {
        return (Tokenizer.ByteToken)this.visit(this.tokenizer.read(new Tokenizer.ByteToken(e)));
    }

    public Tokenizer.ShortToken visitShort(EditsElement e) throws IOException {
        return (Tokenizer.ShortToken)this.visit(this.tokenizer.read(new Tokenizer.ShortToken(e)));
    }

    public Tokenizer.IntToken visitInt(EditsElement e) throws IOException {
        return (Tokenizer.IntToken)this.visit(this.tokenizer.read(new Tokenizer.IntToken(e)));
    }

    public Tokenizer.VIntToken visitVInt(EditsElement e) throws IOException {
        return (Tokenizer.VIntToken)this.visit(this.tokenizer.read(new Tokenizer.VIntToken(e)));
    }

    public Tokenizer.LongToken visitLong(EditsElement e) throws IOException {
        return (Tokenizer.LongToken)this.visit(this.tokenizer.read(new Tokenizer.LongToken(e)));
    }

    public Tokenizer.VLongToken visitVLong(EditsElement e) throws IOException {
        return (Tokenizer.VLongToken)this.visit(this.tokenizer.read(new Tokenizer.VLongToken(e)));
    }

    public Tokenizer.StringUTF8Token visitStringUTF8(EditsElement e) throws IOException {
        return (Tokenizer.StringUTF8Token)this.visit(this.tokenizer.read(new Tokenizer.StringUTF8Token(e)));
    }

    public Tokenizer.StringTextToken visitStringText(EditsElement e) throws IOException {
        return (Tokenizer.StringTextToken)this.visit(this.tokenizer.read(new Tokenizer.StringTextToken(e)));
    }

    public Tokenizer.BlobToken visitBlob(EditsElement e, int length) throws IOException {
        return (Tokenizer.BlobToken)this.visit(this.tokenizer.read(new Tokenizer.BlobToken(e, length)));
    }

    public Tokenizer.BytesWritableToken visitBytesWritable(EditsElement e) throws IOException {
        return (Tokenizer.BytesWritableToken)this.visit(this.tokenizer.read(new Tokenizer.BytesWritableToken(e)));
    }

    public Tokenizer.EmptyToken visitEmpty(EditsElement e) throws IOException {
        return (Tokenizer.EmptyToken)this.visit(this.tokenizer.read(new Tokenizer.EmptyToken(e)));
    }

    abstract void visitEnclosingElement(Tokenizer.Token var1) throws IOException;

    void visitEnclosingElement(EditsElement e) throws IOException {
        this.visitEnclosingElement(this.tokenizer.read(new Tokenizer.EmptyToken(e)));
    }

    abstract void leaveEnclosingElement() throws IOException;
}

