/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;

@InterfaceAudience.Private
public class BlockManager {
    static final Log LOG = LogFactory.getLog(BlockManager.class);
    static final Log blockLog = NameNode.blockStateChangeLog;
    public static final float DEFAULT_MAP_LOAD_FACTOR = 0.75f;
    private final Namesystem namesystem;
    private final DatanodeManager datanodeManager;
    private final HeartbeatManager heartbeatManager;
    private final BlockTokenSecretManager blockTokenSecretManager;
    private volatile long pendingReplicationBlocksCount = 0L;
    private volatile long corruptReplicaBlocksCount = 0L;
    private volatile long underReplicatedBlocksCount = 0L;
    private volatile long scheduledReplicationBlocksCount = 0L;
    private volatile long excessBlocksCount = 0L;
    private final long replicationRecheckInterval;
    final BlocksMap blocksMap;
    final Daemon replicationThread = new Daemon((Runnable)new ReplicationMonitor());
    final CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    private final InvalidateBlocks invalidateBlocks;
    public final Map<String, Collection<Block>> excessReplicateMap = new TreeMap<String, Collection<Block>>();
    public final UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    @VisibleForTesting
    final PendingReplicationBlocks pendingReplications;
    public final short maxReplication;
    int maxReplicationStreams;
    public final short minReplication;
    public final int defaultReplication;
    final int maxCorruptFilesReturned;
    final boolean shouldCheckForEnoughRacks;
    private int replIndex = 0;
    private BlockPlacementPolicy blockplacement;

    public long getPendingReplicationBlocksCount() {
        return this.pendingReplicationBlocksCount;
    }

    public long getUnderReplicatedBlocksCount() {
        return this.underReplicatedBlocksCount;
    }

    public long getCorruptReplicaBlocksCount() {
        return this.corruptReplicaBlocksCount;
    }

    public long getScheduledReplicationBlocksCount() {
        return this.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocksCount() {
        return this.invalidateBlocks.numBlocks();
    }

    public long getExcessBlocksCount() {
        return this.excessBlocksCount;
    }

    public BlockManager(Namesystem namesystem, FSClusterStats stats, Configuration conf) throws IOException {
        this.namesystem = namesystem;
        this.datanodeManager = new DatanodeManager(this, namesystem, conf);
        this.heartbeatManager = this.datanodeManager.getHeartbeatManager();
        this.invalidateBlocks = new InvalidateBlocks(this.datanodeManager);
        this.blocksMap = new BlocksMap(0.75f);
        this.blockplacement = BlockPlacementPolicy.getInstance(conf, stats, this.datanodeManager.getNetworkTopology());
        this.pendingReplications = new PendingReplicationBlocks((long)conf.getInt("dfs.namenode.replication.pending.timeout-sec", -1) * 1000L);
        this.blockTokenSecretManager = BlockManager.createBlockTokenSecretManager(conf);
        this.maxCorruptFilesReturned = conf.getInt("dfs.corruptfilesreturned.max", 500);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        int maxR = conf.getInt("dfs.replication.max", 512);
        int minR = conf.getInt("dfs.namenode.replication.min", 1);
        if (minR <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " <= 0");
        }
        if (maxR > Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + maxR + " > " + Short.MAX_VALUE);
        }
        if (minR > maxR) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " > " + "dfs.replication.max" + " = " + maxR);
        }
        this.minReplication = (short)minR;
        this.maxReplication = (short)maxR;
        this.maxReplicationStreams = conf.getInt("dfs.namenode.replication.max-streams", 2);
        this.shouldCheckForEnoughRacks = conf.get("net.topology.script.file.name") != null;
        this.replicationRecheckInterval = (long)conf.getInt("dfs.namenode.replication.interval", 3) * 1000L;
        LOG.info((Object)("defaultReplication = " + this.defaultReplication));
        LOG.info((Object)("maxReplication     = " + this.maxReplication));
        LOG.info((Object)("minReplication     = " + this.minReplication));
        LOG.info((Object)("maxReplicationStreams      = " + this.maxReplicationStreams));
        LOG.info((Object)("shouldCheckForEnoughRacks  = " + this.shouldCheckForEnoughRacks));
        LOG.info((Object)("replicationRecheckInterval = " + this.replicationRecheckInterval));
    }

    private static BlockTokenSecretManager createBlockTokenSecretManager(Configuration conf) throws IOException {
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        LOG.info((Object)("dfs.block.access.token.enable=" + isEnabled));
        if (!isEnabled) {
            return null;
        }
        long updateMin = conf.getLong("dfs.block.access.key.update.interval", 600L);
        long lifetimeMin = conf.getLong("dfs.block.access.token.lifetime", 600L);
        LOG.info((Object)("dfs.block.access.key.update.interval=" + updateMin + " min(s), " + "dfs.block.access.token.lifetime" + "=" + lifetimeMin + " min(s)"));
        return new BlockTokenSecretManager(true, updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L);
    }

    BlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenSecretManager;
    }

    private boolean isBlockTokenEnabled() {
        return this.blockTokenSecretManager != null;
    }

    boolean shouldUpdateBlockKey(long updateTime) throws IOException {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.updateKeys(updateTime) : false;
    }

    public void activate(Configuration conf) {
        this.pendingReplications.start();
        this.datanodeManager.activate(conf);
        this.replicationThread.start();
    }

    public void close() {
        if (this.pendingReplications != null) {
            this.pendingReplications.stop();
        }
        this.blocksMap.close();
        this.datanodeManager.close();
        if (this.replicationThread != null) {
            this.replicationThread.interrupt();
        }
    }

    public DatanodeManager getDatanodeManager() {
        return this.datanodeManager;
    }

    public BlockPlacementPolicy getBlockPlacementPolicy() {
        return this.blockplacement;
    }

    public void setBlockPlacementPolicy(BlockPlacementPolicy newpolicy) {
        if (newpolicy == null) {
            throw new HadoopIllegalArgumentException("newpolicy == null");
        }
        this.blockplacement = newpolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaSave(PrintWriter out) {
        assert (this.namesystem.hasWriteLock());
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.datanodeManager.fetchDatanodes(live, dead, false);
        out.println("Live Datanodes: " + live.size());
        out.println("Dead Datanodes: " + dead.size());
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
            for (Block block : this.neededReplications) {
                ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
                ArrayList<DatanodeDescriptor> containingLiveReplicasNodes = new ArrayList<DatanodeDescriptor>();
                NumberReplicas numReplicas = new NumberReplicas();
                this.chooseSourceDatanode(block, containingNodes, containingLiveReplicasNodes, numReplicas);
                assert (containingLiveReplicasNodes.size() == numReplicas.liveReplicas());
                int usableReplicas = numReplicas.liveReplicas() + numReplicas.decommissionedReplicas();
                if (block instanceof BlockInfo) {
                    String fileName = ((BlockInfo)block).getINode().getFullPathName();
                    out.print(fileName + ": ");
                }
                out.print(block + (usableReplicas > 0 ? "" : " MISSING") + " (replicas:" + " l: " + numReplicas.liveReplicas() + " d: " + numReplicas.decommissionedReplicas() + " c: " + numReplicas.corruptReplicas() + " e: " + numReplicas.excessReplicas() + ") ");
                Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
                Iterator<DatanodeDescriptor> jt = this.blocksMap.nodeIterator(block);
                while (jt.hasNext()) {
                    DatanodeDescriptor node = jt.next();
                    String state = "";
                    if (corruptNodes != null && corruptNodes.contains(node)) {
                        state = "(corrupt)";
                    } else if (node.isDecommissioned() || node.isDecommissionInProgress()) {
                        state = "(decommissioned)";
                    }
                    out.print(" " + node + state + " : ");
                }
                out.println("");
            }
        }
        this.pendingReplications.metaSave(out);
        this.invalidateBlocks.dump(out);
        this.getDatanodeManager().datanodeDump(out);
    }

    public int getMaxReplicationStreams() {
        return this.maxReplicationStreams;
    }

    public boolean checkMinReplication(Block block) {
        return this.countNodes(block).liveReplicas() >= this.minReplication;
    }

    private boolean commitBlock(BlockInfoUnderConstruction block, Block commitBlock) throws IOException {
        if (block.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
            return false;
        }
        assert (block.getNumBytes() <= commitBlock.getNumBytes()) : "commitBlock length is less than the stored one " + commitBlock.getNumBytes() + " vs. " + block.getNumBytes();
        block.commitBlock(commitBlock);
        return true;
    }

    public boolean commitOrCompleteLastBlock(INodeFileUnderConstruction fileINode, Block commitBlock) throws IOException {
        if (commitBlock == null) {
            return false;
        }
        Object lastBlock = fileINode.getLastBlock();
        if (lastBlock == null) {
            return false;
        }
        if (((BlockInfo)lastBlock).isComplete()) {
            return false;
        }
        boolean b = this.commitBlock((BlockInfoUnderConstruction)lastBlock, commitBlock);
        if (this.countNodes((Block)lastBlock).liveReplicas() >= this.minReplication) {
            this.completeBlock((INodeFile)fileINode, fileINode.numBlocks() - 1);
        }
        return b;
    }

    private BlockInfo completeBlock(INodeFile fileINode, int blkIndex) throws IOException {
        return this.completeBlock(fileINode, blkIndex, false);
    }

    public BlockInfo completeBlock(INodeFile fileINode, int blkIndex, boolean force) throws IOException {
        if (blkIndex < 0) {
            return null;
        }
        BlockInfo curBlock = fileINode.getBlocks()[blkIndex];
        if (curBlock.isComplete()) {
            return curBlock;
        }
        BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)curBlock;
        if (!force && ucBlock.numNodes() < this.minReplication) {
            throw new IOException("Cannot complete block: block does not satisfy minimal replication requirement.");
        }
        if (!force && ucBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            throw new IOException("Cannot complete block: block has not been COMMITTED by the client");
        }
        BlockInfo completeBlock = ucBlock.convertToCompleteBlock();
        fileINode.setBlock(blkIndex, completeBlock);
        return this.blocksMap.replaceBlock(completeBlock);
    }

    private BlockInfo completeBlock(INodeFile fileINode, BlockInfo block) throws IOException {
        BlockInfo[] fileBlocks = fileINode.getBlocks();
        for (int idx = 0; idx < fileBlocks.length; ++idx) {
            if (fileBlocks[idx] != block) continue;
            return this.completeBlock(fileINode, idx);
        }
        return block;
    }

    public LocatedBlock convertLastBlockToUnderConstruction(INodeFileUnderConstruction fileINode) throws IOException {
        Object oldBlock = fileINode.getLastBlock();
        if (oldBlock == null || fileINode.getPreferredBlockSize() == ((Block)oldBlock).getNumBytes()) {
            return null;
        }
        assert (oldBlock == this.getStoredBlock((Block)oldBlock)) : "last block of the file is not in blocksMap";
        DatanodeDescriptor[] targets = this.getNodes((BlockInfo)oldBlock);
        BlockInfoUnderConstruction ucBlock = fileINode.setLastBlock((BlockInfo)oldBlock, targets);
        this.blocksMap.replaceBlock(ucBlock);
        this.updateNeededReplications((Block)oldBlock, 0, 0);
        for (DatanodeDescriptor dd : targets) {
            String datanodeId = dd.getStorageID();
            this.invalidateBlocks.remove(datanodeId, (Block)oldBlock);
        }
        long fileLength = fileINode.computeContentSummary().getLength();
        long pos = fileLength - ucBlock.getNumBytes();
        return this.createLocatedBlock(ucBlock, pos, BlockTokenSecretManager.AccessMode.WRITE);
    }

    private List<String> getValidLocations(Block block) {
        ArrayList<String> machineSet = new ArrayList<String>(this.blocksMap.numNodes(block));
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            String storageID = it.next().getStorageID();
            if (this.invalidateBlocks.contains(storageID, block)) continue;
            machineSet.add(storageID);
        }
        return machineSet;
    }

    private List<LocatedBlock> createLocatedBlockList(BlockInfo[] blocks, long offset, long length, int nrBlocksToReturn, BlockTokenSecretManager.AccessMode mode) throws IOException {
        int curBlk = 0;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return Collections.emptyList();
        }
        long endOff = offset + length;
        ArrayList<LocatedBlock> results = new ArrayList<LocatedBlock>(blocks.length);
        do {
            results.add(this.createLocatedBlock(blocks[curBlk], curPos, mode));
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && results.size() < nrBlocksToReturn);
        return results;
    }

    private LocatedBlock createLocatedBlock(BlockInfo blk, long pos, BlockTokenSecretManager.AccessMode mode) throws IOException {
        LocatedBlock lb = this.createLocatedBlock(blk, pos);
        if (mode != null) {
            this.setBlockToken(lb, mode);
        }
        return lb;
    }

    private LocatedBlock createLocatedBlock(BlockInfo blk, long pos) throws IOException {
        int numNodes;
        int numCorruptReplicas;
        if (blk instanceof BlockInfoUnderConstruction) {
            if (blk.isComplete()) {
                throw new IOException("blk instanceof BlockInfoUnderConstruction && blk.isComplete(), blk=" + blk);
            }
            BlockInfoUnderConstruction uc = (BlockInfoUnderConstruction)blk;
            DatanodeInfo[] locations = uc.getExpectedLocations();
            ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
            return new LocatedBlock(eb, locations, pos, false);
        }
        int numCorruptNodes = this.countNodes(blk).corruptReplicas();
        if (numCorruptNodes != (numCorruptReplicas = this.corruptReplicas.numCorruptReplicas(blk))) {
            LOG.warn((Object)("Inconsistent number of corrupt replicas for " + blk + " blockMap has " + numCorruptNodes + " but corrupt replicas map has " + numCorruptReplicas));
        }
        boolean isCorrupt = numCorruptNodes == (numNodes = this.blocksMap.numNodes(blk));
        int numMachines = isCorrupt ? numNodes : numNodes - numCorruptNodes;
        DatanodeInfo[] machines = new DatanodeDescriptor[numMachines];
        if (numMachines > 0) {
            int j = 0;
            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blk);
            while (it.hasNext()) {
                DatanodeDescriptor d = it.next();
                boolean replicaCorrupt = this.corruptReplicas.isReplicaCorrupt(blk, d);
                if (!isCorrupt && (isCorrupt || replicaCorrupt)) continue;
                machines[j++] = d;
            }
        }
        ExtendedBlock eb = new ExtendedBlock(this.namesystem.getBlockPoolId(), blk);
        return new LocatedBlock(eb, machines, pos, isCorrupt);
    }

    public LocatedBlocks createLocatedBlocks(BlockInfo[] blocks, long fileSizeExcludeBlocksUnderConstruction, boolean isFileUnderConstruction, long offset, long length, boolean needBlockToken) throws IOException {
        assert (this.namesystem.hasReadOrWriteLock());
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 0) {
            return new LocatedBlocks(0L, isFileUnderConstruction, Collections.<LocatedBlock>emptyList(), null, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blocks = " + Arrays.asList(blocks)));
        }
        BlockTokenSecretManager.AccessMode mode = needBlockToken ? BlockTokenSecretManager.AccessMode.READ : null;
        List<LocatedBlock> locatedblocks = this.createLocatedBlockList(blocks, offset, length, Integer.MAX_VALUE, mode);
        BlockInfo last = blocks[blocks.length - 1];
        long lastPos = last.isComplete() ? fileSizeExcludeBlocksUnderConstruction - last.getNumBytes() : fileSizeExcludeBlocksUnderConstruction;
        LocatedBlock lastlb = this.createLocatedBlock(last, lastPos, mode);
        return new LocatedBlocks(fileSizeExcludeBlocksUnderConstruction, isFileUnderConstruction, locatedblocks, lastlb, last.isComplete());
    }

    public ExportedBlockKeys getBlockKeys() {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    public void setBlockToken(LocatedBlock b, BlockTokenSecretManager.AccessMode mode) throws IOException {
        if (this.isBlockTokenEnabled()) {
            b.setBlockToken(this.blockTokenSecretManager.generateToken(b.getBlock(), EnumSet.of(mode)));
        }
    }

    void addKeyUpdateCommand(List<DatanodeCommand> cmds, DatanodeDescriptor nodeinfo) {
        if (this.isBlockTokenEnabled() && nodeinfo.needKeyUpdate) {
            cmds.add(new KeyUpdateCommand(this.blockTokenSecretManager.exportKeys()));
            nodeinfo.needKeyUpdate = false;
        }
    }

    public short adjustReplication(short replication) {
        return replication < this.minReplication ? this.minReplication : (replication > this.maxReplication ? this.maxReplication : replication);
    }

    public void verifyReplication(String src, short replication, String clientName) throws IOException {
        if (replication >= this.minReplication && replication <= this.maxReplication) {
            return;
        }
        String text = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text + " is less than the required minimum " + this.minReplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlocksWithLocations getBlocks(DatanodeID datanode, long size) throws IOException {
        this.namesystem.readLock();
        try {
            this.namesystem.checkSuperuserPrivilege();
            BlocksWithLocations blocksWithLocations = this.getBlocksWithLocations(datanode, size);
            return blocksWithLocations;
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    private BlocksWithLocations getBlocksWithLocations(DatanodeID datanode, long size) throws UnregisteredNodeException {
        BlockInfo curBlock;
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(datanode);
        if (node == null) {
            blockLog.warn((Object)("BLOCK* getBlocks: Asking for blocks from an unrecorded node " + datanode.getName()));
            throw new HadoopIllegalArgumentException("Datanode " + datanode.getName() + " not found.");
        }
        int numBlocks = node.numBlocks();
        if (numBlocks == 0) {
            return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
        }
        Iterator<BlockInfo> iter = node.getBlockIterator();
        int startBlock = DFSUtil.getRandom().nextInt(numBlocks);
        for (int i = 0; i < startBlock; ++i) {
            iter.next();
        }
        ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
        long totalSize = 0L;
        while (totalSize < size && iter.hasNext()) {
            curBlock = iter.next();
            if (!curBlock.isComplete()) continue;
            totalSize += this.addBlock(curBlock, results);
        }
        if (totalSize < size) {
            iter = node.getBlockIterator();
            for (int i = 0; i < startBlock && totalSize < size; ++i) {
                curBlock = iter.next();
                if (!curBlock.isComplete()) continue;
                totalSize += this.addBlock(curBlock, results);
            }
        }
        return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
    }

    void removeBlocksAssociatedTo(DatanodeDescriptor node) {
        Iterator<BlockInfo> it = node.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), node);
        }
        node.resetBlocks();
        this.invalidateBlocks.remove(node.getStorageID());
    }

    void addToInvalidates(Block block, DatanodeInfo datanode) {
        this.invalidateBlocks.add(block, datanode, true);
    }

    private void addToInvalidates(Block b) {
        StringBuilder datanodes = new StringBuilder();
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            this.invalidateBlocks.add(b, node, false);
            datanodes.append(node.getName()).append(" ");
        }
        if (datanodes.length() != 0) {
            blockLog.info((Object)("BLOCK* addToInvalidates: " + b + " to " + datanodes.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAndMarkBlockAsCorrupt(ExtendedBlock blk, DatanodeInfo dn, String reason) throws IOException {
        this.namesystem.writeLock();
        try {
            BlockInfo storedBlock = this.getStoredBlock(blk.getLocalBlock());
            if (storedBlock == null) {
                blockLog.info((Object)("BLOCK* findAndMarkBlockAsCorrupt: " + blk + " not found."));
                return;
            }
            this.markBlockAsCorrupt(storedBlock, dn, reason);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    private void markBlockAsCorrupt(BlockInfo storedBlock, DatanodeInfo dn, String reason) throws IOException {
        assert (storedBlock != null) : "storedBlock should not be null";
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot mark block " + storedBlock.getBlockName() + " as corrupt because datanode " + dn.getName() + " does not exist. ");
        }
        INodeFile inode = storedBlock.getINode();
        if (inode == null) {
            blockLog.info((Object)("BLOCK markBlockAsCorrupt: block " + storedBlock + " could not be marked as corrupt as it" + " does not belong to any file"));
            this.addToInvalidates(storedBlock, node);
            return;
        }
        node.addBlock(storedBlock);
        this.corruptReplicas.addToCorruptReplicasMap(storedBlock, node, reason);
        if (this.countNodes(storedBlock).liveReplicas() >= inode.getReplication()) {
            this.invalidateBlock(storedBlock, node);
        } else if (this.namesystem.isPopulatingReplQueues()) {
            this.updateNeededReplications(storedBlock, -1, 0);
        }
    }

    private void invalidateBlock(Block blk, DatanodeInfo dn) throws IOException {
        blockLog.info((Object)("BLOCK* invalidateBlock: " + blk + " on " + dn.getName()));
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot invalidate block " + blk + " because datanode " + dn.getName() + " does not exist.");
        }
        int count = this.countNodes(blk).liveReplicas();
        if (count >= 1) {
            this.addToInvalidates(blk, dn);
            this.removeStoredBlock(blk, node);
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* invalidateBlocks: " + blk + " on " + dn.getName() + " listed for deletion."));
            }
        } else {
            blockLog.info((Object)("BLOCK* invalidateBlocks: " + blk + " on " + dn.getName() + " is the only copy and was not deleted."));
        }
    }

    void updateState() {
        this.pendingReplicationBlocksCount = this.pendingReplications.size();
        this.underReplicatedBlocksCount = this.neededReplications.size();
        this.corruptReplicaBlocksCount = this.corruptReplicas.size();
    }

    public int getUnderReplicatedNotMissingBlocks() {
        return this.neededReplications.getUnderReplicatedBlockCount();
    }

    int computeInvalidateWork(int nodesToProcess) {
        List<String> nodes = this.invalidateBlocks.getStorageIDs();
        Collections.shuffle(nodes);
        nodesToProcess = Math.min(nodes.size(), nodesToProcess);
        int blockCnt = 0;
        for (int nodeCnt = 0; nodeCnt < nodesToProcess; ++nodeCnt) {
            blockCnt += this.invalidateWorkForOneNode(nodes.get(nodeCnt));
        }
        return blockCnt;
    }

    private int computeReplicationWork(int blocksToProcess) throws IOException {
        List<List<Block>> blocksToReplicate = this.chooseUnderReplicatedBlocks(blocksToProcess);
        int scheduledReplicationCount = 0;
        for (int i = 0; i < blocksToReplicate.size(); ++i) {
            for (Block block : blocksToReplicate.get(i)) {
                if (!this.computeReplicationWorkForBlock(block, i)) continue;
                ++scheduledReplicationCount;
            }
        }
        return scheduledReplicationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Block>> chooseUnderReplicatedBlocks(int blocksToProcess) {
        ArrayList<List<Block>> blocksToReplicate = new ArrayList<List<Block>>(5);
        for (int i = 0; i < 5; ++i) {
            blocksToReplicate.add(new ArrayList());
        }
        this.namesystem.writeLock();
        try {
            UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
            synchronized (underReplicatedBlocks) {
                block15: {
                    if (this.neededReplications.size() != 0) break block15;
                    ArrayList<List<Block>> arrayList = blocksToReplicate;
                    return arrayList;
                }
                UnderReplicatedBlocks.BlockIterator neededReplicationsIterator = this.neededReplications.iterator();
                for (int i = 0; i < this.replIndex && neededReplicationsIterator.hasNext(); ++i) {
                    neededReplicationsIterator.next();
                }
                blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size());
                int blkCnt = 0;
                while (blkCnt < blocksToProcess) {
                    if (!neededReplicationsIterator.hasNext()) {
                        this.replIndex = 0;
                        if (blkCnt >= (blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size()))) break;
                        neededReplicationsIterator = this.neededReplications.iterator();
                        assert (neededReplicationsIterator.hasNext()) : "neededReplications should not be empty.";
                    }
                    Block block = neededReplicationsIterator.next();
                    int priority = neededReplicationsIterator.getPriority();
                    if (priority < 0 || priority >= blocksToReplicate.size()) {
                        LOG.warn((Object)("Unexpected replication priority: " + priority + " " + block));
                    } else {
                        ((List)blocksToReplicate.get(priority)).add(block);
                    }
                    ++blkCnt;
                    ++this.replIndex;
                }
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return blocksToReplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    boolean computeReplicationWorkForBlock(Block block, int priority) {
        DatanodeDescriptor[] targets;
        int numEffectiveReplicas;
        DatanodeDescriptor srcNode;
        short requiredReplication;
        INodeFile fileINode;
        block33: {
            int additionalReplRequired;
            block31: {
                fileINode = null;
                this.namesystem.writeLock();
                UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
                // MONITORENTER : underReplicatedBlocks
                fileINode = this.blocksMap.getINode(block);
                if (fileINode != null && !fileINode.isUnderConstruction()) break block31;
                this.neededReplications.remove(block, priority);
                --this.replIndex;
                boolean bl = false;
                // MONITOREXIT : underReplicatedBlocks
                this.namesystem.writeUnlock();
                return bl;
            }
            requiredReplication = fileINode.getReplication();
            ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> liveReplicaNodes = new ArrayList<DatanodeDescriptor>();
            NumberReplicas numReplicas = new NumberReplicas();
            srcNode = this.chooseSourceDatanode(block, containingNodes, liveReplicaNodes, numReplicas);
            if (srcNode == null) {
                boolean bl = false;
                // MONITOREXIT : underReplicatedBlocks
                this.namesystem.writeUnlock();
                return bl;
            }
            assert (liveReplicaNodes.size() == numReplicas.liveReplicas());
            numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
            if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(block) > 0 || this.blockHasEnoughRacks(block))) {
                this.neededReplications.remove(block, priority);
                --this.replIndex;
                blockLog.info((Object)("BLOCK* Removing block " + block + " from neededReplications as it has enough replicas."));
                boolean bl = false;
                // MONITOREXIT : underReplicatedBlocks
                this.namesystem.writeUnlock();
                return bl;
            }
            try {
                additionalReplRequired = numReplicas.liveReplicas() < requiredReplication ? requiredReplication - numEffectiveReplicas : 1;
                // MONITOREXIT : underReplicatedBlocks
            }
            finally {
                this.namesystem.writeUnlock();
            }
            HashMap<Node, Node> excludedNodes = new HashMap<Node, Node>();
            for (DatanodeDescriptor dn : containingNodes) {
                excludedNodes.put(dn, dn);
            }
            targets = this.blockplacement.chooseTarget(fileINode, additionalReplRequired, srcNode, liveReplicaNodes, excludedNodes, block.getNumBytes());
            if (targets.length == 0) {
                return false;
            }
            this.namesystem.writeLock();
            UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
            // MONITORENTER : underReplicatedBlocks
            fileINode = this.blocksMap.getINode(block);
            if (fileINode != null && !fileINode.isUnderConstruction()) break block33;
            this.neededReplications.remove(block, priority);
            --this.replIndex;
            boolean bl = false;
            // MONITOREXIT : underReplicatedBlocks
            this.namesystem.writeUnlock();
            return bl;
        }
        requiredReplication = fileINode.getReplication();
        NumberReplicas numReplicas = this.countNodes(block);
        numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
        if (numEffectiveReplicas >= requiredReplication && (this.pendingReplications.getNumReplicas(block) > 0 || this.blockHasEnoughRacks(block))) {
            this.neededReplications.remove(block, priority);
            --this.replIndex;
            blockLog.info((Object)("BLOCK* Removing block " + block + " from neededReplications as it has enough replicas."));
            boolean bl = false;
            // MONITOREXIT : underReplicatedBlocks
            this.namesystem.writeUnlock();
            return bl;
        }
        if (numReplicas.liveReplicas() >= requiredReplication && !this.blockHasEnoughRacks(block) && srcNode.getNetworkLocation().equals(targets[0].getNetworkLocation())) {
            boolean bl = false;
            // MONITOREXIT : underReplicatedBlocks
            this.namesystem.writeUnlock();
            return bl;
        }
        try {
            srcNode.addBlockToBeReplicated(block, targets);
            for (DatanodeDescriptor dn : targets) {
                dn.incBlocksScheduled();
            }
            this.pendingReplications.add(block, targets.length);
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* block " + block + " is moved from neededReplications to pendingReplications"));
            }
            if (numEffectiveReplicas + targets.length >= requiredReplication) {
                this.neededReplications.remove(block, priority);
                --this.replIndex;
            }
            if (blockLog.isInfoEnabled()) {
                StringBuilder targetList = new StringBuilder("datanode(s)");
                for (int k = 0; k < targets.length; ++k) {
                    targetList.append(' ');
                    targetList.append(targets[k].getName());
                }
                blockLog.info((Object)("BLOCK* ask " + srcNode.getName() + " to replicate " + block + " to " + targetList));
                if (blockLog.isDebugEnabled()) {
                    blockLog.debug((Object)("BLOCK* neededReplications = " + this.neededReplications.size() + " pendingReplications = " + this.pendingReplications.size()));
                }
            }
            // MONITOREXIT : underReplicatedBlocks
            return true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public DatanodeDescriptor[] chooseTarget(String src, int numOfReplicas, DatanodeDescriptor client, HashMap<Node, Node> excludedNodes, long blocksize) throws IOException {
        DatanodeDescriptor[] targets = this.blockplacement.chooseTarget(src, numOfReplicas, client, excludedNodes, blocksize);
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes instead of minReplication (=" + this.minReplication + ").  There are " + this.getDatanodeManager().getNetworkTopology().getNumOfLeaves() + " datanode(s) running and " + (excludedNodes == null ? "no" : Integer.valueOf(excludedNodes.size())) + " node(s) are excluded in this operation.");
        }
        return targets;
    }

    private DatanodeDescriptor chooseSourceDatanode(Block block, List<DatanodeDescriptor> containingNodes, List<DatanodeDescriptor> nodesContainingLiveReplicas, NumberReplicas numReplicas) {
        containingNodes.clear();
        nodesContainingLiveReplicas.clear();
        DatanodeDescriptor srcNode = null;
        int live = 0;
        int decommissioned = 0;
        int corrupt = 0;
        int excess = 0;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(block);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(node.getStorageID());
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++decommissioned;
            } else if (excessBlocks != null && excessBlocks.contains(block)) {
                ++excess;
            } else {
                nodesContainingLiveReplicas.add(node);
                ++live;
            }
            containingNodes.add(node);
            if (nodesCorrupt != null && nodesCorrupt.contains(node) || node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams || excessBlocks != null && excessBlocks.contains(block) || node.isDecommissioned()) continue;
            if (node.isDecommissionInProgress() || srcNode == null) {
                srcNode = node;
                continue;
            }
            if (srcNode.isDecommissionInProgress() || !DFSUtil.getRandom().nextBoolean()) continue;
            srcNode = node;
        }
        if (numReplicas != null) {
            numReplicas.initialize(live, decommissioned, corrupt, excess);
        }
        return srcNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            this.namesystem.writeLock();
            try {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    if (!this.isNeededReplication(timedOutItems[i], this.getReplication(timedOutItems[i]), num.liveReplicas())) continue;
                    this.neededReplications.add(timedOutItems[i], num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(timedOutItems[i]));
                }
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReport(DatanodeID nodeID, String poolId, BlockListAsLongs newReport) throws IOException {
        long endTime;
        this.namesystem.writeLock();
        long startTime = Util.now();
        try {
            DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                throw new IOException("ProcessReport from dead or unregistered node: " + nodeID.getName());
            }
            if (this.namesystem.isInStartupSafeMode() && node.numBlocks() > 0) {
                blockLog.info((Object)("BLOCK* processReport: discarded non-initial block report from " + nodeID.getName() + " because namenode still in startup phase"));
                return;
            }
            if (node.numBlocks() == 0) {
                this.processFirstBlockReport(node, newReport);
            } else {
                this.processReport(node, newReport);
            }
        }
        finally {
            long endTime2 = Util.now();
            this.namesystem.writeUnlock();
        }
        NameNode.getNameNodeMetrics().addBlockReport((int)(endTime - startTime));
        blockLog.info((Object)("BLOCK* processReport: from " + nodeID.getName() + ", blocks: " + newReport.getNumberOfBlocks() + ", processing time: " + (endTime - startTime) + " msecs"));
    }

    private void processReport(DatanodeDescriptor node, BlockListAsLongs report) throws IOException {
        LinkedList<BlockInfo> toAdd = new LinkedList<BlockInfo>();
        LinkedList<Block> toRemove = new LinkedList<Block>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        this.reportDiff(node, report, toAdd, toRemove, toInvalidate, toCorrupt, toUC);
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo.storedBlock, node, statefulBlockInfo.reportedState);
        }
        for (Block block : toRemove) {
            this.removeStoredBlock(block, node);
        }
        for (BlockInfo blockInfo : toAdd) {
            this.addStoredBlock(blockInfo, node, null, true);
        }
        for (Block block : toInvalidate) {
            blockLog.info((Object)("BLOCK* processReport: block " + block + " on " + node.getName() + " size " + block.getNumBytes() + " does not belong to any file."));
            this.addToInvalidates(block, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt.blockInfo, node, blockToMarkCorrupt.reason);
        }
    }

    private void processFirstBlockReport(DatanodeDescriptor node, BlockListAsLongs report) throws IOException {
        if (report == null) {
            return;
        }
        assert (this.namesystem.hasWriteLock());
        assert (node.numBlocks() == 0);
        BlockListAsLongs.BlockReportIterator itBR = report.getBlockReportIterator();
        while (itBR.hasNext()) {
            Block iblk = itBR.next();
            HdfsServerConstants.ReplicaState reportedState = itBR.getCurrentReplicaState();
            BlockInfo storedBlock = this.blocksMap.getStoredBlock(iblk);
            if (storedBlock == null) continue;
            HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
            BlockToMarkCorrupt c = this.checkReplicaCorrupt(iblk, reportedState, storedBlock, ucState, node);
            if (c != null) {
                this.markBlockAsCorrupt(c.blockInfo, node, c.reason);
                continue;
            }
            if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
                ((BlockInfoUnderConstruction)storedBlock).addReplicaIfNotPresent(node, iblk, reportedState);
            }
            if (reportedState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            this.addStoredBlockImmediate(storedBlock, node);
        }
    }

    private void reportDiff(DatanodeDescriptor dn, BlockListAsLongs newReport, Collection<BlockInfo> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        BlockInfo delimiter = new BlockInfo(new Block(), 1);
        boolean added = dn.addBlock(delimiter);
        assert (added) : "Delimiting block cannot be present in the node";
        if (newReport == null) {
            newReport = new BlockListAsLongs();
        }
        BlockListAsLongs.BlockReportIterator itBR = newReport.getBlockReportIterator();
        while (itBR.hasNext()) {
            HdfsServerConstants.ReplicaState iState;
            Block iblk = itBR.next();
            BlockInfo storedBlock = this.processReportedBlock(dn, iblk, iState = itBR.getCurrentReplicaState(), toAdd, toInvalidate, toCorrupt, toUC);
            if (storedBlock == null || storedBlock.findDatanode(dn) < 0) continue;
            dn.moveBlockToHead(storedBlock);
        }
        DatanodeDescriptor.BlockIterator it = new DatanodeDescriptor.BlockIterator(delimiter.getNext(0), dn);
        while (it.hasNext()) {
            toRemove.add((Block)it.next());
        }
        dn.removeBlock(delimiter);
    }

    private BlockInfo processReportedBlock(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState reportedState, Collection<BlockInfo> toAdd, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        BlockInfo storedBlock;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reported block " + block + " on " + dn.getName() + " size " + block.getNumBytes() + " replicaState = " + (Object)((Object)reportedState)));
        }
        if ((storedBlock = this.blocksMap.getStoredBlock(block)) == null) {
            toInvalidate.add(new Block(block));
            return null;
        }
        HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("In memory blockUCState = " + (Object)((Object)ucState)));
        }
        if (this.invalidateBlocks.contains(dn.getStorageID(), block)) {
            return storedBlock;
        }
        BlockToMarkCorrupt c = this.checkReplicaCorrupt(block, reportedState, storedBlock, ucState, dn);
        if (c != null) {
            toCorrupt.add(c);
            return storedBlock;
        }
        if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
            toUC.add(new StatefulBlockInfo((BlockInfoUnderConstruction)storedBlock, reportedState));
            return storedBlock;
        }
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && storedBlock.findDatanode(dn) < 0) {
            toAdd.add(storedBlock);
        }
        return storedBlock;
    }

    private BlockToMarkCorrupt checkReplicaCorrupt(Block iblk, HdfsServerConstants.ReplicaState reportedState, BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, DatanodeDescriptor dn) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case COMPLETE: 
                    case COMMITTED: {
                        if (storedBlock.getGenerationStamp() != iblk.getGenerationStamp()) {
                            return new BlockToMarkCorrupt(storedBlock, "block is " + (Object)((Object)ucState) + " and reported genstamp " + iblk.getGenerationStamp() + " does not match " + "genstamp in block map " + storedBlock.getGenerationStamp());
                        }
                        if (storedBlock.getNumBytes() != iblk.getNumBytes()) {
                            return new BlockToMarkCorrupt(storedBlock, "block is " + (Object)((Object)ucState) + " and reported length " + iblk.getNumBytes() + " does not match " + "length in block map " + storedBlock.getNumBytes());
                        }
                        return null;
                    }
                }
                return null;
            }
            case RBW: 
            case RWR: {
                if (!storedBlock.isComplete()) {
                    return null;
                }
                if (storedBlock.getGenerationStamp() != iblk.getGenerationStamp()) {
                    return new BlockToMarkCorrupt(storedBlock, "reported " + (Object)((Object)reportedState) + " replica with genstamp " + iblk.getGenerationStamp() + " does not match COMPLETE block's " + "genstamp in block map " + storedBlock.getGenerationStamp());
                }
                if (reportedState == HdfsServerConstants.ReplicaState.RBW) {
                    LOG.info((Object)("Received an RBW replica for block " + storedBlock + " on " + dn.getName() + ": ignoring it, since the block is " + "complete with the same generation stamp."));
                    return null;
                }
                return new BlockToMarkCorrupt(storedBlock, "reported replica has invalid state " + (Object)((Object)reportedState));
            }
        }
        String msg = "Unexpected replica state " + (Object)((Object)reportedState) + " for block: " + storedBlock + " on " + dn.getName() + " size " + storedBlock.getNumBytes();
        LOG.warn((Object)msg);
        return new BlockToMarkCorrupt(storedBlock, msg);
    }

    private boolean isBlockUnderConstruction(BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, HdfsServerConstants.ReplicaState reportedState) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case UNDER_CONSTRUCTION: 
                    case UNDER_RECOVERY: {
                        return true;
                    }
                }
                return false;
            }
            case RBW: 
            case RWR: {
                return !storedBlock.isComplete();
            }
        }
        return false;
    }

    void addStoredBlockUnderConstruction(BlockInfoUnderConstruction block, DatanodeDescriptor node, HdfsServerConstants.ReplicaState reportedState) throws IOException {
        block.addReplicaIfNotPresent(node, block, reportedState);
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && block.findDatanode(node) < 0) {
            this.addStoredBlock(block, node, null, true);
        }
    }

    private void addStoredBlockImmediate(BlockInfo storedBlock, DatanodeDescriptor node) throws IOException {
        assert (storedBlock != null && this.namesystem.hasWriteLock());
        if (!this.namesystem.isInStartupSafeMode() || this.namesystem.isPopulatingReplQueues()) {
            this.addStoredBlock(storedBlock, node, null, false);
            return;
        }
        node.addBlock(storedBlock);
        int numCurrentReplica = this.countLiveNodes(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numCurrentReplica >= this.minReplication) {
            storedBlock = this.completeBlock(storedBlock.getINode(), storedBlock);
        }
        if (storedBlock.isComplete()) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
    }

    private Block addStoredBlock(BlockInfo block, DatanodeDescriptor node, DatanodeDescriptor delNodeHint, boolean logEveryBlock) throws IOException {
        int curReplicaDelta;
        assert (block != null && this.namesystem.hasWriteLock());
        BlockInfo storedBlock = block instanceof BlockInfoUnderConstruction ? this.blocksMap.getStoredBlock(block) : block;
        if (storedBlock == null || storedBlock.getINode() == null) {
            blockLog.info((Object)("BLOCK* addStoredBlock: " + block + " on " + node.getName() + " size " + block.getNumBytes() + " but it does not belong to any file."));
            return block;
        }
        assert (storedBlock != null) : "Block must be stored by now";
        INodeFile fileINode = storedBlock.getINode();
        assert (fileINode != null) : "Block must belong to a file";
        boolean added = node.addBlock(storedBlock);
        if (added) {
            curReplicaDelta = 1;
            if (logEveryBlock) {
                blockLog.info((Object)("BLOCK* addStoredBlock: blockMap updated: " + node.getName() + " is added to " + storedBlock + " size " + storedBlock.getNumBytes()));
            }
        } else {
            curReplicaDelta = 0;
            blockLog.warn((Object)("BLOCK* addStoredBlock: Redundant addStoredBlock request received for " + storedBlock + " on " + node.getName() + " size " + storedBlock.getNumBytes()));
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numLiveReplicas = num.liveReplicas();
        int numCurrentReplica = numLiveReplicas + this.pendingReplications.getNumReplicas(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && numLiveReplicas >= this.minReplication) {
            storedBlock = this.completeBlock(fileINode, storedBlock);
        }
        if (storedBlock.isComplete()) {
            this.namesystem.incrementSafeBlockCount(numCurrentReplica);
        }
        if (fileINode.isUnderConstruction()) {
            return storedBlock;
        }
        if (!this.namesystem.isPopulatingReplQueues()) {
            return storedBlock;
        }
        short fileReplication = fileINode.getReplication();
        if (!this.isNeededReplication(storedBlock, fileReplication, numCurrentReplica)) {
            this.neededReplications.remove(storedBlock, numCurrentReplica, num.decommissionedReplicas(), fileReplication);
        } else {
            this.updateNeededReplications(storedBlock, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.processOverReplicatedBlock(storedBlock, fileReplication, node, delNodeHint);
        }
        int corruptReplicasCount = this.corruptReplicas.numCorruptReplicas(storedBlock);
        int numCorruptNodes = num.corruptReplicas();
        if (numCorruptNodes != corruptReplicasCount) {
            LOG.warn((Object)("Inconsistent number of corrupt replicas for " + storedBlock + "blockMap has " + numCorruptNodes + " but corrupt replicas map has " + corruptReplicasCount));
        }
        if (corruptReplicasCount > 0 && numLiveReplicas >= fileReplication) {
            this.invalidateCorruptReplicas(storedBlock);
        }
        return storedBlock;
    }

    private void invalidateCorruptReplicas(Block blk) {
        DatanodeDescriptor[] nodesCopy;
        Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(blk);
        boolean gotException = false;
        if (nodes == null) {
            return;
        }
        for (DatanodeDescriptor node : nodesCopy = nodes.toArray(new DatanodeDescriptor[0])) {
            try {
                this.invalidateBlock(blk, node);
            }
            catch (IOException e) {
                blockLog.info((Object)("NameNode.invalidateCorruptReplicas error in deleting bad block " + blk + " on " + node + e));
                gotException = true;
            }
        }
        if (!gotException) {
            this.corruptReplicas.removeFromCorruptReplicasMap(blk);
        }
    }

    public void processMisReplicatedBlocks() {
        assert (this.namesystem.hasWriteLock());
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        long nrUnderConstruction = 0L;
        this.neededReplications.clear();
        for (BlockInfo block : this.blocksMap.getBlocks()) {
            NumberReplicas num;
            int numCurrentReplica;
            INodeFile fileINode = block.getINode();
            if (fileINode == null) {
                ++nrInvalid;
                this.addToInvalidates(block);
                continue;
            }
            if (!block.isComplete()) {
                ++nrUnderConstruction;
                continue;
            }
            short expectedReplication = fileINode.getReplication();
            if (this.isNeededReplication(block, expectedReplication, numCurrentReplica = (num = this.countNodes(block)).liveReplicas()) && this.neededReplications.add(block, numCurrentReplica, num.decommissionedReplicas(), expectedReplication)) {
                ++nrUnderReplicated;
            }
            if (numCurrentReplica <= expectedReplication) continue;
            ++nrOverReplicated;
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
        }
        LOG.info((Object)("Total number of blocks            = " + this.blocksMap.size()));
        LOG.info((Object)("Number of invalid blocks          = " + nrInvalid));
        LOG.info((Object)("Number of under-replicated blocks = " + nrUnderReplicated));
        LOG.info((Object)("Number of  over-replicated blocks = " + nrOverReplicated));
        LOG.info((Object)("Number of blocks being written    = " + nrUnderConstruction));
    }

    public void setReplication(short oldRepl, short newRepl, String src, Block ... blocks) throws IOException {
        if (newRepl == oldRepl) {
            return;
        }
        for (Block b : blocks) {
            this.updateNeededReplications(b, 0, newRepl - oldRepl);
        }
        if (oldRepl > newRepl) {
            LOG.info((Object)("Decreasing replication from " + oldRepl + " to " + newRepl + " for " + src));
            for (Block b : blocks) {
                this.processOverReplicatedBlock(b, newRepl, null, null);
            }
        } else {
            LOG.info((Object)("Increasing replication from " + oldRepl + " to " + newRepl + " for " + src));
        }
    }

    private void processOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        assert (this.namesystem.hasWriteLock());
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint, this.blockplacement);
    }

    private void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint, BlockPlacementPolicy replicator) {
        assert (this.namesystem.hasWriteLock());
        INodeFile inode = this.getINode(b);
        HashMap rackMap = new HashMap();
        for (DatanodeDescriptor node : nonExcess) {
            String rackName = node.getNetworkLocation();
            List datanodeList = (ArrayList<DatanodeDescriptor>)rackMap.get(rackName);
            if (datanodeList == null) {
                datanodeList = new ArrayList<DatanodeDescriptor>();
                rackMap.put(rackName, datanodeList);
            }
            datanodeList.add(node);
        }
        ArrayList<DatanodeDescriptor> priSet = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> remains = new ArrayList<DatanodeDescriptor>();
        for (List datanodeList : rackMap.values()) {
            if (datanodeList.size() == 1) {
                remains.add((DatanodeDescriptor)datanodeList.get(0));
                continue;
            }
            priSet.addAll(datanodeList);
        }
        boolean firstOne = true;
        while (nonExcess.size() - replication > 0) {
            DatanodeDescriptor cur = firstOne && delNodeHint != null && nonExcess.contains(delNodeHint) && (priSet.contains(delNodeHint) || addedNode != null && !priSet.contains(addedNode)) ? delNodeHint : replicator.chooseReplicaToDelete(inode, b, replication, priSet, remains);
            firstOne = false;
            String rack = cur.getNetworkLocation();
            List datanodes = (List)rackMap.get(rack);
            datanodes.remove(cur);
            if (datanodes.isEmpty()) {
                rackMap.remove(rack);
            }
            if (priSet.remove(cur)) {
                if (datanodes.size() == 1) {
                    priSet.remove(datanodes.get(0));
                    remains.add((DatanodeDescriptor)datanodes.get(0));
                }
            } else {
                remains.remove(cur);
            }
            nonExcess.remove(cur);
            this.addToExcessReplicate(cur, b);
            this.addToInvalidates(b, cur);
            blockLog.info((Object)("BLOCK* chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to invalidated blocks set."));
        }
    }

    private void addToExcessReplicate(DatanodeInfo dn, Block block) {
        assert (this.namesystem.hasWriteLock());
        Collection<Block> excessBlocks = this.excessReplicateMap.get(dn.getStorageID());
        if (excessBlocks == null) {
            excessBlocks = new TreeSet<Block>();
            this.excessReplicateMap.put(dn.getStorageID(), excessBlocks);
        }
        if (excessBlocks.add(block)) {
            ++this.excessBlocksCount;
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* addToExcessReplicate: (" + dn.getName() + ", " + block + ") is added to excessReplicateMap"));
            }
        }
    }

    private void removeStoredBlock(Block block, DatanodeDescriptor node) {
        Collection<Block> excessBlocks;
        if (blockLog.isDebugEnabled()) {
            blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " from " + node.getName()));
        }
        assert (this.namesystem.hasWriteLock());
        if (!this.blocksMap.removeNode(block, node)) {
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " has already been removed from node " + node));
            }
            return;
        }
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode != null) {
            this.namesystem.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null && excessBlocks.remove(block)) {
            --this.excessBlocksCount;
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " is removed from excessBlocks"));
            }
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getStorageID());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block, node);
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        List<String> machineSet = this.getValidLocations(block);
        if (machineSet.size() == 0) {
            return 0L;
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, machineSet.toArray(new String[machineSet.size()])));
        return block.getNumBytes();
    }

    @VisibleForTesting
    void addBlock(DatanodeDescriptor node, Block block, String delHint) throws IOException {
        node.decBlocksScheduled();
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = this.datanodeManager.getDatanode(delHint)) == null) {
            blockLog.warn((Object)("BLOCK* blockReceived: " + block + " is expected to be removed from an unrecorded node " + delHint));
        }
        this.pendingReplications.remove(block);
        LinkedList<BlockInfo> toAdd = new LinkedList<BlockInfo>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        this.processReportedBlock(node, block, HdfsServerConstants.ReplicaState.FINALIZED, toAdd, toInvalidate, toCorrupt, toUC);
        assert (toUC.size() + toAdd.size() + toInvalidate.size() + toCorrupt.size() <= 1) : "The block should be only in one of the lists.";
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo.storedBlock, node, statefulBlockInfo.reportedState);
        }
        for (BlockInfo blockInfo : toAdd) {
            this.addStoredBlock(blockInfo, node, delHintNode, true);
        }
        for (Block block2 : toInvalidate) {
            blockLog.info((Object)("BLOCK* addBlock: block " + block2 + " on " + node.getName() + " size " + block2.getNumBytes() + " does not belong to any file."));
            this.addToInvalidates(block2, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt.blockInfo, node, blockToMarkCorrupt.reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockReceived(DatanodeID nodeID, String poolId, Block block, String delHint) throws IOException {
        this.namesystem.writeLock();
        try {
            DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                String s = block + " is received from dead or unregistered node " + nodeID.getName();
                blockLog.warn((Object)("BLOCK* blockReceived: " + s));
                throw new IOException(s);
            }
            if (blockLog.isDebugEnabled()) {
                blockLog.debug((Object)("BLOCK* blockReceived: " + block + " is received from " + nodeID.getName()));
            }
            this.addBlock(node, block, delHint);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public NumberReplicas countNodes(Block b) {
        int count = 0;
        int live = 0;
        int corrupt = 0;
        int excess = 0;
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(b);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
                continue;
            }
            if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++count;
                continue;
            }
            Collection<Block> blocksExcess = this.excessReplicateMap.get(node.getStorageID());
            if (blocksExcess != null && blocksExcess.contains(b)) {
                ++excess;
                continue;
            }
            ++live;
        }
        return new NumberReplicas(live, count, corrupt, excess);
    }

    int countLiveNodes(BlockInfo b) {
        if (!this.namesystem.isInStartupSafeMode()) {
            return this.countNodes(b).liveReplicas();
        }
        int live = 0;
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(b);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) continue;
            ++live;
        }
        return live;
    }

    private void logBlockReplicationInfo(Block block, DatanodeDescriptor srcNode, NumberReplicas num) {
        int curReplicas = num.liveReplicas();
        int curExpectedReplicas = this.getReplication(block);
        INodeFile fileINode = this.blocksMap.getINode(block);
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(block);
        StringBuilder nodeList = new StringBuilder();
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            nodeList.append(node.name);
            nodeList.append(" ");
        }
        LOG.info((Object)("Block: " + block + ", Expected Replicas: " + curExpectedReplicas + ", live replicas: " + curReplicas + ", corrupt replicas: " + num.corruptReplicas() + ", decommissioned replicas: " + num.decommissionedReplicas() + ", excess replicas: " + num.excessReplicas() + ", Is Open File: " + fileINode.isUnderConstruction() + ", Datanodes having this block: " + nodeList + ", Current Datanode: " + srcNode.name + ", Is current datanode decommissioning: " + srcNode.isDecommissionInProgress()));
    }

    void processOverReplicatedBlocksOnReCommission(DatanodeDescriptor srcNode) {
        Iterator<BlockInfo> it = srcNode.getBlockIterator();
        int numOverReplicated = 0;
        while (it.hasNext()) {
            Block block = it.next();
            INodeFile fileINode = this.blocksMap.getINode(block);
            short expectedReplication = fileINode.getReplication();
            NumberReplicas num = this.countNodes(block);
            int numCurrentReplica = num.liveReplicas();
            if (numCurrentReplica <= expectedReplication) continue;
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
            ++numOverReplicated;
        }
        LOG.info((Object)("Invalidated " + numOverReplicated + " over-replicated blocks on " + srcNode + " during recommissioning"));
    }

    boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        boolean status = false;
        int underReplicatedBlocks = 0;
        int decommissionOnlyReplicas = 0;
        int underReplicatedInOpenFiles = 0;
        Iterator<BlockInfo> it = srcNode.getBlockIterator();
        while (it.hasNext()) {
            Block block = it.next();
            INodeFile fileINode = this.blocksMap.getINode(block);
            if (fileINode == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (!this.isNeededReplication(block, curExpectedReplicas, curReplicas)) continue;
            if (curExpectedReplicas > curReplicas) {
                if (!status) {
                    status = true;
                    this.logBlockReplicationInfo(block, srcNode, num);
                }
                ++underReplicatedBlocks;
                if (curReplicas == 0 && num.decommissionedReplicas() > 0) {
                    ++decommissionOnlyReplicas;
                }
                if (fileINode.isUnderConstruction()) {
                    ++underReplicatedInOpenFiles;
                }
            }
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.add(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas);
        }
        srcNode.decommissioningStatus.set(underReplicatedBlocks, decommissionOnlyReplicas, underReplicatedInOpenFiles);
        return status;
    }

    public int getActiveBlockCount() {
        return this.blocksMap.size() - (int)this.invalidateBlocks.numBlocks();
    }

    public DatanodeDescriptor[] getNodes(BlockInfo block) {
        DatanodeDescriptor[] nodes = new DatanodeDescriptor[block.numNodes()];
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        int i = 0;
        while (it != null && it.hasNext()) {
            nodes[i] = it.next();
            ++i;
        }
        return nodes;
    }

    public int getTotalBlocks() {
        return this.blocksMap.size();
    }

    public void removeBlock(Block block) {
        this.addToInvalidates(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
        this.blocksMap.removeBlock(block);
    }

    public BlockInfo getStoredBlock(Block block) {
        return this.blocksMap.getStoredBlock(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        this.namesystem.writeLock();
        try {
            NumberReplicas repl = this.countNodes(block);
            int curExpectedReplicas = this.getReplication(block);
            if (this.isNeededReplication(block, curExpectedReplicas, repl.liveReplicas())) {
                this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
            } else {
                int oldReplicas = repl.liveReplicas() - curReplicasDelta;
                int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
                this.neededReplications.remove(block, oldReplicas, repl.decommissionedReplicas(), oldExpectedReplicas);
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public void checkReplication(Block block, int numExpectedReplicas) {
        NumberReplicas number = this.countNodes(block);
        if (this.isNeededReplication(block, numExpectedReplicas, number.liveReplicas())) {
            this.neededReplications.add(block, number.liveReplicas(), number.decommissionedReplicas(), numExpectedReplicas);
        }
    }

    private int getReplication(Block block) {
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode == null) {
            return 0;
        }
        assert (!fileINode.isDirectory()) : "Block cannot belong to a directory.";
        return fileINode.getReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invalidateWorkForOneNode(String nodeId) {
        this.namesystem.writeLock();
        try {
            if (this.namesystem.isInSafeMode()) {
                int n = 0;
                return n;
            }
            assert (nodeId != null);
            int n = this.invalidateBlocks.invalidateWork(nodeId);
            return n;
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    boolean blockHasEnoughRacks(Block b) {
        if (!this.shouldCheckForEnoughRacks) {
            return true;
        }
        boolean enoughRacks = false;
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(b);
        int numExpectedReplicas = this.getReplication(b);
        String rackName = null;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            if (numExpectedReplicas == 1) {
                enoughRacks = true;
                break;
            }
            String rackNameNew = cur.getNetworkLocation();
            if (rackName == null) {
                rackName = rackNameNew;
                continue;
            }
            if (rackName.equals(rackNameNew)) continue;
            enoughRacks = true;
            break;
        }
        return enoughRacks;
    }

    boolean isNeededReplication(Block b, int expectedReplication, int curReplicas) {
        return curReplicas < expectedReplication || !this.blockHasEnoughRacks(b);
    }

    public long getMissingBlocksCount() {
        return this.neededReplications.getCorruptBlockSize();
    }

    public BlockInfo addINode(BlockInfo block, INodeFile iNode) {
        return this.blocksMap.addINode(block, iNode);
    }

    public INodeFile getINode(Block b) {
        return this.blocksMap.getINode(b);
    }

    public Iterator<DatanodeDescriptor> datanodeIterator(Block block) {
        return this.blocksMap.nodeIterator(block);
    }

    public int numCorruptReplicas(Block block) {
        return this.corruptReplicas.numCorruptReplicas(block);
    }

    public void removeBlockFromMap(Block block) {
        this.blocksMap.removeBlock(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        this.namesystem.readLock();
        try {
            int n = this.blocksMap.getCapacity();
            return n;
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    public long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) {
        return this.corruptReplicas.getCorruptReplicaBlockIds(numExpectedBlocks, startingBlockId);
    }

    public Iterator<Block> getCorruptReplicaBlockIterator() {
        return this.neededReplications.iterator(4);
    }

    public int numOfUnderReplicatedBlocks() {
        return this.neededReplications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeDatanodeWork() throws IOException {
        int workFound = 0;
        if (this.namesystem.isInSafeMode()) {
            return workFound;
        }
        int numlive = this.heartbeatManager.getLiveDatanodeCount();
        int blocksToProcess = numlive * 2;
        int nodesToProcess = (int)Math.ceil((double)(numlive * 32) / 100.0);
        workFound = this.computeReplicationWork(blocksToProcess);
        this.namesystem.writeLock();
        try {
            this.updateState();
            this.scheduledReplicationBlocksCount = workFound;
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return workFound += this.computeInvalidateWork(nodesToProcess);
    }

    private class ReplicationMonitor
    implements Runnable {
        private static final int INVALIDATE_WORK_PCT_PER_ITERATION = 32;
        private static final int REPLICATION_WORK_MULTIPLIER_PER_ITERATION = 2;

        private ReplicationMonitor() {
        }

        @Override
        public void run() {
            while (BlockManager.this.namesystem.isRunning()) {
                try {
                    BlockManager.this.computeDatanodeWork();
                    BlockManager.this.processPendingReplications();
                    Thread.sleep(BlockManager.this.replicationRecheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"ReplicationMonitor thread received InterruptedException.", (Throwable)ie);
                    break;
                }
                catch (IOException ie) {
                    LOG.warn((Object)"ReplicationMonitor thread received exception. ", (Throwable)ie);
                }
                catch (Throwable t) {
                    LOG.fatal((Object)"ReplicationMonitor thread received Runtime exception. ", t);
                    ExitUtil.terminate((int)1);
                }
            }
        }
    }

    private static class BlockToMarkCorrupt {
        final BlockInfo blockInfo;
        final String reason;

        BlockToMarkCorrupt(BlockInfo blockInfo, String reason) {
            this.blockInfo = blockInfo;
            this.reason = reason;
        }
    }

    private static class StatefulBlockInfo {
        final BlockInfoUnderConstruction storedBlock;
        final HdfsServerConstants.ReplicaState reportedState;

        StatefulBlockInfo(BlockInfoUnderConstruction storedBlock, HdfsServerConstants.ReplicaState reportedState) {
            this.storedBlock = storedBlock;
            this.reportedState = reportedState;
        }
    }
}

