/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.UpgradeManager;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;

@InterfaceAudience.Private
public class DataBlockScanner
implements Runnable {
    public static final Log LOG = LogFactory.getLog(DataBlockScanner.class);
    private final DataNode datanode;
    private final FSDatasetInterface dataset;
    private final Configuration conf;
    private final TreeMap<String, BlockPoolSliceScanner> blockPoolScannerMap = new TreeMap();
    Thread blockScannerThread = null;

    DataBlockScanner(DataNode datanode, FSDatasetInterface dataset, Configuration conf) {
        this.datanode = datanode;
        this.dataset = dataset;
        this.conf = conf;
    }

    @Override
    public void run() {
        String currentBpId = "";
        boolean firstRun = true;
        while (this.datanode.shouldRun && !Thread.interrupted()) {
            BlockPoolSliceScanner bpScanner;
            block5: {
                if (!firstRun) {
                    try {
                        Thread.sleep(5000L);
                        break block5;
                    }
                    catch (InterruptedException ex) {
                        this.blockScannerThread.interrupt();
                        continue;
                    }
                }
                firstRun = false;
            }
            if ((bpScanner = this.getNextBPScanner(currentBpId)) == null) continue;
            currentBpId = bpScanner.getBlockPoolId();
            if (!this.datanode.isBPServiceAlive(currentBpId)) {
                LOG.warn((Object)("Block Pool " + currentBpId + " is not alive"));
                this.removeBlockPool(currentBpId);
                continue;
            }
            bpScanner.scanBlockPoolSlice();
        }
    }

    private void waitForInit(String bpid) {
        UpgradeManager um = null;
        if (bpid != null && !bpid.equals("")) {
            um = this.datanode.getUpgradeManagerDatanode(bpid);
        }
        while (um != null && !um.isUpgradeCompleted() || this.getBlockPoolSetSize() < this.datanode.getAllBpOs().length || this.getBlockPoolSetSize() < 1) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.blockScannerThread.interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockPoolSliceScanner getNextBPScanner(String currentBpId) {
        String nextBpId = null;
        while (nextBpId == null && this.datanode.shouldRun && !this.blockScannerThread.isInterrupted()) {
            this.waitForInit(currentBpId);
            DataBlockScanner dataBlockScanner = this;
            synchronized (dataBlockScanner) {
                if (this.getBlockPoolSetSize() > 0) {
                    long lastScanTime = -1L;
                    for (String bpid : this.blockPoolScannerMap.keySet()) {
                        for (FSDatasetInterface.FSVolumeInterface vol : this.dataset.getVolumes()) {
                            try {
                                long lastModified;
                                File currFile = BlockPoolSliceScanner.getCurrentFile(vol, bpid);
                                if (!currFile.exists() || lastScanTime >= (lastModified = currFile.lastModified())) continue;
                                lastScanTime = lastModified;
                                nextBpId = bpid;
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Received exception: ", (Throwable)e);
                            }
                        }
                    }
                    if (nextBpId == null) {
                        if ("".equals(currentBpId)) {
                            nextBpId = this.blockPoolScannerMap.firstKey();
                        } else {
                            nextBpId = this.blockPoolScannerMap.higherKey(currentBpId);
                            if (nextBpId == null) {
                                nextBpId = this.blockPoolScannerMap.firstKey();
                            }
                        }
                    }
                    if (nextBpId != null) {
                        return this.getBPScanner(nextBpId);
                    }
                }
            }
            LOG.warn((Object)"No block pool is up, going to wait");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)("Received exception: " + ex));
                this.blockScannerThread.interrupt();
                return null;
            }
        }
        return null;
    }

    private synchronized int getBlockPoolSetSize() {
        return this.blockPoolScannerMap.size();
    }

    private synchronized BlockPoolSliceScanner getBPScanner(String bpid) {
        return this.blockPoolScannerMap.get(bpid);
    }

    private synchronized String[] getBpIdList() {
        return this.blockPoolScannerMap.keySet().toArray(new String[this.blockPoolScannerMap.keySet().size()]);
    }

    public void addBlock(ExtendedBlock block) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(block.getBlockPoolId());
        if (bpScanner != null) {
            bpScanner.addBlock(block);
        } else {
            LOG.warn((Object)("No block pool scanner found for block pool id: " + block.getBlockPoolId()));
        }
    }

    public synchronized boolean isInitialized(String bpid) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
        if (bpScanner != null) {
            return bpScanner.isInitialized();
        }
        return false;
    }

    public synchronized void printBlockReport(StringBuilder buffer, boolean summary) {
        String[] bpIdList = this.getBpIdList();
        if (bpIdList == null || bpIdList.length == 0) {
            buffer.append("Periodic block scanner is not yet initialized. Please check back again after some time.");
            return;
        }
        for (String bpid : bpIdList) {
            BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
            buffer.append("\n\nBlock report for block pool: " + bpid + "\n");
            bpScanner.printBlockReport(buffer, summary);
            buffer.append("\n");
        }
    }

    public void deleteBlock(String poolId, Block toDelete) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(poolId);
        if (bpScanner != null) {
            bpScanner.deleteBlock(toDelete);
        } else {
            LOG.warn((Object)("No block pool scanner found for block pool id: " + poolId));
        }
    }

    public void deleteBlocks(String poolId, Block[] toDelete) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(poolId);
        if (bpScanner != null) {
            bpScanner.deleteBlocks(toDelete);
        } else {
            LOG.warn((Object)("No block pool scanner found for block pool id: " + poolId));
        }
    }

    public synchronized void shutdown() {
        if (this.blockScannerThread != null) {
            this.blockScannerThread.interrupt();
        }
    }

    public synchronized void addBlockPool(String blockPoolId) {
        if (this.blockPoolScannerMap.get(blockPoolId) != null) {
            return;
        }
        BlockPoolSliceScanner bpScanner = new BlockPoolSliceScanner(this.datanode, this.dataset, this.conf, blockPoolId);
        try {
            bpScanner.init();
        }
        catch (IOException ex) {
            LOG.warn((Object)("Failed to initialized block scanner for pool id=" + blockPoolId));
            return;
        }
        this.blockPoolScannerMap.put(blockPoolId, bpScanner);
        LOG.info((Object)("Added bpid=" + blockPoolId + " to blockPoolScannerMap, new size=" + this.blockPoolScannerMap.size()));
    }

    public synchronized void removeBlockPool(String blockPoolId) {
        this.blockPoolScannerMap.remove(blockPoolId);
        LOG.info((Object)("Removed bpid=" + blockPoolId + " from blockPoolScannerMap"));
    }

    long getBlocksScannedInLastRun(String bpid) throws IOException {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
        if (bpScanner == null) {
            throw new IOException("Block Pool: " + bpid + " is not running");
        }
        return bpScanner.getBlocksScannedInLastRun();
    }

    public void start() {
        this.blockScannerThread = new Thread(this);
        this.blockScannerThread.setDaemon(true);
        this.blockScannerThread.start();
    }

    @InterfaceAudience.Private
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("text/plain");
            DataNode datanode = (DataNode)this.getServletContext().getAttribute("datanode");
            DataBlockScanner blockScanner = datanode.blockScanner;
            boolean summary = request.getParameter("listblocks") == null;
            StringBuilder buffer = new StringBuilder(8192);
            if (blockScanner == null) {
                LOG.warn((Object)"Periodic block scanner is not running");
                buffer.append("Periodic block scanner is not running. Please check the datanode log if this is unexpected.");
            } else {
                blockScanner.printBlockReport(buffer, summary);
            }
            response.getWriter().write(buffer.toString());
        }
    }
}

