/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class NameNode {
    public static final String[] NAMESERVICE_SPECIFIC_KEYS;
    public static final int DEFAULT_PORT = 8020;
    public static final Log LOG;
    public static final Log stateChangeLog;
    public static final Log blockStateChangeLog;
    protected FSNamesystem namesystem;
    protected HdfsServerConstants.NamenodeRole role;
    protected NameNodeHttpServer httpServer;
    private Thread emptier;
    protected boolean stopRequested = false;
    protected NamenodeRegistration nodeRegistration;
    private List<ServicePlugin> plugins;
    private NameNodeRpcServer rpcServer;
    static NameNodeMetrics metrics;

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, false);
    }

    public FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    public NamenodeProtocols getRpcServer() {
        return this.rpcServer;
    }

    static void initMetrics(Configuration conf, HdfsServerConstants.NamenodeRole role) {
        metrics = NameNodeMetrics.create(conf, role);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return metrics;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr((String)address, (int)8020);
    }

    public static void setServiceAddress(Configuration conf, String address) {
        LOG.info((Object)("Setting ADDRESS " + address));
        conf.set("dfs.namenode.servicerpc-address", address);
    }

    public static InetSocketAddress getServiceAddress(Configuration conf, boolean fallback) {
        String addr = conf.get("dfs.namenode.servicerpc-address");
        if (addr == null || addr.isEmpty()) {
            return fallback ? NameNode.getAddress(conf) : null;
        }
        return NameNode.getAddress(addr);
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        return NameNode.getAddress(filesystemURI);
    }

    static InetSocketAddress getAddress(URI filesystemURI) {
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return NameNode.getAddress(authority);
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public static String getHostPortString(InetSocketAddress addr) {
        return addr.getHostName() + ":" + addr.getPort();
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        return this.role;
    }

    boolean isRole(HdfsServerConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) throws IOException {
        return NameNode.getServiceAddress(conf, false);
    }

    protected InetSocketAddress getRpcServerAddress(Configuration conf) throws IOException {
        return NameNode.getAddress(conf);
    }

    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress serviceRPCAddress) {
        NameNode.setServiceAddress(conf, NameNode.getHostPortString(serviceRPCAddress));
    }

    protected void setRpcServerAddress(Configuration conf, InetSocketAddress rpcAddress) {
        FileSystem.setDefaultUri((Configuration)conf, (URI)NameNode.getUri(rpcAddress));
    }

    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        return NameNode.getHttpAddress(conf);
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.namenode.http-address", "0.0.0.0:50070"));
    }

    protected void setHttpServerAddress(Configuration conf) {
        conf.set("dfs.namenode.http-address", NameNode.getHostPortString(this.getHttpAddress()));
    }

    protected void loadNamesystem(Configuration conf) throws IOException {
        this.namesystem = new FSNamesystem(conf);
    }

    NamenodeRegistration getRegistration() {
        return this.nodeRegistration;
    }

    NamenodeRegistration setRegistration() {
        this.nodeRegistration = new NamenodeRegistration(NameNode.getHostPortString(this.rpcServer.getRpcAddress()), NameNode.getHostPortString(this.getHttpAddress()), this.getFSImage().getStorage(), this.getRole());
        return this.nodeRegistration;
    }

    void loginAsNameNodeUser(Configuration conf) throws IOException {
        InetSocketAddress socAddr = this.getRpcServerAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected void initialize(Configuration conf) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.loginAsNameNodeUser(conf);
        NameNode.initMetrics(conf, this.getRole());
        this.loadNamesystem(conf);
        this.rpcServer = this.createRpcServer(conf);
        try {
            this.validateConfigurationSettings(conf);
        }
        catch (IOException e) {
            LOG.fatal((Object)e.toString());
            throw e;
        }
        this.activate(conf);
        LOG.info((Object)((Object)((Object)this.getRole()) + " up at: " + this.rpcServer.getRpcAddress()));
        if (this.rpcServer.getServiceRpcAddress() != null) {
            LOG.info((Object)((Object)((Object)this.getRole()) + " service server is up at: " + this.rpcServer.getServiceRpcAddress()));
        }
    }

    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new NameNodeRpcServer(conf, this);
    }

    protected void validateConfigurationSettings(Configuration conf) throws IOException {
        if (this.getHttpServerAddress(conf).getPort() == this.getRpcServerAddress(conf).getPort()) {
            String errMsg = "dfs.namenode.rpc-address (" + this.getRpcServerAddress(conf) + ") and " + "dfs.namenode.http-address (" + this.getHttpServerAddress(conf) + ") " + "configuration keys are bound to the same port, unable to start " + "NameNode. Port: " + this.getRpcServerAddress(conf).getPort();
            throw new IOException(errMsg);
        }
    }

    void activate(Configuration conf) throws IOException {
        if (this.isRole(HdfsServerConstants.NamenodeRole.NAMENODE) && UserGroupInformation.isSecurityEnabled()) {
            this.namesystem.activateSecretManager();
        }
        this.namesystem.activate(conf);
        this.startHttpServer(conf);
        this.rpcServer.start();
        this.startTrashEmptier(conf);
        this.plugins = conf.getInstances("dfs.namenode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
            }
            catch (Throwable t) {
                LOG.warn((Object)("ServicePlugin " + p + " could not be started"), t);
            }
        }
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        if (trashInterval == 0L) {
            return;
        }
        this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void startHttpServer(Configuration conf) throws IOException {
        this.httpServer = new NameNodeHttpServer(conf, this, this.getHttpServerAddress(conf));
        this.httpServer.start();
        this.setHttpServerAddress(conf);
    }

    public NameNode(Configuration conf) throws IOException {
        this(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
    }

    protected NameNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        this.role = role;
        try {
            NameNode.initializeGenericKeys(conf, this.getNameServiceId(conf));
            this.initialize(conf);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
        catch (HadoopIllegalArgumentException e) {
            this.stop();
            throw e;
        }
    }

    public void join() {
        try {
            this.rpcServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NameNode nameNode = this;
        synchronized (nameNode) {
            if (this.stopRequested) {
                return;
            }
            this.stopRequested = true;
        }
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        }
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while stopping httpserver", (Throwable)e);
        }
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.emptier != null) {
            this.emptier.interrupt();
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (metrics != null) {
            metrics.shutdown();
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
        }
    }

    synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.rpcServer.getRpcAddress();
    }

    public InetSocketAddress getServiceRpcAddress() {
        return this.rpcServer.getServiceRpcAddress() != null ? this.rpcServer.getServiceRpcAddress() : this.rpcServer.getRpcAddress();
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    private static boolean format(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        if (!conf.getBoolean("dfs.namenode.support.allow.format", true)) {
            throw new IOException("The option dfs.namenode.support.allow.format is set to false for this filesystem, so it cannot be formatted. You will need to set dfs.namenode.support.allow.format parameter to true in order to format this filesystem");
        }
        Collection<URI> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        Collection<URI> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        Iterator<URI> it = dirsToFormat.iterator();
        while (it.hasNext()) {
            File curDir = new File(it.next().getPath());
            if (!curDir.exists() || curDir.isDirectory() && FileUtil.listFiles((File)curDir).length == 0 || !isConfirmationNeeded || NameNode.confirmPrompt("Re-format filesystem in " + curDir + " ?")) continue;
            System.err.println("Format aborted in " + curDir);
            return true;
        }
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.equals("")) {
            clusterId = NNStorage.newClusterID();
        }
        System.out.println("Formatting using clusterid: " + clusterId);
        FSImage fsImage = new FSImage(conf, null, dirsToFormat, editDirsToFormat);
        FSNamesystem nsys = new FSNamesystem(fsImage, conf);
        nsys.dir.fsImage.format(clusterId);
        return false;
    }

    private static boolean finalize(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        FSNamesystem nsys = new FSNamesystem(new FSImage(conf), conf);
        System.err.print("\"finalize\" will remove the previous state of the files system.\nRecent upgrade will become permanent.\nRollback option will not be available anymore.\n");
        if (isConfirmationNeeded && !NameNode.confirmPrompt("Finalize filesystem state?")) {
            System.err.println("Finalize aborted.");
            return true;
        }
        nsys.dir.fsImage.finalizeUpgrade();
        return false;
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [" + HdfsServerConstants.StartupOption.BACKUP.getName() + "] | [" + HdfsServerConstants.StartupOption.CHECKPOINT.getName() + "] | [" + HdfsServerConstants.StartupOption.FORMAT.getName() + "[" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid ]] | [" + HdfsServerConstants.StartupOption.UPGRADE.getName() + "] | [" + HdfsServerConstants.StartupOption.ROLLBACK.getName() + "] | [" + HdfsServerConstants.StartupOption.FINALIZE.getName() + "] | [" + HdfsServerConstants.StartupOption.IMPORT.getName() + "]");
    }

    private static HdfsServerConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsServerConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FORMAT;
                if (i + 2 >= argsLen || !args[i + 1].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) continue;
                startOpt.setClusterId(args[i += 2]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.GENCLUSTERID.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.GENCLUSTERID;
                continue;
            }
            if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BACKUP.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BACKUP;
                continue;
            }
            if (HdfsServerConstants.StartupOption.CHECKPOINT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.CHECKPOINT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.UPGRADE;
                if (i + 2 >= argsLen || !args[i + 1].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) continue;
                startOpt.setClusterId(args[i += 2]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsServerConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FINALIZE;
                continue;
            }
            if (HdfsServerConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.IMPORT;
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.toString());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsServerConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsServerConstants.StartupOption.REGULAR.toString()));
    }

    static boolean confirmPrompt(String prompt) throws IOException {
        String response;
        do {
            int c;
            System.err.print(prompt + " (Y or N) ");
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            response = responseBuilder.toString();
            if (!response.equalsIgnoreCase("y") && !response.equalsIgnoreCase("yes")) continue;
            return true;
        } while (!response.equalsIgnoreCase("n") && !response.equalsIgnoreCase("no"));
        return false;
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        HdfsServerConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if ((startOpt = NameNode.parseArguments(argv)) == null) {
            NameNode.printUsage();
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        switch (startOpt) {
            case FORMAT: {
                boolean aborted = NameNode.format(conf, true);
                ExitUtil.terminate((int)(aborted ? 1 : 0));
                return null;
            }
            case GENCLUSTERID: {
                System.err.println("Generating new cluster id:");
                System.out.println(NNStorage.newClusterID());
                ExitUtil.terminate((int)0);
                return null;
            }
            case FINALIZE: {
                boolean aborted = NameNode.finalize(conf, true);
                ExitUtil.terminate((int)(aborted ? 1 : 0));
                return null;
            }
            case BACKUP: 
            case CHECKPOINT: {
                HdfsServerConstants.NamenodeRole role = startOpt.toNodeRole();
                DefaultMetricsSystem.initialize((String)role.toString().replace(" ", ""));
                return new BackupNode(conf, role);
            }
        }
        DefaultMetricsSystem.initialize((String)"NameNode");
        return new NameNode(conf);
    }

    public static void initializeGenericKeys(Configuration conf, String nameserviceId) {
        if (nameserviceId == null || nameserviceId.isEmpty()) {
            return;
        }
        DFSUtil.setGenericConf(conf, nameserviceId, NAMESERVICE_SPECIFIC_KEYS);
        if (conf.get("dfs.namenode.rpc-address") != null) {
            URI defaultUri = URI.create("hdfs://" + conf.get("dfs.namenode.rpc-address"));
            conf.set("fs.defaultFS", defaultUri.toString());
        }
    }

    protected String getNameServiceId(Configuration conf) {
        return DFSUtil.getNamenodeNameServiceId(conf);
    }

    public static void main(String[] argv) throws Exception {
        try {
            StringUtils.startupShutdownMessage(NameNode.class, (String[])argv, (Log)LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Exception in namenode join", e);
            ExitUtil.terminate((int)1);
        }
    }

    static {
        HdfsConfiguration.init();
        NAMESERVICE_SPECIFIC_KEYS = new String[]{"dfs.namenode.rpc-address", "dfs.namenode.name.dir", "dfs.namenode.edits.dir", "dfs.namenode.checkpoint.dir", "dfs.namenode.checkpoint.edits.dir", "dfs.namenode.servicerpc-address", "dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.keytab.file", "dfs.namenode.secondary.http-address", "dfs.namenode.secondary.https-port", "dfs.secondary.namenode.keytab.file", "dfs.namenode.backup.address", "dfs.namenode.backup.http-address", "dfs.namenode.backup.dnrpc-address"};
        LOG = LogFactory.getLog((String)NameNode.class.getName());
        stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange");
        blockStateChangeLog = LogFactory.getLog((String)"BlockStateChange");
    }
}

