/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class TextEditsVisitor
extends EditsVisitor {
    private boolean printToScreen = false;
    private boolean okToWrite = false;
    private final FileWriter fw;

    public TextEditsVisitor(String filename, Tokenizer tokenizer) throws IOException {
        this(filename, tokenizer, false);
    }

    public TextEditsVisitor(String filename, Tokenizer tokenizer, boolean printToScreen) throws IOException {
        super(tokenizer);
        this.printToScreen = printToScreen;
        this.fw = new FileWriter(filename);
        this.okToWrite = true;
    }

    @Override
    void finish() throws IOException {
        this.close();
    }

    @Override
    void finishAbnormally() throws IOException {
        this.close();
    }

    private void close() throws IOException {
        this.fw.close();
        this.okToWrite = false;
    }

    protected void write(String toWrite) throws IOException {
        if (!this.okToWrite) {
            throw new IOException("file not open for writing.");
        }
        if (this.printToScreen) {
            System.out.print(toWrite);
        }
        try {
            this.fw.write(toWrite);
        }
        catch (IOException e) {
            this.okToWrite = false;
            throw e;
        }
    }
}

