/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
class DatanodeUtil {
    static final String METADATA_EXTENSION = ".meta";
    static final String UNLINK_BLOCK_SUFFIX = ".unlinked";
    private static final String DISK_ERROR = "Possible disk error on file creation: ";

    DatanodeUtil() {
    }

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    static File createTmpFile(Block b, File f) throws IOException {
        boolean fileCreated;
        if (f.exists()) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
        }
        try {
            fileCreated = f.createNewFile();
        }
        catch (IOException ioe) {
            throw (IOException)new IOException(DISK_ERROR + f).initCause(ioe);
        }
        if (!fileCreated) {
            throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
        }
        return f;
    }

    static String getMetaFileName(String blockFileName, long genStamp) {
        return blockFileName + "_" + genStamp + METADATA_EXTENSION;
    }

    static File getMetaFile(File f, long genStamp) {
        return new File(DatanodeUtil.getMetaFileName(f.getAbsolutePath(), genStamp));
    }

    static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(DatanodeUtil.METADATA_EXTENSION);
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    static File getUnlinkTmpFile(File f) {
        return new File(f.getParentFile(), f.getName() + UNLINK_BLOCK_SUFFIX);
    }
}

