/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "HBase"})
@InterfaceStability.Unstable
public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    public String getScheme() {
        return "hdfs";
    }

    @Deprecated
    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(NameNode.getUri(namenode), conf);
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        this.dfs = new DFSClient(uri, conf, this.statistics);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.dfs.ugi.getShortUserName()));
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.getFileBlockLocations(file.getPath(), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getBlockLocations(this.getPathName(p), start, len);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public boolean recoverLease(Path f) throws IOException {
        return this.dfs.recoverLease(this.getPathName(f));
    }

    public HdfsDataInputStream open(Path f, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum));
    }

    public HdfsDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.append(this.getPathName(f), bufferSize, progress, this.statistics);
    }

    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        EnumSet<CreateFlag> cflags = overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
        DFSOutputStream out = this.dfs.create(this.getPathName(f), permission, cflags, replication, blockSize, progress, bufferSize);
        return new HdfsDataOutputStream(out, this.statistics);
    }

    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum) throws IOException {
        this.statistics.incrementReadOps(1);
        return new HdfsDataOutputStream(this.dfs.primitiveCreate(this.getPathName(f), absolutePermission, flag, true, replication, blockSize, progress, bufferSize, bytesPerChecksum), this.statistics);
    }

    public HdfsDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        if (flag.contains(CreateFlag.OVERWRITE)) {
            flag.add(CreateFlag.CREATE);
        }
        return new HdfsDataOutputStream(this.dfs.create(this.getPathName(f), permission, flag, false, replication, blockSize, progress, bufferSize), this.statistics);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.setReplication(this.getPathName(src), replication);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        String[] srcs = new String[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.getPathName(psrcs[i]);
        }
        this.statistics.incrementWriteOps(1);
        this.dfs.concat(this.getPathName(trg), srcs);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.dfs.rename(this.getPathName(src), this.getPathName(dst), options);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getContentSummary(this.getPathName(f));
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.dfs.setQuota(this.getPathName(src), namespaceQuota, diskspaceQuota);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private LocatedFileStatus makeQualifiedLocated(HdfsLocatedFileStatus f, Path parent) {
        return new LocatedFileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), null, f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()), DFSUtil.locatedBlocks2Locations(f.getBlockLocations()));
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = this.makeQualified(partialListing[i], p);
            }
            this.statistics.incrementReadOps(1);
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(this.makeQualified(fileStatus, p));
        }
        this.statistics.incrementLargeReadOps(1);
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(this.makeQualified(fileStatus, p));
            }
            this.statistics.incrementLargeReadOps(1);
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path p, final PathFilter filter) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private DirectoryListing thisListing;
            private int i;
            private String src = DistributedFileSystem.access$000(DistributedFileSystem.this, p);
            private LocatedFileStatus curStat = null;
            {
                this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, HdfsFileStatus.EMPTY_NAME, true);
                DistributedFileSystem.this.statistics.incrementReadOps(1);
                if (this.thisListing == null) {
                    throw new FileNotFoundException("File " + p + " does not exist.");
                }
            }

            public boolean hasNext() throws IOException {
                while (this.curStat == null && this.hasNextNoFilter()) {
                    LocatedFileStatus next = DistributedFileSystem.this.makeQualifiedLocated((HdfsLocatedFileStatus)this.thisListing.getPartialListing()[this.i++], p);
                    if (!filter.accept(next.getPath())) continue;
                    this.curStat = next;
                }
                return this.curStat != null;
            }

            private boolean hasNextNoFilter() throws IOException {
                if (this.thisListing == null) {
                    return false;
                }
                if (this.i >= this.thisListing.getPartialListing().length && this.thisListing.hasMore()) {
                    this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, this.thisListing.getLastName(), true);
                    DistributedFileSystem.this.statistics.incrementReadOps(1);
                    if (this.thisListing == null) {
                        return false;
                    }
                    this.i = 0;
                }
                return this.i < this.thisListing.getPartialListing().length;
            }

            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    LocatedFileStatus tmp = this.curStat;
                    this.curStat = null;
                    return tmp;
                }
                throw new NoSuchElementException("No more entry in " + p);
            }
        };
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.mkdirs(this.getPathName(f), permission, false);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.mkdirs(this.getPathName(f), permission, true);
    }

    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.primitiveMkdir(this.getPathName(f), absolutePermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    @Deprecated
    @InterfaceAudience.Private
    public DFSClient getClient() {
        return this.dfs;
    }

    public FsStatus getStatus(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getDiskStatus();
    }

    @Deprecated
    public DiskStatus getDiskStatus() throws IOException {
        return new DiskStatus(this.dfs.getDiskStatus());
    }

    @Deprecated
    public long getRawCapacity() throws IOException {
        return this.dfs.getDiskStatus().getCapacity();
    }

    @Deprecated
    public long getRawUsed() throws IOException {
        return this.dfs.getDiskStatus().getUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return new CorruptFileBlockIterator(this.dfs, path);
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.getDataNodeStats(HdfsConstants.DatanodeReportType.ALL);
    }

    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.dfs.datanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.dfs.setSafeMode(action);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        return this.dfs.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        return this.dfs.distributedUpgradeProgress(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    @Deprecated
    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        if (!(in instanceof HdfsDataInputStream) || !(sums instanceof HdfsDataInputStream)) {
            throw new IllegalArgumentException("Input streams must be types of HdfsDataInputStream");
        }
        LocatedBlock[] lblocks = new LocatedBlock[2];
        HdfsDataInputStream dfsIn = (HdfsDataInputStream)in;
        ExtendedBlock dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error((Object)"Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info((Object)("Found checksum error in data stream at block=" + dataBlock + " on datanode=" + dataNode[0]));
        HdfsDataInputStream dfsSums = (HdfsDataInputStream)sums;
        ExtendedBlock sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error((Object)"Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info((Object)("Found checksum error in checksum stream at block=" + sumsBlock + " on datanode=" + sumsNode[0]));
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        HdfsFileStatus fi = this.dfs.getFileInfo(this.getPathName(f));
        if (fi != null) {
            return this.makeQualified(fi, f);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getFileChecksum(this.getPathName(f));
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.statistics.incrementWriteOps(1);
        this.dfs.setOwner(this.getPathName(p), username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.dfs.setTimes(this.getPathName(p), mtime, atime);
    }

    protected int getDefaultPort() {
        return 8020;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
        return result;
    }

    @Deprecated
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.getDelegationToken(renewer.toString());
    }

    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        ArrayList tokenList = new ArrayList();
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(renewer);
        tokenList.add(token);
        return tokenList;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            return token.renew(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        try {
            token.cancel(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.dfs.setBalancerBandwidth(bandwidth);
    }

    public String getCanonicalServiceName() {
        return this.dfs.getCanonicalServiceName();
    }

    public boolean isInSafeMode() throws IOException {
        return this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
    }

    static /* synthetic */ String access$000(DistributedFileSystem x0, Path x1) {
        return x0.getPathName(x1);
    }

    static {
        HdfsConfiguration.init();
    }

    @Deprecated
    @InterfaceAudience.Private
    public static class DiskStatus
    extends FsStatus {
        public DiskStatus(FsStatus stats) {
            super(stats.getCapacity(), stats.getUsed(), stats.getRemaining());
        }

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            super(capacity, dfsUsed, remaining);
        }

        public long getDfsUsed() {
            return super.getUsed();
        }
    }
}

