/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.CheckableNameNodeResource;

@InterfaceAudience.Private
final class NameNodeResourcePolicy {
    NameNodeResourcePolicy() {
    }

    static boolean areResourcesAvailable(Collection<? extends CheckableNameNodeResource> resources, int minimumRedundantResources) {
        int requiredResourceCount = 0;
        int redundantResourceCount = 0;
        int disabledRedundantResourceCount = 0;
        for (CheckableNameNodeResource checkableNameNodeResource : resources) {
            if (!checkableNameNodeResource.isRequired()) {
                ++redundantResourceCount;
                if (checkableNameNodeResource.isResourceAvailable()) continue;
                ++disabledRedundantResourceCount;
                continue;
            }
            ++requiredResourceCount;
            if (checkableNameNodeResource.isResourceAvailable()) continue;
            return false;
        }
        if (redundantResourceCount == 0) {
            return requiredResourceCount > 0;
        }
        return redundantResourceCount - disabledRedundantResourceCount >= minimumRedundantResources;
    }
}

