/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.HdfsVolumeId;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class BlockStorageLocationUtil {
    private static final Log LOG = LogFactory.getLog(BlockStorageLocationUtil.class);

    BlockStorageLocationUtil() {
    }

    private static List<VolumeBlockLocationCallable> createVolumeBlockLocationCallables(Configuration conf, Map<DatanodeInfo, List<LocatedBlock>> datanodeBlocks, int timeout, boolean connectToDnViaHostname) {
        ArrayList<VolumeBlockLocationCallable> callables = new ArrayList<VolumeBlockLocationCallable>();
        for (Map.Entry<DatanodeInfo, List<LocatedBlock>> entry : datanodeBlocks.entrySet()) {
            DatanodeInfo datanode = entry.getKey();
            List<LocatedBlock> locatedBlocks = entry.getValue();
            ArrayList<ExtendedBlock> extendedBlocks = new ArrayList<ExtendedBlock>(locatedBlocks.size());
            ArrayList<Token<BlockTokenIdentifier>> dnTokens = new ArrayList<Token<BlockTokenIdentifier>>(locatedBlocks.size());
            for (LocatedBlock b : locatedBlocks) {
                extendedBlocks.add(b.getBlock());
                dnTokens.add(b.getBlockToken());
            }
            VolumeBlockLocationCallable callable = new VolumeBlockLocationCallable(conf, datanode, extendedBlocks, dnTokens, timeout, connectToDnViaHostname);
            callables.add(callable);
        }
        return callables;
    }

    static List<HdfsBlocksMetadata> queryDatanodesForHdfsBlocksMetadata(Configuration conf, Map<DatanodeInfo, List<LocatedBlock>> datanodeBlocks, int poolsize, int timeout, boolean connectToDnViaHostname) throws InvalidBlockTokenException {
        int i;
        List<VolumeBlockLocationCallable> callables = BlockStorageLocationUtil.createVolumeBlockLocationCallables(conf, datanodeBlocks, timeout, connectToDnViaHostname);
        List<Object> futures = new ArrayList();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolsize);
        try {
            futures = executor.invokeAll(callables, timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        executor.shutdown();
        ArrayList<HdfsBlocksMetadata> metadatas = new ArrayList<HdfsBlocksMetadata>();
        for (i = 0; i < futures.size(); ++i) {
            metadatas.add(null);
        }
        for (i = 0; i < futures.size(); ++i) {
            Future future = (Future)futures.get(i);
            try {
                HdfsBlocksMetadata metadata = (HdfsBlocksMetadata)future.get();
                metadatas.set(i, metadata);
                continue;
            }
            catch (ExecutionException e) {
                VolumeBlockLocationCallable callable = callables.get(i);
                DatanodeInfo datanode = callable.getDatanodeInfo();
                Throwable t = e.getCause();
                if (t instanceof InvalidBlockTokenException) {
                    LOG.warn((Object)("Invalid access token when trying to retrieve information from datanode " + datanode.getIpcAddr(false)));
                    throw (InvalidBlockTokenException)t;
                }
                if (t instanceof UnsupportedOperationException) {
                    LOG.info((Object)("Datanode " + datanode.getIpcAddr(false) + " does not support" + " required #getHdfsBlocksMetadata() API"));
                    throw (UnsupportedOperationException)t;
                }
                LOG.info((Object)("Failed to connect to datanode " + datanode.getIpcAddr(false)));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Could not fetch information from datanode", t);
                continue;
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while fetching HdfsBlocksMetadata");
            }
        }
        return metadatas;
    }

    static Map<LocatedBlock, List<VolumeId>> associateVolumeIdsWithBlocks(List<LocatedBlock> blocks, Map<DatanodeInfo, List<LocatedBlock>> datanodeBlocks, List<HdfsBlocksMetadata> metadatas) {
        HashMap<ExtendedBlock, LocatedBlock> extBlockToLocBlock = new HashMap<ExtendedBlock, LocatedBlock>();
        for (LocatedBlock b : blocks) {
            extBlockToLocBlock.put(b.getBlock(), b);
        }
        HashMap<LocatedBlock, List<VolumeId>> blockVolumeIds = new HashMap<LocatedBlock, List<VolumeId>>();
        for (LocatedBlock b : blocks) {
            ArrayList<HdfsVolumeId> l = new ArrayList<HdfsVolumeId>(b.getLocations().length);
            for (int i = 0; i < b.getLocations().length; ++i) {
                l.add(new HdfsVolumeId(-1, false));
            }
            blockVolumeIds.put(b, l);
        }
        Iterator<HdfsBlocksMetadata> metadatasIter = metadatas.iterator();
        Iterator<DatanodeInfo> datanodeIter = datanodeBlocks.keySet().iterator();
        while (metadatasIter.hasNext()) {
            HdfsBlocksMetadata metadata = metadatasIter.next();
            DatanodeInfo datanode = datanodeIter.next();
            if (metadata == null) continue;
            ExtendedBlock[] metaBlocks = metadata.getBlocks();
            List<byte[]> metaVolumeIds = metadata.getVolumeIds();
            List<Integer> metaVolumeIndexes = metadata.getVolumeIndexes();
            for (int j = 0; j < metaBlocks.length; ++j) {
                int volumeIndex = metaVolumeIndexes.get(j);
                ExtendedBlock extBlock = metaBlocks[j];
                if (volumeIndex == Integer.MAX_VALUE || volumeIndex >= metaVolumeIds.size() || !extBlockToLocBlock.containsKey(extBlock)) continue;
                HdfsVolumeId id = new HdfsVolumeId(metaVolumeIds.get(volumeIndex)[0], true);
                LocatedBlock locBlock = (LocatedBlock)extBlockToLocBlock.get(extBlock);
                DatanodeInfo[] dnInfos = locBlock.getLocations();
                int index = -1;
                for (int k = 0; k < dnInfos.length; ++k) {
                    if (!dnInfos[k].equals(datanode)) continue;
                    index = k;
                    break;
                }
                if (index < 0) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Datanode responded with a block volume id we did not request, omitting.");
                    continue;
                }
                List VolumeIds = (List)blockVolumeIds.get(locBlock);
                VolumeIds.set(index, id);
            }
        }
        return blockVolumeIds;
    }

    static BlockStorageLocation[] convertToVolumeBlockLocations(List<LocatedBlock> blocks, Map<LocatedBlock, List<VolumeId>> blockVolumeIds) throws IOException {
        BlockLocation[] locations = DFSUtil.locatedBlocks2Locations(blocks);
        ArrayList<BlockStorageLocation> volumeBlockLocs = new ArrayList<BlockStorageLocation>(locations.length);
        for (int i = 0; i < locations.length; ++i) {
            LocatedBlock locBlock = blocks.get(i);
            List<VolumeId> volumeIds = blockVolumeIds.get(locBlock);
            BlockStorageLocation bsLoc = new BlockStorageLocation(locations[i], volumeIds.toArray(new VolumeId[0]));
            volumeBlockLocs.add(bsLoc);
        }
        return volumeBlockLocs.toArray(new BlockStorageLocation[0]);
    }

    private static class VolumeBlockLocationCallable
    implements Callable<HdfsBlocksMetadata> {
        private Configuration configuration;
        private int timeout;
        private DatanodeInfo datanode;
        private List<ExtendedBlock> extendedBlocks;
        private List<Token<BlockTokenIdentifier>> dnTokens;
        private boolean connectToDnViaHostname;

        VolumeBlockLocationCallable(Configuration configuration, DatanodeInfo datanode, List<ExtendedBlock> extendedBlocks, List<Token<BlockTokenIdentifier>> dnTokens, int timeout, boolean connectToDnViaHostname) {
            this.configuration = configuration;
            this.timeout = timeout;
            this.datanode = datanode;
            this.extendedBlocks = extendedBlocks;
            this.dnTokens = dnTokens;
            this.connectToDnViaHostname = connectToDnViaHostname;
        }

        public DatanodeInfo getDatanodeInfo() {
            return this.datanode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public HdfsBlocksMetadata call() throws Exception {
            HdfsBlocksMetadata metadata = null;
            ClientDatanodeProtocol cdp = null;
            try {
                cdp = DFSUtil.createClientDatanodeProtocolProxy(this.datanode, this.configuration, this.timeout, this.connectToDnViaHostname);
                metadata = cdp.getHdfsBlocksMetadata(this.extendedBlocks, this.dnTokens);
                if (cdp == null) return metadata;
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (cdp == null) throw throwable;
                    RPC.stopProxy(cdp);
                    throw throwable;
                }
            }
            RPC.stopProxy((Object)cdp);
            return metadata;
        }
    }
}

