/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeID
implements Comparable<DatanodeID> {
    public static final DatanodeID[] EMPTY_ARRAY = new DatanodeID[0];
    protected String ipAddr;
    protected String hostName;
    protected String storageID;
    protected int xferPort;
    protected int infoPort;
    protected int ipcPort;

    public DatanodeID(DatanodeID from) {
        this(from.getIpAddr(), from.getHostName(), from.getStorageID(), from.getXferPort(), from.getInfoPort(), from.getIpcPort());
    }

    public DatanodeID(String ipAddr, String hostName, String storageID, int xferPort, int infoPort, int ipcPort) {
        this.ipAddr = ipAddr;
        this.hostName = hostName;
        this.storageID = storageID;
        this.xferPort = xferPort;
        this.infoPort = infoPort;
        this.ipcPort = ipcPort;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getXferAddr() {
        return this.ipAddr + ":" + this.xferPort;
    }

    private String getIpcAddr() {
        return this.ipAddr + ":" + this.ipcPort;
    }

    public String getInfoAddr() {
        return this.ipAddr + ":" + this.infoPort;
    }

    public String getXferAddrWithHostname() {
        return this.hostName + ":" + this.xferPort;
    }

    private String getIpcAddrWithHostname() {
        return this.hostName + ":" + this.ipcPort;
    }

    public String getXferAddr(boolean useHostname) {
        return useHostname ? this.getXferAddrWithHostname() : this.getXferAddr();
    }

    public String getIpcAddr(boolean useHostname) {
        return useHostname ? this.getIpcAddrWithHostname() : this.getIpcAddr();
    }

    public String getStorageID() {
        return this.storageID;
    }

    public int getXferPort() {
        return this.xferPort;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (!(to instanceof DatanodeID)) {
            return false;
        }
        return this.getXferAddr().equals(((DatanodeID)to).getXferAddr()) && this.storageID.equals(((DatanodeID)to).getStorageID());
    }

    public int hashCode() {
        return this.getXferAddr().hashCode() ^ this.storageID.hashCode();
    }

    public String toString() {
        return this.getXferAddr();
    }

    public void updateRegInfo(DatanodeID nodeReg) {
        this.ipAddr = nodeReg.getIpAddr();
        this.hostName = nodeReg.getHostName();
        this.xferPort = nodeReg.getXferPort();
        this.infoPort = nodeReg.getInfoPort();
        this.ipcPort = nodeReg.getIpcPort();
    }

    @Override
    public int compareTo(DatanodeID that) {
        return this.getXferAddr().compareTo(that.getXferAddr());
    }
}

