/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientDatanodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientDatanodeProtocol,
ProtocolTranslator,
Closeable {
    public static final Log LOG = LogFactory.getLog(ClientDatanodeProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private final ClientDatanodeProtocolPB rpcProxy;
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto REFRESH_NAMENODES = ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto.newBuilder().build();

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public ClientDatanodeProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, conf, factory, 0);
    }

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to datanode " + dnAddr + " addr=" + addr));
        }
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to datanode " + dnAddr + " addr=" + addr));
        }
        Configuration confWithNoIpcIdle = new Configuration(conf);
        confWithNoIpcIdle.setInt("ipc.client.connection.maxidletime", 0);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)locatedBlock.getBlock().getLocalBlock().toString());
        ticket.addToken(locatedBlock.getBlockToken());
        return ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, confWithNoIpcIdle, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        return (ClientDatanodeProtocolPB)RPC.getProxy(ClientDatanodeProtocolPB.class, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)factory, (int)socketTimeout);
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock b) throws IOException {
        ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto req = ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto.newBuilder().setBlock(PBHelper.convert(b)).build();
        try {
            return this.rpcProxy.getReplicaVisibleLength(NULL_CONTROLLER, req).getLength();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void refreshNamenodes() throws IOException {
        try {
            this.rpcProxy.refreshNamenodes(NULL_CONTROLLER, REFRESH_NAMENODES);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void deleteBlockPool(String bpid, boolean force) throws IOException {
        ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto req = ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto.newBuilder().setBlockPool(bpid).setForce(force).build();
        try {
            this.rpcProxy.deleteBlockPool(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto resp;
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto req = ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto.newBuilder().setBlock(PBHelper.convert(block)).setToken(PBHelper.convert(token)).build();
        try {
            resp = this.rpcProxy.getBlockLocalPathInfo(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        return new BlockLocalPathInfo(PBHelper.convert(resp.getBlock()), resp.getLocalPath(), resp.getLocalMetaPath());
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ClientDatanodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (String)methodName);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public HdfsBlocksMetadata getHdfsBlocksMetadata(List<ExtendedBlock> blocks, List<Token<BlockTokenIdentifier>> tokens) throws IOException {
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto getHdfsBlockLocationsResponseProto;
        ArrayList<HdfsProtos.ExtendedBlockProto> blocksProtos = new ArrayList<HdfsProtos.ExtendedBlockProto>(blocks.size());
        ArrayList<HdfsProtos.BlockTokenIdentifierProto> tokensProtos = new ArrayList<HdfsProtos.BlockTokenIdentifierProto>(tokens.size());
        for (ExtendedBlock extendedBlock : blocks) {
            blocksProtos.add(PBHelper.convert(extendedBlock));
        }
        for (Token token : tokens) {
            tokensProtos.add(PBHelper.convert(token));
        }
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto request = ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto.newBuilder().addAllBlocks(blocksProtos).addAllTokens(tokensProtos).build();
        try {
            getHdfsBlockLocationsResponseProto = this.rpcProxy.getHdfsBlockLocations(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        List<ByteString> volumeIdsByteStrings = getHdfsBlockLocationsResponseProto.getVolumeIdsList();
        ArrayList<byte[]> volumeIds = new ArrayList<byte[]>(volumeIdsByteStrings.size());
        for (ByteString bs : volumeIdsByteStrings) {
            volumeIds.add(bs.toByteArray());
        }
        List<Integer> volumeIndexes = getHdfsBlockLocationsResponseProto.getVolumeIndexesList();
        return new HdfsBlocksMetadata(blocks.toArray(new ExtendedBlock[0]), volumeIds, volumeIndexes);
    }
}

