/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;

@InterfaceAudience.Private
class InvalidateBlocks {
    private final Map<String, LightWeightHashSet<Block>> node2blocks = new TreeMap<String, LightWeightHashSet<Block>>();
    private long numBlocks = 0L;
    private final DatanodeManager datanodeManager;

    InvalidateBlocks(DatanodeManager datanodeManager) {
        this.datanodeManager = datanodeManager;
    }

    synchronized long numBlocks() {
        return this.numBlocks;
    }

    synchronized boolean contains(String storageID, Block block) {
        LightWeightHashSet<Block> s = this.node2blocks.get(storageID);
        if (s == null) {
            return false;
        }
        Block blockInSet = s.getElement(block);
        return blockInSet != null && block.getGenerationStamp() == blockInSet.getGenerationStamp();
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log) {
        LightWeightHashSet<Block> set = this.node2blocks.get(datanode.getStorageID());
        if (set == null) {
            set = new LightWeightHashSet();
            this.node2blocks.put(datanode.getStorageID(), set);
        }
        if (set.add(block)) {
            ++this.numBlocks;
            if (log) {
                NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + datanode));
            }
        }
    }

    synchronized void remove(String storageID) {
        LightWeightHashSet<Block> blocks = this.node2blocks.remove(storageID);
        if (blocks != null) {
            this.numBlocks -= (long)blocks.size();
        }
    }

    synchronized void remove(String storageID, Block block) {
        LightWeightHashSet<Block> v = this.node2blocks.get(storageID);
        if (v != null && v.remove(block)) {
            --this.numBlocks;
            if (v.isEmpty()) {
                this.node2blocks.remove(storageID);
            }
        }
    }

    synchronized void dump(PrintWriter out) {
        int size = this.node2blocks.values().size();
        out.println("Metasave: Blocks " + this.numBlocks + " waiting deletion from " + size + " datanodes.");
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, LightWeightHashSet<Block>> entry : this.node2blocks.entrySet()) {
            LightWeightHashSet<Block> blocks = entry.getValue();
            if (blocks.size() <= 0) continue;
            out.println(this.datanodeManager.getDatanode(entry.getKey()));
            out.println(blocks);
        }
    }

    synchronized List<String> getStorageIDs() {
        return new ArrayList<String>(this.node2blocks.keySet());
    }

    int invalidateWork(String storageId) {
        DatanodeDescriptor dn = this.datanodeManager.getDatanode(storageId);
        if (dn == null) {
            this.remove(storageId);
            return 0;
        }
        List<Block> toInvalidate = this.invalidateWork(storageId, dn);
        if (toInvalidate == null) {
            return 0;
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": ask " + dn + " to delete " + toInvalidate));
        }
        return toInvalidate.size();
    }

    private synchronized List<Block> invalidateWork(String storageId, DatanodeDescriptor dn) {
        LightWeightHashSet<Block> set = this.node2blocks.get(storageId);
        if (set == null) {
            return null;
        }
        int limit = this.datanodeManager.blockInvalidateLimit;
        List<Block> toInvalidate = set.pollN(limit);
        if (set.isEmpty()) {
            this.remove(storageId);
        }
        dn.addBlocksToBeInvalidated(toInvalidate);
        this.numBlocks -= (long)toInvalidate.size();
        return toInvalidate;
    }

    synchronized void clear() {
        this.node2blocks.clear();
        this.numBlocks = 0L;
    }
}

