/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;

class FsVolumeList {
    volatile List<FsVolumeImpl> volumes = null;
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private volatile int numFailedVolumes;

    FsVolumeList(List<FsVolumeImpl> volumes, int failedVols, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.volumes = Collections.unmodifiableList(volumes);
        this.blockChooser = blockChooser;
        this.numFailedVolumes = failedVols;
    }

    int numberOfFailedVolumes() {
        return this.numFailedVolumes;
    }

    synchronized FsVolumeImpl getNextVolume(long blockSize) throws IOException {
        return this.blockChooser.chooseVolume(this.volumes, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getDfsUsed();
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getBlockPoolUsed(bpid);
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes) {
            capacity += v.getCapacity();
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeImpl vol : this.volumes) {
            remaining += vol.getAvailable();
        }
        return remaining;
    }

    void getVolumeMap(ReplicaMap volumeMap) throws IOException {
        for (FsVolumeImpl v : this.volumes) {
            v.getVolumeMap(volumeMap);
        }
    }

    void getVolumeMap(String bpid, ReplicaMap volumeMap) throws IOException {
        for (FsVolumeImpl v : this.volumes) {
            v.getVolumeMap(bpid, volumeMap);
        }
    }

    synchronized List<FsVolumeImpl> checkDirs() {
        ArrayList<FsVolumeImpl> removedVols = null;
        ArrayList<FsVolumeImpl> volumeList = new ArrayList<FsVolumeImpl>(this.volumes);
        Iterator i = volumeList.iterator();
        while (i.hasNext()) {
            FsVolumeImpl fsv = (FsVolumeImpl)i.next();
            try {
                fsv.checkDirs();
            }
            catch (DiskChecker.DiskErrorException e) {
                FsDatasetImpl.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                if (removedVols == null) {
                    removedVols = new ArrayList<FsVolumeImpl>(1);
                }
                removedVols.add(fsv);
                fsv.shutdown();
                i.remove();
                ++this.numFailedVolumes;
            }
        }
        if (removedVols != null && removedVols.size() > 0) {
            this.volumes = Collections.unmodifiableList(volumeList);
            FsDatasetImpl.LOG.warn((Object)("Completed checkDirs. Removed " + removedVols.size() + " volumes. Current volumes: " + this));
        }
        return removedVols;
    }

    public String toString() {
        return this.volumes.toString();
    }

    void addBlockPool(String bpid, Configuration conf) throws IOException {
        for (FsVolumeImpl v : this.volumes) {
            v.addBlockPool(bpid, conf);
        }
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

