/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.MutableBlockCollection;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

@InterfaceAudience.Private
class INodeFileUnderConstruction
extends INodeFile
implements MutableBlockCollection {
    private String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;

    public static INodeFileUnderConstruction valueOf(INode inode, String path) throws IOException {
        INodeFile file = INodeFile.valueOf(inode, path);
        if (!file.isUnderConstruction()) {
            throw new IOException("File is not under construction: " + path);
        }
        return (INodeFileUnderConstruction)file;
    }

    INodeFileUnderConstruction(PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(permissions.applyUMask(UMASK), BlockInfo.EMPTY_ARRAY, replication, modTime, modTime, preferredBlockSize);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    INodeFileUnderConstruction(byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(perm, blocks, blockReplication, modificationTime, modificationTime, preferredBlockSize);
        this.setLocalName(name);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    String getClientMachine() {
        return this.clientMachine;
    }

    DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    @Override
    public boolean isUnderConstruction() {
        return true;
    }

    INodeFile convertToInodeFile() {
        assert (this.allBlocksComplete()) : "Can't finalize inode " + this + " since it contains non-complete blocks! Blocks are " + Arrays.asList(this.getBlocks());
        INodeFile obj = new INodeFile(this.getPermissionStatus(), this.getBlocks(), this.getBlockReplication(), this.getModificationTime(), this.getModificationTime(), this.getPreferredBlockSize());
        return obj;
    }

    private boolean allBlocksComplete() {
        for (BlockInfo b : this.getBlocks()) {
            if (b.isComplete()) continue;
            return false;
        }
        return true;
    }

    void removeLastBlock(Block oldblock) throws IOException {
        BlockInfo[] blocks = this.getBlocks();
        if (blocks == null) {
            throw new IOException("Trying to delete non-existant block " + oldblock);
        }
        int size_1 = blocks.length - 1;
        if (!blocks[size_1].equals(oldblock)) {
            throw new IOException("Trying to delete non-last block " + oldblock);
        }
        BlockInfo[] newlist = new BlockInfo[size_1];
        System.arraycopy(blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
    }

    @Override
    public BlockInfoUnderConstruction setLastBlock(BlockInfo lastBlock, DatanodeDescriptor[] targets) throws IOException {
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
        ucBlock.setBlockCollection(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    void updateLengthOfLastBlock(long lastBlockLength) throws IOException {
        BlockInfo lastBlock = this.getLastBlock();
        assert (lastBlock != null) : "The last block for path " + this.getFullPathName() + " is null when updating its length";
        assert (lastBlock instanceof BlockInfoUnderConstruction) : "The last block for path " + this.getFullPathName() + " is not a BlockInfoUnderConstruction when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }
}

