/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.RemoteBlockReader;
import org.apache.hadoop.hdfs.RemoteBlockReader2;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferEncryptor;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class BlockReaderFactory {
    public static BlockReader newBlockReader(Configuration conf, Socket sock, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, DataEncryptionKey encryptionKey) throws IOException {
        int bufferSize = conf.getInt("io.file.buffer.size", 4096);
        return BlockReaderFactory.newBlockReader(new DFSClient.Conf(conf), sock, file, block, blockToken, startOffset, len, bufferSize, true, "", encryptionKey, null);
    }

    public static BlockReader newBlockReader(DFSClient.Conf conf, Socket sock, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName, DataEncryptionKey encryptionKey, IOStreamPair ioStreams) throws IOException {
        if (conf.useLegacyBlockReader) {
            if (encryptionKey != null) {
                throw new RuntimeException("Encryption is not supported with the legacy block reader.");
            }
            return RemoteBlockReader.newBlockReader(sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName);
        }
        if (ioStreams == null) {
            ioStreams = new IOStreamPair((InputStream)NetUtils.getInputStream((Socket)sock), NetUtils.getOutputStream((Socket)sock, (long)HdfsServerConstants.WRITE_TIMEOUT));
            if (encryptionKey != null) {
                IOStreamPair encryptedStreams;
                ioStreams = encryptedStreams = DataTransferEncryptor.getEncryptedStreams(ioStreams.out, ioStreams.in, encryptionKey);
            }
        }
        return RemoteBlockReader2.newBlockReader(sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName, encryptionKey, ioStreams);
    }

    public static String getFileName(InetSocketAddress s, String poolId, long blockId) {
        return s.toString() + ":" + poolId + ":" + blockId;
    }
}

