/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
public class DelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(DelegationTokenSecretManager.class);
    private final FSNamesystem namesystem;

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.namesystem = namesystem;
    }

    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAvailableForRead() throws StandbyException {
        this.namesystem.readLock();
        try {
            this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        }
        finally {
            this.namesystem.readUnlock();
        }
    }

    public synchronized long getTokenExpiryTime(DelegationTokenIdentifier dtId) throws IOException {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get((Object)dtId);
        if (info != null) {
            return info.getRenewDate();
        }
        throw new IOException("No delegation token found for this identifier");
    }

    public synchronized void loadSecretManagerState(DataInputStream in) throws IOException {
        if (this.running) {
            throw new IOException("Can't load state from image in a running SecretManager.");
        }
        this.currentId = in.readInt();
        this.loadAllKeys(in);
        this.delegationTokenSequenceNumber = in.readInt();
        this.loadCurrentTokens(in);
    }

    public synchronized void saveSecretManagerState(DataOutputStream out) throws IOException {
        out.writeInt(this.currentId);
        this.saveAllKeys(out);
        out.writeInt(this.delegationTokenSequenceNumber);
        this.saveCurrentTokens(out);
    }

    public synchronized void addPersistedDelegationToken(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't add persisted delegation token to a running SecretManager.");
        }
        int keyId = identifier.getMasterKeyId();
        DelegationKey dKey = (DelegationKey)this.allKeys.get(keyId);
        if (dKey == null) {
            LOG.warn((Object)("No KEY found for persisted identifier " + identifier.toString()));
            return;
        }
        byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)dKey.getKey());
        if (identifier.getSequenceNumber() > this.delegationTokenSequenceNumber) {
            this.delegationTokenSequenceNumber = identifier.getSequenceNumber();
        }
        if (this.currentTokens.get((Object)identifier) != null) {
            throw new IOException("Same delegation token being added twice; invalid entry in fsimage or editlogs");
        }
        this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password));
    }

    public synchronized void updatePersistedMasterKey(DelegationKey key) throws IOException {
        this.addKey(key);
    }

    public synchronized void updatePersistedTokenRenewal(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = null;
        info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get((Object)identifier);
        if (info != null) {
            int keyId = identifier.getMasterKeyId();
            byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)((DelegationKey)this.allKeys.get(keyId)).getKey());
            this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password));
        }
    }

    public synchronized void updatePersistedTokenCancellation(DelegationTokenIdentifier identifier) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        this.currentTokens.remove((Object)identifier);
    }

    public synchronized int getNumberOfKeys() {
        return this.allKeys.size();
    }

    private synchronized void saveCurrentTokens(DataOutputStream out) throws IOException {
        out.writeInt(this.currentTokens.size());
        for (DelegationTokenIdentifier id : this.currentTokens.keySet()) {
            id.write(out);
            AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get((Object)id);
            out.writeLong(info.getRenewDate());
        }
    }

    private synchronized void saveAllKeys(DataOutputStream out) throws IOException {
        out.writeInt(this.allKeys.size());
        for (Integer key : this.allKeys.keySet()) {
            ((DelegationKey)this.allKeys.get(key)).write((DataOutput)out);
        }
    }

    private synchronized void loadCurrentTokens(DataInputStream in) throws IOException {
        int numberOfTokens = in.readInt();
        for (int i = 0; i < numberOfTokens; ++i) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            id.readFields(in);
            long expiryTime = in.readLong();
            this.addPersistedDelegationToken(id, expiryTime);
        }
    }

    private synchronized void loadAllKeys(DataInputStream in) throws IOException {
        int numberOfKeys = in.readInt();
        for (int i = 0; i < numberOfKeys; ++i) {
            DelegationKey value = new DelegationKey();
            value.readFields((DataInput)in);
            this.addKey(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
        Object object = this.noInterruptsLock;
        synchronized (object) {
            if (Thread.interrupted()) {
                throw new InterruptedIOException("Interrupted before updating master key");
            }
            this.namesystem.logUpdateMasterKey(key);
        }
    }

    public static Credentials createCredentials(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = namenode.getRpcServer().getDelegationToken(new Text(renewer));
        if (token == null) {
            throw new IOException("Failed to get the token for " + renewer + ", user=" + ugi.getShortUserName());
        }
        InetSocketAddress addr = namenode.getNameNodeAddress();
        SecurityUtil.setTokenService(token, (InetSocketAddress)addr);
        Credentials c = new Credentials();
        c.addToken(new Text(ugi.getShortUserName()), token);
        return c;
    }
}

