/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestBlocksScheduledCounter {
    MiniDFSCluster cluster = null;
    FileSystem fs = null;

    @After
    public void tearDown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testBlocksScheduledCounter() throws IOException {
        this.cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        FSDataOutputStream out = this.fs.create(new Path("/testBlockScheduledCounter"));
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.hflush();
        ArrayList dnList = new ArrayList();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        dm.fetchDatanodes(dnList, dnList, false);
        DatanodeDescriptor dn = (DatanodeDescriptor)dnList.get(0);
        Assert.assertEquals((long)1L, (long)dn.getBlocksScheduled());
        out.close();
        Assert.assertEquals((long)0L, (long)dn.getBlocksScheduled());
    }

    @Test
    public void testScheduledBlocksCounterShouldDecrementOnAbandonBlock() throws Exception {
        this.cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(2).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        DatanodeManager datanodeManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        ArrayList dnList = new ArrayList();
        datanodeManager.fetchDatanodes(dnList, dnList, false);
        for (DatanodeDescriptor descriptor : dnList) {
            Assert.assertEquals((String)("Blocks scheduled should be 0 for " + descriptor.getName()), (long)0L, (long)descriptor.getBlocksScheduled());
        }
        this.cluster.getDataNodes().get(0).shutdown();
        FSDataOutputStream out = this.fs.create(new Path("/testBlockScheduledCounter"), (short)2);
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.hflush();
        DatanodeDescriptor abandonedDn = datanodeManager.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        Assert.assertEquals((String)"for the abandoned dn scheduled counts should be 0", (long)0L, (long)abandonedDn.getBlocksScheduled());
        for (DatanodeDescriptor descriptor : dnList) {
            if (descriptor.equals((Object)abandonedDn)) continue;
            Assert.assertEquals((String)("Blocks scheduled should be 1 for " + descriptor.getName()), (long)1L, (long)descriptor.getBlocksScheduled());
        }
        out.close();
        for (DatanodeDescriptor descriptor : dnList) {
            Assert.assertEquals((String)("Blocks scheduled should be 0 for " + descriptor.getName()), (long)0L, (long)descriptor.getBlocksScheduled());
        }
    }
}

