/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;

@InterfaceAudience.Private
class InvalidateBlocks {
    private final Map<DatanodeInfo, LightWeightHashSet<Block>> node2blocks = new TreeMap<DatanodeInfo, LightWeightHashSet<Block>>();
    private long numBlocks = 0L;
    private final int blockInvalidateLimit;

    InvalidateBlocks(int blockInvalidateLimit) {
        this.blockInvalidateLimit = blockInvalidateLimit;
    }

    synchronized long numBlocks() {
        return this.numBlocks;
    }

    synchronized boolean contains(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> s = this.node2blocks.get(dn);
        if (s == null) {
            return false;
        }
        Block blockInSet = s.getElement(block);
        return blockInSet != null && block.getGenerationStamp() == blockInSet.getGenerationStamp();
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log) {
        LightWeightHashSet<Block> set = this.node2blocks.get(datanode);
        if (set == null) {
            set = new LightWeightHashSet();
            this.node2blocks.put(datanode, set);
        }
        if (set.add(block)) {
            ++this.numBlocks;
            if (log) {
                NameNode.blockStateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + datanode));
            }
        }
    }

    synchronized void remove(DatanodeInfo dn) {
        LightWeightHashSet<Block> blocks = this.node2blocks.remove(dn);
        if (blocks != null) {
            this.numBlocks -= (long)blocks.size();
        }
    }

    synchronized void remove(DatanodeInfo dn, Block block) {
        LightWeightHashSet<Block> v = this.node2blocks.get(dn);
        if (v != null && v.remove(block)) {
            --this.numBlocks;
            if (v.isEmpty()) {
                this.node2blocks.remove(dn);
            }
        }
    }

    synchronized void dump(PrintWriter out) {
        int size = this.node2blocks.values().size();
        out.println("Metasave: Blocks " + this.numBlocks + " waiting deletion from " + size + " datanodes.");
        if (size == 0) {
            return;
        }
        for (Map.Entry<DatanodeInfo, LightWeightHashSet<Block>> entry : this.node2blocks.entrySet()) {
            LightWeightHashSet<Block> blocks = entry.getValue();
            if (blocks.size() <= 0) continue;
            out.println(entry.getKey());
            out.println(blocks);
        }
    }

    synchronized List<DatanodeInfo> getDatanodes() {
        return new ArrayList<DatanodeInfo>(this.node2blocks.keySet());
    }

    synchronized List<Block> invalidateWork(DatanodeDescriptor dn) {
        LightWeightHashSet<Block> set = this.node2blocks.get(dn);
        if (set == null) {
            return null;
        }
        int limit = this.blockInvalidateLimit;
        List<Block> toInvalidate = set.pollN(limit);
        if (set.isEmpty()) {
            this.remove(dn);
        }
        dn.addBlocksToBeInvalidated(toInvalidate);
        this.numBlocks -= (long)toInvalidate.size();
        return toInvalidate;
    }

    synchronized void clear() {
        this.node2blocks.clear();
        this.numBlocks = 0L;
    }
}

