/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

@InterfaceAudience.Private
public class FileUnderConstructionFeature
implements INode.Feature {
    private String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;

    public FileUnderConstructionFeature(String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    void updateLengthOfLastBlock(INodeFile f, long lastBlockLength) throws IOException {
        BlockInfo lastBlock = f.getLastBlock();
        assert (lastBlock != null) : "The last block for path " + f.getFullPathName() + " is null when updating its length";
        assert (lastBlock instanceof BlockInfoUnderConstruction) : "The last block for path " + f.getFullPathName() + " is not a BlockInfoUnderConstruction when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }

    void cleanZeroSizeBlock(INodeFile f, INode.BlocksMapUpdateInfo collectedBlocks) {
        BlockInfoUnderConstruction lastUC;
        BlockInfo[] blocks = f.getBlocks();
        if (blocks != null && blocks.length > 0 && blocks[blocks.length - 1] instanceof BlockInfoUnderConstruction && (lastUC = (BlockInfoUnderConstruction)blocks[blocks.length - 1]).getNumBytes() == 0L) {
            collectedBlocks.addDeleteBlock(lastUC);
            f.removeLastBlock(lastUC);
        }
    }
}

