/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBootstrapStandbyWithQJM {
    private MiniQJMHACluster miniQjmHaCluster;
    private MiniDFSCluster cluster;
    private MiniJournalCluster jCluster;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.miniQjmHaCluster = new MiniQJMHACluster.Builder(conf).build();
        this.cluster = this.miniQjmHaCluster.getDfsCluster();
        this.jCluster = this.miniQjmHaCluster.getJournalCluster();
        this.cluster.transitionToActive(0);
        DistributedFileSystem dfs = (DistributedFileSystem)HATestUtil.configureFailoverFs(this.cluster, conf);
        dfs.mkdirs(new Path("/test2"));
        dfs.close();
    }

    @After
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.jCluster != null) {
            this.jCluster.shutdown();
        }
    }

    @Test
    public void testBootstrapStandbyWithStandbyNN() throws Exception {
        this.cluster.transitionToStandby(0);
        Configuration confNN1 = this.cluster.getConfiguration(1);
        this.cluster.shutdownNameNode(1);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)confNN1);
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
    }

    @Test
    public void testBootstrapStandbyWithActiveNN() throws Exception {
        this.cluster.transitionToActive(0);
        Configuration confNN1 = this.cluster.getConfiguration(1);
        this.cluster.shutdownNameNode(1);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)confNN1);
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
    }
}

