/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestByteRangeInputStream {
    @Test
    public void testByteRange() throws IOException {
        URLConnectionFactory factory = (URLConnectionFactory)Mockito.mock(URLConnectionFactory.class);
        HftpFileSystem.RangeHeaderUrlOpener ospy = (HftpFileSystem.RangeHeaderUrlOpener)Mockito.spy((Object)new HftpFileSystem.RangeHeaderUrlOpener(factory, new URL("http://test/")));
        ((HftpFileSystem.RangeHeaderUrlOpener)Mockito.doReturn((Object)new MockHttpURLConnection(ospy.getURL())).when((Object)ospy)).openConnection();
        HftpFileSystem.RangeHeaderUrlOpener rspy = (HftpFileSystem.RangeHeaderUrlOpener)Mockito.spy((Object)new HftpFileSystem.RangeHeaderUrlOpener(factory, null));
        ((HftpFileSystem.RangeHeaderUrlOpener)Mockito.doReturn((Object)new MockHttpURLConnection(rspy.getURL())).when((Object)rspy)).openConnection();
        HftpFileSystem.RangeHeaderInputStream is = new HftpFileSystem.RangeHeaderInputStream(ospy, rspy);
        Assert.assertEquals((String)"getPos wrong", (long)0L, (long)is.getPos());
        is.read();
        Assert.assertNull((String)"Initial call made incorrectly (Range Check)", (Object)ospy.openConnection().getRequestProperty("Range"));
        Assert.assertEquals((String)"getPos should be 1 after reading one byte", (long)1L, (long)is.getPos());
        is.read();
        Assert.assertEquals((String)"getPos should be 2 after reading two bytes", (long)2L, (long)is.getPos());
        rspy.setURL(new URL("http://resolvedurl/"));
        is.seek(100L);
        is.read();
        Assert.assertEquals((String)"Seek to 100 bytes made incorrectly (Range Check)", (Object)"bytes=100-", (Object)rspy.openConnection().getRequestProperty("Range"));
        Assert.assertEquals((String)"getPos should be 101 after reading one byte", (long)101L, (long)is.getPos());
        ((HftpFileSystem.RangeHeaderUrlOpener)Mockito.verify((Object)rspy, (VerificationMode)Mockito.times((int)2))).openConnection();
        is.seek(101L);
        is.read();
        ((HftpFileSystem.RangeHeaderUrlOpener)Mockito.verify((Object)rspy, (VerificationMode)Mockito.times((int)2))).openConnection();
        is.seek(2500L);
        is.read();
        Assert.assertEquals((String)"Seek to 2500 bytes made incorrectly (Range Check)", (Object)"bytes=2500-", (Object)rspy.openConnection().getRequestProperty("Range"));
        ((MockHttpURLConnection)rspy.openConnection()).setResponseCode(200);
        is.seek(500L);
        try {
            is.read();
            Assert.fail((String)"Exception should be thrown when 200 response is given but 206 is expected");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Should fail because incorrect response code was sent", (Object)"HTTP_PARTIAL expected, received 200", (Object)e.getMessage());
        }
        ((MockHttpURLConnection)rspy.openConnection()).setResponseCode(206);
        is.seek(0L);
        try {
            is.read();
            Assert.fail((String)"Exception should be thrown when 206 response is given but 200 is expected");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Should fail because incorrect response code was sent", (Object)"HTTP_OK expected, received 206", (Object)e.getMessage());
        }
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropagatedClose() throws IOException {
        URLConnectionFactory factory = (URLConnectionFactory)Mockito.mock(URLConnectionFactory.class);
        ByteRangeInputStream brs = (ByteRangeInputStream)Mockito.spy((Object)new HftpFileSystem.RangeHeaderInputStream(factory, new URL("http://test/")));
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        ((ByteRangeInputStream)Mockito.doReturn((Object)mockStream).when((Object)brs)).openInputStream();
        int brisOpens = 0;
        int brisCloses = 0;
        int isCloses = 0;
        brs.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
        brs.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
        brs.seek(1L);
        brs.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)(++brisOpens)))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        brs.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
        brs.seek(1L);
        brs.getInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
        brs.close();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)(++isCloses)))).close();
        brs.close();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)(++brisCloses)))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
        boolean errored = false;
        try {
            brs.getInputStream();
        }
        catch (IOException e) {
            errored = true;
            Assert.assertEquals((Object)"Stream closed", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((String)"Read a closed steam", (boolean)errored);
        }
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisOpens))).openInputStream();
        ((ByteRangeInputStream)Mockito.verify((Object)brs, (VerificationMode)Mockito.times((int)brisCloses))).close();
        ((InputStream)Mockito.verify((Object)mockStream, (VerificationMode)Mockito.times((int)isCloses))).close();
    }

    public static class MockHttpURLConnection
    extends HttpURLConnection {
        public MockHttpURLConnection(URL u) {
            super(u);
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void disconnect() {
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream("asdf".getBytes());
        }

        @Override
        public URL getURL() {
            URL u = null;
            try {
                u = new URL("http://resolvedurl/");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return u;
        }

        @Override
        public int getResponseCode() {
            if (this.responseCode != -1) {
                return this.responseCode;
            }
            if (this.getRequestProperty("Range") == null) {
                return 200;
            }
            return 206;
        }

        public void setResponseCode(int resCode) {
            this.responseCode = resCode;
        }

        @Override
        public String getHeaderField(String field) {
            return field.equalsIgnoreCase("Content-Length") ? "65535" : null;
        }
    }
}

