/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodePrunesMissingStorages {
    static final Log LOG = LogFactory.getLog(TestNameNodePrunesMissingStorages.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(String testCaseName, boolean createFiles, int numInitialStorages, int expectedStoragesAfterTest) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storagesPerDatanode(numInitialStorages).build();
            cluster.waitActive();
            DataNode dn0 = cluster.getDataNodes().get(0);
            DatanodeID dnId = dn0.getDatanodeId();
            DatanodeDescriptor dnDescriptor = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dnId);
            Assert.assertThat((Object)dnDescriptor.getStorageInfos().length, (Matcher)Is.is((Object)numInitialStorages));
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration dnReg = dn0.getDNRegistrationForBP(bpid);
            DataNodeTestUtils.triggerBlockReport(dn0);
            if (createFiles) {
                Path path = new Path("/", testCaseName);
                DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), path, 1024L, (short)1, 464346861L);
                DataNodeTestUtils.triggerBlockReport(dn0);
            }
            StorageReport[] reports = dn0.getFSDataset().getStorageReports(bpid);
            StorageReport[] prunedReports = new StorageReport[numInitialStorages - 1];
            System.arraycopy(reports, 0, prunedReports, 0, prunedReports.length);
            cluster.stopDataNode(0);
            cluster.getNameNodeRpc().sendHeartbeat(dnReg, prunedReports, 0L, 0L, 0, 0, 0);
            Assert.assertThat((Object)dnDescriptor.getStorageInfos().length, (Matcher)Is.is((Object)expectedStoragesAfterTest));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testUnusedStorageIsPruned() throws IOException {
        TestNameNodePrunesMissingStorages.runTest(GenericTestUtils.getMethodName(), false, 1, 0);
    }

    @Test(timeout=300000L)
    public void testStorageWithBlocksIsNotPruned() throws IOException {
        TestNameNodePrunesMissingStorages.runTest(GenericTestUtils.getMethodName(), true, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRemovingStorageDoesNotProduceZombies() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        int NUM_STORAGES_PER_DN = 2;
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storagesPerDatanode(2).build();
        try {
            DataNode datanodeToRemoveStorageFrom;
            String datanodeUuid;
            String storageIdToRemove;
            cluster.waitActive();
            for (DataNode dn : cluster.getDataNodes()) {
                Assert.assertEquals((long)2L, (long)cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).getStorageInfos().length);
            }
            Path TEST_PATH = new Path("/foo1");
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 1024L, (short)3, -889271554L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.triggerBlockReport(dn);
            }
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, new Path("/foo1"));
            cluster.getNamesystem().writeLock();
            try {
                Iterator storageInfoIter = cluster.getNamesystem().getBlockManager().getStorages(block.getLocalBlock()).iterator();
                Assert.assertTrue((boolean)storageInfoIter.hasNext());
                DatanodeStorageInfo info = (DatanodeStorageInfo)storageInfoIter.next();
                storageIdToRemove = info.getStorageID();
                datanodeUuid = info.getDatanodeDescriptor().getDatanodeUuid();
            }
            finally {
                cluster.getNamesystem().writeUnlock();
            }
            int datanodeToRemoveStorageFromIdx = 0;
            while (true) {
                if (datanodeToRemoveStorageFromIdx >= cluster.getDataNodes().size()) {
                    Assert.fail((String)("failed to find datanode with uuid " + datanodeUuid));
                    datanodeToRemoveStorageFrom = null;
                    break;
                }
                DataNode dn = cluster.getDataNodes().get(datanodeToRemoveStorageFromIdx);
                if (dn.getDatanodeUuid().equals(datanodeUuid)) {
                    datanodeToRemoveStorageFrom = dn;
                    break;
                }
                ++datanodeToRemoveStorageFromIdx;
            }
            List volumes = datanodeToRemoveStorageFrom.getFSDataset().getVolumes();
            Assert.assertEquals((long)2L, (long)volumes.size());
            String volumeDirectoryToRemove = null;
            for (FsVolumeSpi volume : volumes) {
                if (!volume.getStorageID().equals(storageIdToRemove)) continue;
                volumeDirectoryToRemove = volume.getBasePath();
            }
            Assert.assertNotNull(volumeDirectoryToRemove);
            datanodeToRemoveStorageFrom.shutdown();
            FileUtil.fullyDelete((File)new File(volumeDirectoryToRemove));
            FileOutputStream fos = new FileOutputStream(volumeDirectoryToRemove);
            try {
                fos.write(1);
            }
            finally {
                fos.close();
            }
            cluster.restartDataNode(datanodeToRemoveStorageFromIdx);
            LOG.info((Object)("waiting for the datanode to remove " + storageIdToRemove));
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    DatanodeStorageInfo[] infos;
                    DatanodeDescriptor dnDescriptor = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(datanodeToRemoveStorageFrom.getDatanodeUuid());
                    Assert.assertNotNull((Object)dnDescriptor);
                    for (DatanodeStorageInfo info : infos = dnDescriptor.getStorageInfos()) {
                        if (!info.getStorageID().equals(storageIdToRemove)) continue;
                        LOG.info((Object)("Still found storage " + storageIdToRemove + " on " + info + "."));
                        return false;
                    }
                    Assert.assertEquals((long)1L, (long)infos.length);
                    return true;
                }
            }, (int)10, (int)30000);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

